/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.wordpress.hooks;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum WPHookType {
    ACTION("add_action", Arrays.asList("do_action", "do_action_ref_array")),
    FILTER("add_filter", Arrays.asList("apply_filters", "apply_filters_ref_array"));

    private final String myRegistrationMethod;
    private final List<String> myInvocationMethods;

    private WPHookType(String registrationMethod, List<String> invocationMethods) {
        this.myRegistrationMethod = registrationMethod;
        this.myInvocationMethods = Collections.unmodifiableList(invocationMethods);
    }

    @NotNull
    @NonNls
    String getRegistrationMethodName() {
        String string = this.myRegistrationMethod;
        if (string == null) {
            WPHookType.$$$reportNull$$$0(0);
        }
        return string;
    }

    List<String> getInvocationMethodNames() {
        return this.myInvocationMethods;
    }

    public static String[] getRegistrationMethodNames() {
        WPHookType[] values = WPHookType.values();
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = values[i].getRegistrationMethodName();
        }
        return result;
    }

    @Nullable
    public static WPHookType findByInvocationMethod(@Nullable String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        for (WPHookType type : WPHookType.values()) {
            for (String methodName : type.getInvocationMethodNames()) {
                if (!methodName.equals(name)) continue;
                return type;
            }
        }
        return null;
    }

    @Nullable
    public static WPHookType findByRegistrationMethod(String name) {
        for (WPHookType type : WPHookType.values()) {
            if (!type.getRegistrationMethodName().equals(name)) continue;
            return type;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/wordpress/hooks/WPHookType", "getRegistrationMethodName"));
    }
}

