/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.execution;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.execution.NodeCommandLineState;
import com.jetbrains.nodejs.execution.NodeCommandLineStateKt;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a&\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a\u001a\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEBUG_PORT_ARG", "Lkotlin/text/Regex;", "getDEBUG_PORT_ARG", "()Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NODE_8_VERSION", "Lcom/intellij/util/text/SemVer;", "createDebugPortString", "", "debugPort", "", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "getDebugOptionsByInterpreter", "Lorg/jetbrains/concurrency/Promise;", "", "getInspectOptions", "version", "getInterpreterVersion", "intellij.nodeJS"})
public final class NodeCommandLineStateKt {
    private static final Logger LOG;
    private static final SemVer NODE_8_VERSION;
    @NotNull
    private static final Regex DEBUG_PORT_ARG;

    private static final Promise<List<String>> getDebugOptionsByInterpreter(int debugPort, NodeJsInterpreter interpreter) {
        Promise promise = NodeCommandLineStateKt.getInterpreterVersion(interpreter).then(new Function<T, SUB_RESULT>(debugPort, interpreter){
            final /* synthetic */ int $debugPort;
            final /* synthetic */ NodeJsInterpreter $interpreter;

            @NotNull
            public final List<String> fun(@Nullable SemVer it) {
                if (it != null && it.getMajor() <= 6) {
                    return CollectionsKt.listOf((Object[])new String[]{"--debug-brk=" + this.$debugPort, "--expose_debug_as=v8debug"});
                }
                return NodeCommandLineStateKt.access$getInspectOptions(it, this.$debugPort, this.$interpreter);
            }
            {
                this.$debugPort = n;
                this.$interpreter = nodeJsInterpreter;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"getInterpreterVersion(in\u2026t, interpreter)\n    }\n  }");
        return promise;
    }

    @NotNull
    public static final String createDebugPortString(int debugPort, @Nullable NodeJsInterpreter interpreter) {
        return interpreter instanceof NodeJsRemoteInterpreter ? "0.0.0.0:" + debugPort : String.valueOf(debugPort);
    }

    private static final List<String> getInspectOptions(SemVer version, int debugPort, NodeJsInterpreter interpreter) {
        String value = NodeCommandLineStateKt.createDebugPortString(debugPort, interpreter);
        return version == null || version.isGreaterOrEqualThan(7, 6, 0) ? CollectionsKt.listOf((Object)("--inspect-brk=" + value)) : CollectionsKt.listOf((Object[])new String[]{"--inspect=" + value, "--debug-brk"});
    }

    private static final Promise<SemVer> getInterpreterVersion(NodeJsInterpreter interpreter) {
        Promise promise;
        if (interpreter == null) {
            promise = Promises.resolvedPromise((Object)NODE_8_VERSION);
        } else if (interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron()) {
            promise = Promises.resolvedPromise((Object)NODE_8_VERSION);
        } else if (interpreter instanceof NodeJsRemoteInterpreter) {
            promise = Promises.resolvedPromise((Object)new SemVer("7.0.0", 7, 0, 0));
        } else {
            Promise promise2 = interpreter.provideCachedVersionOrFetch();
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"interpreter.provideCachedVersionOrFetch()");
            Promise promise3 = promise2;
            AsyncPromise uiPromise = new AsyncPromise();
            promise3.onSuccess((Consumer)new Consumer<SemVer>(uiPromise){
                final /* synthetic */ AsyncPromise $uiPromise;

                public final void accept(SemVer it) {
                    Application app$iv;
                    ModalityState modalityState$iv = null;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                    if (application.isDispatchThread()) {
                        this.$uiPromise.setResult((Object)it);
                    } else {
                        app$iv.invokeLater(new Runnable(this, it){
                            final /* synthetic */ getInterpreterVersion.1 this$0;
                            final /* synthetic */ SemVer $it$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$it$inlined = semVer;
                            }

                            public final void run() {
                                this.this$0.$uiPromise.setResult((Object)this.$it$inlined);
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
                {
                    this.$uiPromise = asyncPromise;
                }
            });
            promise3.onError((Consumer)new Consumer<Throwable>(uiPromise){
                final /* synthetic */ AsyncPromise $uiPromise;

                public final void accept(Throwable it) {
                    Application app$iv;
                    ModalityState modalityState$iv = null;
                    Application application = app$iv = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                    if (application.isDispatchThread()) {
                        Throwable throwable = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                        this.$uiPromise.setError(throwable);
                    } else {
                        app$iv.invokeLater(new Runnable(this, it){
                            final /* synthetic */ getInterpreterVersion.2 this$0;
                            final /* synthetic */ Throwable $it$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$it$inlined = throwable;
                            }

                            public final void run() {
                                AsyncPromise asyncPromise = this.this$0.$uiPromise;
                                Throwable throwable = this.$it$inlined;
                                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                                asyncPromise.setError(throwable);
                            }
                        }, ModalityState.defaultModalityState());
                    }
                }
                {
                    this.$uiPromise = asyncPromise;
                }
            });
            promise = (Promise)uiPromise;
        }
        return promise;
    }

    @NotNull
    public static final Regex getDEBUG_PORT_ARG() {
        return DEBUG_PORT_ARG;
    }

    static {
        Logger logger = Logger.getInstance(NodeCommandLineState.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(NodeC\u2026andLineState::class.java)");
        LOG = logger;
        NODE_8_VERSION = new SemVer("8.0.0", 8, 0, 0);
        DEBUG_PORT_ARG = new Regex("(?:" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{"--inspect=", "--inspect-brk=", "--debug=", "--debug-brk="}), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")(?:\\S+:)?(\\d+)");
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ Promise access$getDebugOptionsByInterpreter(int debugPort, @Nullable NodeJsInterpreter interpreter) {
        return NodeCommandLineStateKt.getDebugOptionsByInterpreter(debugPort, interpreter);
    }

    @NotNull
    public static final /* synthetic */ Promise access$getInterpreterVersion(@Nullable NodeJsInterpreter interpreter) {
        return NodeCommandLineStateKt.getInterpreterVersion(interpreter);
    }

    @NotNull
    public static final /* synthetic */ List access$getInspectOptions(@Nullable SemVer version, int debugPort, @Nullable NodeJsInterpreter interpreter) {
        return NodeCommandLineStateKt.getInspectOptions(version, debugPort, interpreter);
    }
}

