/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitExecutionUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestLocationProvider;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class NodeunitRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final ExecutionEnvironment myEnvironment;
    private final NodeunitSettings mySettings;

    protected NodeunitRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull NodeunitSettings settings) {
        if (environment == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(1);
        }
        this.myEnvironment = environment;
        this.mySettings = settings;
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.mySettings.getInterpreterRef().resolve(this.myEnvironment.getProject());
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)interpreter);
        ProcessHandler processHandler = this.startProcess(localInterpreter, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        File workingDir = new File(this.mySettings.getWorkingDirectory());
        NodeunitTestLocationProvider locator = new NodeunitTestLocationProvider(workingDir);
        ConsoleView consoleView = NodeunitExecutionUtils.createConsole(processHandler, this.myEnvironment, locator);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), workingDir));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), workingDir));
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(2);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ProcessHandler startProcess(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(3);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(CharsetToolkit.UTF8_CHARSET);
        this.mySettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.withWorkDirectory(this.mySettings.getWorkingDirectory());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)true);
        File mainFile = NodeunitRunProfileState.getNodeunitMainFile();
        commandLine.addParameter(mainFile.getAbsolutePath());
        commandLine.addParameter(this.mySettings.getNodeunitPackageDir());
        NodeunitTestType testType = this.mySettings.getTestType();
        if (testType == NodeunitTestType.DIRECTORY) {
            commandLine.addParameter(this.mySettings.getDirectory());
        } else {
            commandLine.addParameter(this.mySettings.getJsFile());
        }
        OSProcessHandler oSProcessHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        if (oSProcessHandler == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(4);
        }
        return oSProcessHandler;
    }

    @NotNull
    public static File getNodeunitMainFile() throws ExecutionException {
        File file;
        String relativePath = "nodeunit/nodeunit-intellij-starter.js";
        try {
            file = NodeJsCodeLocator.getFileRelativeToJsDir(relativePath);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot find " + relativePath, (Throwable)e);
        }
        if (file == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeunitMainFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

