/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.util.Parent;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Chain<T extends Parent<T>> {
    private final T myStart;
    private final List<Long> myIds;
    private ThreeState myState;
    private int myPatternLength;

    public Chain(T start, List<Long> ids) {
        this.myStart = start;
        this.myIds = ids;
        this.myState = ThreeState.UNSURE;
    }

    public int getPatternLength() {
        return this.myPatternLength;
    }

    public Chain setPatternLength(int patternLength) {
        this.myPatternLength = patternLength;
        return this;
    }

    public List<Long> getIds() {
        return this.myIds;
    }

    public Long get(int i) {
        return this.myIds.get(i);
    }

    public int size() {
        return this.myIds.size();
    }

    public T getStart() {
        return this.myStart;
    }

    public boolean isEmpty() {
        return this.myStart == null;
    }

    public boolean isRolled() {
        return ThreeState.YES.equals((Object)this.myState);
    }

    public Chain<T> rollUp(int patternLength) {
        this.myState = ThreeState.YES;
        this.myPatternLength = patternLength;
        return this;
    }

    public Chain<T> keep() {
        this.myState = ThreeState.NO;
        return this;
    }

    public ThreeState getState() {
        return this.myState;
    }

    public final List<Chain<T>> splitWithRollup(int from, int toExcluded, int patternLength) {
        assert (from >= 0);
        assert (toExcluded <= this.myIds.size());
        ArrayList<Chain<T>> list = new ArrayList<Chain<T>>();
        if (from > 0) {
            list.add(new Chain<T>(this.myStart, this.myIds.subList(0, from)));
        }
        T selectedStart = from == 0 ? this.myStart : Chain.moveX(this.myStart, from);
        list.add(new Chain<T>(selectedStart, this.myIds.subList(from, toExcluded)).rollUp(patternLength));
        if (toExcluded < this.myIds.size()) {
            list.add(new Chain<T>(Chain.moveX(this.myStart, toExcluded), this.myIds.subList(toExcluded, this.myIds.size())));
        }
        return list;
    }

    private static <S extends Parent<S>> S moveX(@NotNull S from, int steps) {
        if (from == null) {
            Chain.$$$reportNull$$$0(0);
        }
        Object current = from;
        for (int i = 0; i < steps; ++i) {
            assert (current.getChildren().size() == 1);
            current = (Parent)current.getChildren().get(0);
        }
        return current;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/jetbrains/nodejs/run/profile/cpu/calculation/Chain", "moveX"));
    }
}

