/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap;

import com.intellij.openapi.progress.ProgressIndicator;

public class TimeReporter {
    private final long myStart;
    private final String myName;
    private final ProgressIndicator myIndicator;
    private long myStage;

    public TimeReporter(String name, ProgressIndicator indicator) {
        this.myName = name;
        this.myIndicator = indicator;
        this.myStage = this.myStart = System.currentTimeMillis();
    }

    private void report(String s) {
        if (this.myIndicator != null) {
            this.myIndicator.setText(s);
        } else {
            System.out.println(s);
        }
    }

    public void reportTotal() {
        this.report(this.myName + " took: " + TimeReporter.formatDuration(System.currentTimeMillis() - this.myStart));
    }

    public void reportStage(String name) {
        long time = System.currentTimeMillis();
        this.report(name + " took: " + TimeReporter.formatDuration(time - this.myStage));
        this.myStage = time;
    }

    private static String formatDuration(long time) {
        if (time < 1000L) {
            return time + " ms";
        }
        return time / 1000L + " sec " + time % 1000L + " ms";
    }
}

