/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8HeapBiggestObjectsDiffComponent;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8HeapSummaryDiffComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.HeapViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8HeapDiffComponentPartner
implements HeapViewCreatorPartner<V8HeapTreeTable> {
    private final Project myProject;
    @NotNull
    private final V8DiffCachingReader myReader;
    @NotNull
    private final String myBaseName;
    @NotNull
    private final String myChangedName;

    public V8HeapDiffComponentPartner(Project project, @NotNull V8DiffCachingReader reader, @NotNull String baseName, @NotNull String changedName) {
        if (reader == null) {
            V8HeapDiffComponentPartner.$$$reportNull$$$0(0);
        }
        if (baseName == null) {
            V8HeapDiffComponentPartner.$$$reportNull$$$0(1);
        }
        if (changedName == null) {
            V8HeapDiffComponentPartner.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myBaseName = baseName;
        this.myChangedName = changedName;
    }

    @Override
    public JComponent wrapWithStandardActions(ProfilingView<V8HeapTreeTable> view, AnAction closeAction) {
        DefaultActionGroup group = new DefaultActionGroup();
        view.addActions(group);
        group.add(closeAction);
        return V8Utils.wrapWithActions(view.getMainComponent(), group);
    }

    @Override
    public void addViews(Project project, List<ProfilingView<V8HeapTreeTable>> list, Disposable disposable) {
        list.add(new V8HeapSummaryDiffComponent(this.myProject, this.myReader, this.myBaseName, this.myChangedName));
        list.add(new V8HeapBiggestObjectsDiffComponent(this.myProject, this.myReader, this.myBaseName, this.myChangedName));
    }

    @Override
    public String errorCreated() {
        return null;
    }

    @Override
    public void announceController(V8ProfilingMainComponent.MyController<V8HeapTreeTable> controller) {
    }

    @Override
    @Nullable
    public V8MainTreeNavigator getNavigator() {
        return null;
    }

    @Override
    public void reportInvolvedSnapshots(@NotNull Consumer<ByteArrayWrapper> digestConsumer) {
        if (digestConsumer == null) {
            V8HeapDiffComponentPartner.$$$reportNull$$$0(3);
        }
        digestConsumer.consume((Object)this.myReader.getBaseReader().getDigest());
        digestConsumer.consume((Object)this.myReader.getChangedReader().getDigest());
    }

    @Override
    public void close() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digestConsumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/diff/V8HeapDiffComponentPartner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportInvolvedSnapshots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

