/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.view.actions.EntryDataGetter;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class GoToSourceAction
extends AnAction {
    @NotNull
    private final V8CachingReader myReader;
    private TreeTable myTable;

    public GoToSourceAction(@NotNull V8CachingReader reader, TreeTable table) {
        if (reader == null) {
            GoToSourceAction.$$$reportNull$$$0(0);
        }
        super(ActionsBundle.actionText((String)"EditSource").replace("_", ""), ActionsBundle.actionDescription((String)"EditSource"), AllIcons.Actions.EditSource);
        this.myReader = reader;
        this.myTable = table;
    }

    public void setTable(TreeTable table) {
        this.myTable = table;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoToSourceAction.$$$reportNull$$$0(1);
        }
        EntryDataGetter getter = new EntryDataGetter(e.getDataContext(), this.myTable);
        V8HeapEntry data = getter.getData();
        e.getPresentation().setEnabled(data != null && data.getId() != 0L && getter.getProject() != null && !getter.isUnreachable() && (V8HeapNodeType.kObject.equals((Object)data.getType()) || V8HeapNodeType.kClosure.equals((Object)data.getType()) || V8HeapNodeType.kString.equals((Object)data.getType())));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        EntryDataGetter getter;
        Project project;
        if (e == null) {
            GoToSourceAction.$$$reportNull$$$0(2);
        }
        if ((project = (getter = new EntryDataGetter(e.getDataContext(), this.myTable)).getProject()) == null) {
            return;
        }
        V8HeapEntry entry = getter.getData();
        if (entry == null) {
            return;
        }
        boolean unreachable = getter.isUnreachable();
        if (unreachable) {
            return;
        }
        Long edgeId = getter.getSelectedEdgeId();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        JavaScriptIndex index = JavaScriptIndex.getInstance((Project)project);
        V8HeapEdge edge = edgeId == null ? null : this.myReader.getEdge(edgeId);
        NavigationItem[] items = edge != null && (V8HeapGraphEdgeType.kProperty.equals((Object)edge.getType()) || V8HeapGraphEdgeType.kContextVariable.equals((Object)edge.getType())) ? index.getSymbolsByName(this.myReader.getString(edge.getNameId()), true) : index.getSymbolsByName(this.myReader.getString(entry.getNameId()), true);
        if (items.length == 0) {
            NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification("Cannot find declaration to go to", MessageType.INFO).notify(project);
            return;
        }
        if (items.length == 1) {
            items[0].navigate(true);
            return;
        }
        ArrayList<Navigatable> list = new ArrayList<Navigatable>(items.length);
        for (NavigationItem item2 : items) {
            list.add((Navigatable)item2);
        }
        V8Utils.selectAndNavigate(e, list, (Consumer<Navigatable>)((Consumer)item -> item.navigate(true)), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/actions/GoToSourceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

