/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSRecordType
extends JSType {
    @NotNull
    public List<TypeMember> getTypeMembers();

    public boolean hasProperty(@NotNull String var1);

    @Nullable
    public PropertySignature findPropertySignature(@NotNull String var1);

    @Nullable
    public IndexSignature findIndexer(@NotNull IndexSignatureKind var1);

    @NotNull
    public List<CallSignature> getCallSignatures();

    @NotNull
    public Set<String> getPropertyNames();

    @NotNull
    public Collection<PropertySignature> getProperties();

    public boolean hasMembers();

    public boolean hasProperties();

    public boolean hasIndexers();

    public boolean isWeak();

    public static interface IndexSignature
    extends TypeMember {
        @NotNull
        public IndexSignatureKind getIndexSignatureKind();

        @NotNull
        public JSType getMemberParameterType();

        @NotNull
        public JSType getMemberType();

        @Override
        @NotNull
        public IndexSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);
    }

    public static enum IndexSignatureKind {
        STRING,
        NUMERIC,
        UNKNOWN;

    }

    public static interface CallSignature
    extends TypeMember {
        public boolean hasNew();

        @NotNull
        public JSFunctionType getFunctionType();

        @Override
        @NotNull
        public CallSignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

        @NotNull
        default public List<JSParameterTypeDecorator> getParameterTypeDecorators() {
            List<JSParameterTypeDecorator> list = this.getFunctionType().getParameters();
            if (list == null) {
                CallSignature.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        default public JSType getReturnType() {
            return this.getFunctionType().getReturnType();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSRecordType$CallSignature", "getParameterTypeDecorators"));
        }
    }

    public static interface PropertySignature
    extends TypeMember {
        @NotNull
        public String getMemberName();

        @Override
        @NotNull
        public PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

        public boolean isOptional();

        @Nullable
        public JSType getType();

        @NotNull
        default public JSAttributeList.AccessType getAccessType() {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                PropertySignature.$$$reportNull$$$0(0);
            }
            return accessType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSRecordType$PropertySignature", "getAccessType"));
        }
    }

    public static interface TypeMember {
        @Contract(pure=true)
        public boolean isEquivalentTo(@Nullable TypeMember var1, boolean var2);

        public int resolvedHashCode();

        @NotNull
        public MemberSource getMemberSource();

        @NotNull
        public TypeMember copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

        public void appendMemberPresentation(@NotNull JSType.TypeTextFormat var1, @NotNull StringBuilder var2, @NotNull String var3, char var4);

        public void acceptChildren(@NotNull JSRecursiveTypeVisitor var1);
    }

    public static interface MemberSource {
        public boolean isEmpty();

        public boolean isUnion();

        public boolean isMerged();

        public boolean isReadonly();

        public boolean isOptional();

        public boolean isIdentity();

        public boolean hasSingleDocumentation();

        @Nullable
        public PsiElement getSingleElement();

        @NotNull
        public List<PsiElement> getAllSourceElements();

        public MemberSource copyWithKind(MemberSourceKind var1);

        public MemberSourceKind getSourceKind();
    }

    public static enum MemberSourceKind {
        Empty,
        Identity,
        Union,
        Intersection,
        MappedNoStatus,
        MappedReadonly,
        MappedMinusReadonly,
        MappedOptional,
        MappedMinusOptional,
        MappedOptionalReadonly,
        MappedOptionalMinusReadonly,
        MappedMinusOptionalReadonly,
        MappedMinusOptionalMinusReadonly,
        CompositeSignature,
        TypeKey;


        public boolean isUnion() {
            return this == Union;
        }

        public static MemberSourceKind getMappedKind(boolean forceOptional, boolean forceNonOptional, boolean forceReadonly, boolean forceNonReadonly) {
            if (forceOptional) {
                return forceReadonly ? MappedOptionalReadonly : (forceNonReadonly ? MappedOptionalMinusReadonly : MappedOptional);
            }
            if (forceNonOptional) {
                return forceReadonly ? MappedMinusOptionalReadonly : (forceNonReadonly ? MappedMinusOptionalMinusReadonly : MappedMinusOptional);
            }
            return forceReadonly ? MappedReadonly : (forceNonReadonly ? MappedMinusReadonly : MappedNoStatus);
        }

        public boolean isMapped() {
            return this.ordinal() >= MappedNoStatus.ordinal() && this.ordinal() <= MappedMinusOptionalMinusReadonly.ordinal();
        }

        public boolean isTypeScriptMergedTypeKind() {
            return this == Union || this == Intersection || this.isMapped();
        }

        public boolean isForceReadonly() {
            return this == MappedReadonly || this == MappedOptionalReadonly || this == MappedMinusOptionalReadonly;
        }

        public boolean isForceNonReadonly() {
            return this == MappedMinusReadonly || this == MappedOptionalMinusReadonly || this == MappedMinusOptionalMinusReadonly;
        }

        public boolean isForceOptional() {
            return this == MappedOptional || this == MappedOptionalReadonly || this == MappedOptionalMinusReadonly;
        }

        public boolean isForceNonOptional() {
            return this == MappedMinusOptional || this == MappedMinusOptionalReadonly || this == MappedMinusOptionalMinusReadonly;
        }

        public boolean hasSingleDocumentation() {
            return this == Union || this == Intersection || this == Identity;
        }

        @Nullable
        public String getDescription() {
            if (this.isMapped()) {
                return JSBundle.message("typescript.types.mapped", new Object[0]);
            }
            if (this == Union) {
                return JSBundle.message("typescript.types.union", new Object[0]);
            }
            if (this == Intersection) {
                return JSBundle.message("typescript.types.intersection", new Object[0]);
            }
            if (this == TypeKey) {
                return JSBundle.message("typescript.types.key", new Object[0]);
            }
            return null;
        }
    }
}

