/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerRuntimeEditorBase {
    private final String myName;
    private final ParameterizedRunnable<DockerAgentContainerConfig> myOnSave;
    private JPanel myMainPanel;
    private JButton mySaveButton;

    public DockerRuntimeEditorBase(String name, ParameterizedRunnable<DockerAgentContainerConfig> onSave) {
        this.myName = name;
        this.myOnSave = onSave;
    }

    protected final void initControls(JPanel mainPanel, JButton saveButton) {
        this.myMainPanel = mainPanel;
        this.myMainPanel.putClientProperty("DataProvider", new DataProvider(){

            @Nullable
            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PlatformDataKeys.HELP_ID.is(dataId)) {
                    return DockerRuntimeEditorBase.this.getContextHelpId();
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/docker/view/DockerRuntimeEditorBase$1", "getData"));
            }
        });
        this.mySaveButton = saveButton;
        this.mySaveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerRuntimeEditorBase.this.save();
            }
        });
    }

    @Nullable
    protected String getContextHelpId() {
        return null;
    }

    private void save() {
        DockerAgentContainerConfig config = this.createConfig();
        if (config != null) {
            UIUtil.setEnabled((Component)this.myMainPanel, (boolean)false, (boolean)true);
            this.mySaveButton.setText("Saving...");
            this.myOnSave.run((Object)config);
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public String getName() {
        return this.myName;
    }

    protected abstract DockerAgentContainerConfig createConfig();
}

