/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class PhpCaches
implements ProjectComponent,
Disposable {
    private static final Key<PhpCaches> PHP_CACHES_KEY = Key.create((String)"PhpCaches");
    private final Project myProject;
    public static final int TYPE_CACHE_SIZE = 7000;
    public volatile Map<String, PhpType> TYPE_COMPLETION_CACHE = ContainerUtil.newConcurrentMap();
    public volatile Map<String, Collection<? extends PhpNamedElement>> SIGNATURES_CACHE = ContainerUtil.newConcurrentMap();
    public volatile Map<String, Collection<PhpClass>> subclassCache = ContainerUtil.newConcurrentMap();
    public volatile Map<String, Collection<PhpClass>> classCache = ContainerUtil.newConcurrentMap();
    public volatile Map<String, Collection<PhpClass>> interfaceCache = ContainerUtil.newConcurrentMap();
    public volatile Map<String, Collection<PhpClass>> traitCache = ContainerUtil.newConcurrentMap();
    public volatile Map<String, PhpClassAlias> classAliasCache = ContainerUtil.newConcurrentMap();
    public volatile Map<PsiElement, PhpType> TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));

    public PhpCaches(Project project) {
        this.myProject = project;
        LowMemoryWatcher.register(() -> this.clearCaches(true), (Disposable)project);
    }

    public void initComponent() {
        PsiModificationTracker.Listener modificationHandler = new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                PhpCaches.this.clearCaches(false);
            }
        };
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)modificationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches(boolean onLowMem) {
        if (this.TYPE_COMPLETION_CACHE.size() > 0) {
            this.TYPE_COMPLETION_CACHE = ContainerUtil.newConcurrentMap();
        }
        if (this.SIGNATURES_CACHE.size() > 0) {
            this.SIGNATURES_CACHE = ContainerUtil.newConcurrentMap();
        }
        if (this.classCache.size() > 0) {
            this.classCache = ContainerUtil.newConcurrentMap();
        }
        if (this.interfaceCache.size() > 0) {
            this.interfaceCache = ContainerUtil.newConcurrentMap();
        }
        if (this.traitCache.size() > 0) {
            this.traitCache = ContainerUtil.newConcurrentMap();
        }
        if (this.classAliasCache.size() > 0) {
            this.classAliasCache = ContainerUtil.newConcurrentMap();
        }
        if (this.subclassCache.size() > 0) {
            this.subclassCache = ContainerUtil.newConcurrentMap();
        }
        Map<PsiElement, PhpType> type_cache = this.TYPE_CACHE;
        if (!this.TYPE_CACHE.isEmpty()) {
            this.TYPE_CACHE = Collections.synchronizedMap(new WeakHashMap(1000));
            type_cache.clear();
        }
        String string = "VISITOR_RESULT_CACHE_LOCK";
        synchronized ("VISITOR_RESULT_CACHE_LOCK") {
            VariableImpl.VISITOR_RESULT_CACHE.clear();
            VariableImpl.VISITOR_RESULT_CACHE_GLOBAL.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void dispose() {
        this.clearCaches(true);
    }

    public static PhpCaches getInstance(Project project) {
        PhpCaches manager = (PhpCaches)project.getUserData(PHP_CACHES_KEY);
        if (manager == null) {
            manager = (PhpCaches)project.getComponent(PhpCaches.class);
            project.putUserData(PHP_CACHES_KEY, (Object)manager);
        }
        return manager;
    }
}

