/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.log;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.composer.actions.log.ComposerLogConsoleViewInterface;
import java.util.List;
import org.jetbrains.annotations.Nullable;

abstract class ComposerLogPrefixPrinter {
    private ComposerLogConsoleViewInterface.MessagePart myLastMessagePart;
    private boolean myFinishedWithNewLine = true;

    ComposerLogPrefixPrinter() {
    }

    public void print(String text, ComposerLogConsoleViewInterface.MessagePart part, @Nullable ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
        if (!this.myFinishedWithNewLine && this.myLastMessagePart != part) {
            this.doPrint("\n", ConsoleViewContentType.NORMAL_OUTPUT, null);
            this.myFinishedWithNewLine = true;
        }
        this.myLastMessagePart = part;
        List split = StringUtil.split((String)text, (String)"\n", (boolean)false, (boolean)true);
        for (String s : split) {
            if (this.myFinishedWithNewLine) {
                this.doPrint(part.getPrefix(), contentType, info);
            }
            this.doPrint(s, contentType, info);
            this.myFinishedWithNewLine = s.endsWith("\n");
        }
    }

    protected abstract void doPrint(String var1, @Nullable ConsoleViewContentType var2, @Nullable HyperlinkInfo var3);
}

