/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="PhpDebugGeneral", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=true)
public class PhpProjectDebugConfiguration
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(PhpProjectDebugConfiguration.class);
    private static final String LOCALHOST = "127.0.0.1";
    private State myState = new State();
    private static final int DEFAULT_DEBUG_PORT = 9000;
    private static final int DEFAULT_ZEND_DEBUGGER_DEBUG_PORT = 10137;
    private static final int DEFAULT_ZEND_DEBUGGER_SETTINGS_BROADCASTING_PORT = 20080;

    public static PhpProjectDebugConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            PhpProjectDebugConfiguration.$$$reportNull$$$0(0);
        }
        return (PhpProjectDebugConfiguration)ServiceManager.getService((Project)project, PhpProjectDebugConfiguration.class);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            PhpProjectDebugConfiguration.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpProjectDebugConfiguration.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    @NotNull
    public String getZendDebuggerHost() {
        State state = this.getState();
        if (!state.isZendDebuggerAutoDetectHosts()) {
            String string = state.getZendDebuggerConfiguredHosts();
            if (string == null) {
                PhpProjectDebugConfiguration.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = PhpProjectDebugConfiguration.detectIdeHostSynchronously();
        if (string == null) {
            PhpProjectDebugConfiguration.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String detectIdeHostSynchronously() throws ProcessCanceledException {
        String string;
        Ref isFinished = new Ref((Object)false);
        try {
            string = (String)ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    HashSet hosts = ContainerUtil.newHashSet((Object[])new String[]{InetAddress.getLocalHost().getHostAddress(), LOCALHOST});
                    Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
                    while (networks.hasMoreElements() && !((Boolean)isFinished.get()).booleanValue()) {
                        NetworkInterface network = networks.nextElement();
                        for (InterfaceAddress address : network.getInterfaceAddresses()) {
                            InetAddress broadcast = address.getBroadcast();
                            if (broadcast == null) continue;
                            hosts.add(address.getAddress().getHostAddress());
                        }
                    }
                    return StringUtil.join((Collection)hosts, (String)",");
                }
                catch (UnknownHostException e) {
                    return LOCALHOST;
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception while getting local host settings", (Throwable)e);
                    return LOCALHOST;
                }
            }).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            isFinished.set((Object)true);
            LOG.warn((Throwable)e);
            if (LOCALHOST == null) {
                PhpProjectDebugConfiguration.$$$reportNull$$$0(6);
            }
            return LOCALHOST;
        }
        if (string == null) {
            PhpProjectDebugConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpProjectDebugConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpProjectDebugConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getZendDebuggerHost";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectIdeHostSynchronously";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        private boolean mySafeEvaluationMode = true;
        private boolean myImportUseStatementsFromContext = true;
        private boolean myShowArrayChildrenInRepl = true;
        private boolean myHideEmptySuperglobals = true;
        private boolean myBreakAtFirstLine = false;
        private boolean myLocalPassConfigurationOptions = true;
        private boolean myIgnoreConnectionsThroughUnregisteredServers = false;
        private boolean myDetectPathMappingsFromDeploymentConfigurations = true;
        private int myMaxSimultaneousConnections = 3;
        private boolean myListeningStarted = false;
        private int myXDebugDebugPort = 9000;
        private boolean myXDebugShowAddresses = false;
        private boolean myXDebugCanAcceptExternalConnections = true;
        private boolean myXdebugForceBreakWhenNoPathMapping = true;
        private boolean myXdebugForceBreakWhenOutsideProject = true;
        private int myZendDebuggerDebugPort = 10137;
        private int myZendDebuggerSettingsBroadcastingPort = 20080;
        private boolean myZendDebuggerCanAcceptExternalConnections = true;
        private boolean myZendDebuggerAutoDetectIdeHosts = true;
        private String myZendDebuggerConfiguredIdeHosts = "";
        private boolean myZendDebuggerIgnoreZRaySystemRequests = true;
        private boolean myNotifyIfSessionWasFinishedWithoutBeingPaused = true;
        private boolean myShowPreConfigInRemoteDebug = true;
        private boolean myShowPreConfigInWebPage = true;

        @Attribute(value="safe_evaluation_mode")
        public boolean isSafeEvaluationMode() {
            return this.mySafeEvaluationMode;
        }

        public void setSafeEvaluationMode(boolean safeEvaluationMode) {
            this.mySafeEvaluationMode = safeEvaluationMode;
        }

        @Attribute(value="import_use_statements")
        public boolean isImportUseStatementsFromContext() {
            return this.myImportUseStatementsFromContext;
        }

        public void setImportUseStatementsFromContext(boolean importUseStatementsFromContext) {
            this.myImportUseStatementsFromContext = importUseStatementsFromContext;
        }

        @Attribute(value="show_array_childrent_in_repl")
        public boolean isShowArrayChildrenInRepl() {
            return this.myShowArrayChildrenInRepl;
        }

        public void setShowArrayChildrenInRepl(boolean showArrayChildrenInRepl) {
            this.myShowArrayChildrenInRepl = showArrayChildrenInRepl;
        }

        @Attribute(value="hide_empty_superglobals")
        public boolean isHideEmptySuperglobals() {
            return this.myHideEmptySuperglobals;
        }

        public void setHideEmptySuperglobals(boolean hideEmptySuperglobals) {
            this.myHideEmptySuperglobals = hideEmptySuperglobals;
        }

        @Attribute(value="break_at_first_line")
        public boolean isBreakAtFirstLine() {
            return this.myBreakAtFirstLine;
        }

        public void setBreakAtFirstLine(boolean breakAtFirstLine) {
            this.myBreakAtFirstLine = breakAtFirstLine;
        }

        @Attribute(value="local_pass_configuration_options")
        public boolean isLocalPassConfigurationOptions() {
            return this.myLocalPassConfigurationOptions;
        }

        public void setLocalPassConfigurationOptions(boolean localPassConfigurationOptions) {
            this.myLocalPassConfigurationOptions = localPassConfigurationOptions;
        }

        @Attribute(value="ignore_connections_through_unregistered_servers")
        public boolean isIgnoreConnectionsThroughUnregisteredServers() {
            return this.myIgnoreConnectionsThroughUnregisteredServers;
        }

        public void setIgnoreConnectionsThroughUnregisteredServers(boolean value) {
            this.myIgnoreConnectionsThroughUnregisteredServers = value;
        }

        @Attribute(value="detect_path_mappings_from_deployment_configuration")
        public boolean isDetectPathMappingsFromDeploymentConfigurations() {
            return this.myDetectPathMappingsFromDeploymentConfigurations;
        }

        public void setDetectPathMappingsFromDeploymentConfigurations(boolean detectPathMappingsFromDeploymentConfigurations) {
            this.myDetectPathMappingsFromDeploymentConfigurations = detectPathMappingsFromDeploymentConfigurations;
        }

        @Attribute(value="max_simultaneous_connections")
        public int getMaxSimultaneousConnections() {
            return this.myMaxSimultaneousConnections;
        }

        public void setMaxSimultaneousConnections(int maxSimultaneousConnections) {
            this.myMaxSimultaneousConnections = maxSimultaneousConnections;
        }

        @Attribute(value="xdebug_debug_can_accept_external_connections")
        public boolean isXDebugCanAcceptExternalConnections() {
            return this.myXDebugCanAcceptExternalConnections;
        }

        public void setXDebugCanAcceptExternalConnections(boolean XDebugCanAcceptExternalConnections) {
            this.myXDebugCanAcceptExternalConnections = XDebugCanAcceptExternalConnections;
        }

        @Attribute(value="xdebug_debug_port")
        public int getXDebugDebugPort() {
            return this.myXDebugDebugPort;
        }

        public void setXDebugDebugPort(int XDebugDebugPort) {
            this.myXDebugDebugPort = XDebugDebugPort;
        }

        @Attribute(value="xdebug_show_addresses")
        public boolean isXDebugShowAddresses() {
            return this.myXDebugShowAddresses;
        }

        public void setXDebugShowAddresses(boolean XDebugShowAddresses) {
            this.myXDebugShowAddresses = XDebugShowAddresses;
        }

        @Attribute(value="xdebug_force_break_when_no_path_mapping")
        public boolean isXdebugForceBreakWhenNoPathMapping() {
            return this.myXdebugForceBreakWhenNoPathMapping;
        }

        public void setXdebugForceBreakWhenNoPathMapping(boolean value) {
            this.myXdebugForceBreakWhenNoPathMapping = value;
        }

        @Attribute(value="xdebug_force_break_when_outside_project")
        public boolean isXdebugForceBreakWhenOutsideProject() {
            return this.myXdebugForceBreakWhenOutsideProject;
        }

        public void setXdebugForceBreakWhenOutsideProject(boolean xdebugForceBreakWhenOutsideProject) {
            this.myXdebugForceBreakWhenOutsideProject = xdebugForceBreakWhenOutsideProject;
        }

        @Attribute(value="zd_debug_port")
        public int getZendDebuggerDebugPort() {
            return this.myZendDebuggerDebugPort;
        }

        public void setZendDebuggerDebugPort(int zendDebuggerDebugPort) {
            this.myZendDebuggerDebugPort = zendDebuggerDebugPort;
        }

        @Attribute(value="zd_debug_can_accept_external_connections")
        public boolean isZendDebuggerCanAcceptExternalConnections() {
            return this.myZendDebuggerCanAcceptExternalConnections;
        }

        public void setZendDebuggerCanAcceptExternalConnections(boolean zendDebuggerCanAcceptExternalConnections) {
            this.myZendDebuggerCanAcceptExternalConnections = zendDebuggerCanAcceptExternalConnections;
        }

        @Attribute(value="zd_debug_auto_detect_ide_hosts")
        public boolean isZendDebuggerAutoDetectHosts() {
            return this.myZendDebuggerAutoDetectIdeHosts;
        }

        public void setZendDebuggerAutoDetectHosts(boolean zendDebuggerAutoDetectIdeHosts) {
            this.myZendDebuggerAutoDetectIdeHosts = zendDebuggerAutoDetectIdeHosts;
        }

        @Attribute(value="zd_debug_configured_ide_host")
        public String getZendDebuggerConfiguredHosts() {
            return this.myZendDebuggerConfiguredIdeHosts;
        }

        public void setZendDebuggerConfiguredHosts(String zendDebuggerConfiguredIdeHosts) {
            this.myZendDebuggerConfiguredIdeHosts = zendDebuggerConfiguredIdeHosts;
        }

        @Attribute(value="zd_debug_ignore_z_ray_system_requests")
        public boolean isZendDebuggerIgnoreZRaySystemRequests() {
            return this.myZendDebuggerIgnoreZRaySystemRequests;
        }

        public void setZendDebuggerIgnoreZRaySystemRequests(boolean zendDebuggerIgnoreZRaySystemRequests) {
            this.myZendDebuggerIgnoreZRaySystemRequests = zendDebuggerIgnoreZRaySystemRequests;
        }

        @Attribute(value="zd_settings_broadcasting_port")
        public int getZendDebuggerSettingsBroadcastingPort() {
            return this.myZendDebuggerSettingsBroadcastingPort;
        }

        public void setZendDebuggerSettingsBroadcastingPort(int zendDebuggerSettingsBroadcastingPort) {
            this.myZendDebuggerSettingsBroadcastingPort = zendDebuggerSettingsBroadcastingPort;
        }

        @Attribute(value="notify_if_session_was_finished_without_being_paused")
        public boolean isNotifyIfSessionWasFinishedWithoutBeingPaused() {
            return this.myNotifyIfSessionWasFinishedWithoutBeingPaused;
        }

        public void setNotifyIfSessionWasFinishedWithoutBeingPaused(boolean notifyIfSessionWasFinishedWithoutBeingPaused) {
            this.myNotifyIfSessionWasFinishedWithoutBeingPaused = notifyIfSessionWasFinishedWithoutBeingPaused;
        }

        @Attribute(value="listening_started")
        public boolean isListeningStarted() {
            return this.myListeningStarted;
        }

        public void setListeningStarted(boolean listeningStarted) {
            this.myListeningStarted = listeningStarted;
        }

        @Attribute(value="show_pre_config_in_remote_debug")
        public boolean isShowPreConfigInRemoteDebug() {
            return this.myShowPreConfigInRemoteDebug;
        }

        public void setShowPreConfigInRemoteDebug(boolean showPreConfigInRemoteDebug) {
            this.myShowPreConfigInRemoteDebug = showPreConfigInRemoteDebug;
        }

        @Attribute(value="show_pre_config_in_web_page")
        public boolean isShowPreConfigInWebPage() {
            return this.myShowPreConfigInWebPage;
        }

        public void setShowPreConfigInWebPage(boolean showPreConfigInWebPage) {
            this.myShowPreConfigInWebPage = showPreConfigInWebPage;
        }
    }
}

