/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointRemoveResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.BreakpointSetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ContextNamesResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpRequest;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ErrorResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.EvalResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.InitNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpErrorNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PhpUnknownNotification;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.PropertyValueResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ProxyInitResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.ProxyStopResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.SetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StackGetResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StatusResponse;
import com.jetbrains.php.debug.xdebug.dbgp.messages.StdoutNotification;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Base64;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbgpUtil {
    public static final String DBGP_PREFIX = "dbgp://";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final String BASE64 = "base64";
    public static final int DEFAULT_MAX_DEPTH = 3;
    public static final int DEFAULT_MAX_CHILDREN = 100;
    public static final Namespace DBGP_NAMESPACE = Namespace.getNamespace((String)"urn:debugger_protocol_v1");
    public static final String XDEBUG_NAMESPACE_PREFIX = "xdebug";
    public static final Namespace XDEBUG_NAMESPACE = Namespace.getNamespace((String)"xdebug", (String)"http://xdebug.org/dbgp/xdebug");
    public static final String ELEMENT_INIT = "init";
    public static final String ELEMENT_NOTIFY = "notify";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ELEMENT_CONTEXT = "context";
    public static final String ELEMENT_ERROR = "error";
    public static final String ELEMENT_MESSAGE = "message";
    public static final String ELEMENT_RESPONSE = "response";
    public static final String ELEMENT_STREAM = "stream";
    public static final String ATTR_RESPONSE_ID = "transaction_id";
    public static final String ATTR_RESPONSE_COMMAND = "command";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_EXCEPTION = "exception";
    public static final String ATTR_EXCEPTION_CODE = "code";
    public static final String ATTR_STACK = "stack";
    public static final String ATTR_LEVEL = "level";
    public static final String ATTR_LINENO = "lineno";
    public static final String ATTR_WHERE = "where";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_REASON = "reason";
    public static final String ATTR_SUCCESS = "success";
    public static final String ATTR_SUPPORTED = "supported";
    public static final String ATTR_STATE = "state";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ENCODING = "encoding";
    public static final String ATTR_IDEKEY = "idekey";
    public static final String STREAM_TYPE_STDOUT = "stdout";
    public static final String STREAM_TYPE_STDERR = "stderr";
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil");

    private DbgpUtil() {
    }

    @Nullable
    public static Element getXdebugMessageTag(@NotNull Element packet) {
        Element messageTag;
        if (packet == null) {
            DbgpUtil.$$$reportNull$$$0(0);
        }
        if ((messageTag = packet.getChild(ELEMENT_MESSAGE, XDEBUG_NAMESPACE)) != null) {
            return messageTag;
        }
        Namespace namespace = packet.getNamespace(XDEBUG_NAMESPACE_PREFIX);
        return packet.getChild(ELEMENT_MESSAGE, namespace);
    }

    @NotNull
    private static Element readDocumentFromProxyServer(@NotNull InputStream is) throws IOException {
        int size;
        int i;
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(1);
        }
        ByteArrayOutputStream packetSizeBuffer = new ByteArrayOutputStream();
        while ((i = is.read()) != 0 && i != -1) {
            packetSizeBuffer.write(i);
        }
        String text = packetSizeBuffer.toString("UTF-8");
        try {
            size = Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            Element element = DbgpUtil.parseDocument(text);
            if (element == null) {
                DbgpUtil.$$$reportNull$$$0(2);
            }
            return element;
        }
        Element element = DbgpUtil.getDocument(is, size);
        if (element == null) {
            DbgpUtil.$$$reportNull$$$0(3);
        }
        return element;
    }

    @NotNull
    private static Element readDocument(@NotNull InputStream is) throws IOException {
        int size;
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(4);
        }
        ByteArrayOutputStream packetSizeBuffer = new ByteArrayOutputStream();
        while (true) {
            int i;
            if ((i = is.read()) == -1) {
                throw new IOException("input stream is finished");
            }
            if (i == 0) break;
            packetSizeBuffer.write(i);
        }
        try {
            size = Integer.parseInt(packetSizeBuffer.toString("UTF-8"));
        }
        catch (NumberFormatException e) {
            LOG.warn("Invalid packet: cannot parse size, got " + DbgpUtil.dump(packetSizeBuffer));
            throw new IOException(PhpBundle.message("dbgp.invalid.packet", new Object[0]));
        }
        Element element = DbgpUtil.getDocument(is, size);
        if (element == null) {
            DbgpUtil.$$$reportNull$$$0(5);
        }
        return element;
    }

    @NotNull
    private static Element getDocument(@NotNull InputStream is, int size) throws IOException {
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(6);
        }
        ByteArrayOutputStream packetBuffer = new ByteArrayOutputStream(size);
        int count = 0;
        while (count++ <= size) {
            int i = is.read();
            if (i == -1) {
                throw new EOFException();
            }
            if (i == 0) {
                if (count >= size) continue;
                LOG.warn("Invalid packet size: " + count + " while expected " + size);
                LOG.warn("Last packet: " + DbgpUtil.dump(packetBuffer));
                throw new IOException(PhpBundle.message("dbgp.invalid.packet", new Object[0]));
            }
            packetBuffer.write(i);
        }
        Element element = DbgpUtil.parseDocument(packetBuffer.toString("UTF-8"));
        if (element == null) {
            DbgpUtil.$$$reportNull$$$0(7);
        }
        return element;
    }

    @NotNull
    public static Element parseDocument(@NotNull String is) throws IOException {
        Element element;
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(8);
        }
        StringBuilder packet = new StringBuilder(is);
        boolean dump = false;
        int i = 0;
        while (i < packet.length()) {
            char c = packet.charAt(i);
            if (Verifier.isXMLCharacter((int)c)) {
                ++i;
                continue;
            }
            LOG.warn("Illegal symbol in packet: 0x" + Integer.toHexString(c));
            dump = true;
            packet.deleteCharAt(i);
        }
        if (dump) {
            LOG.warn(is);
        }
        try {
            element = JdomKt.loadElement((CharSequence)packet);
        }
        catch (JDOMException e) {
            if (!dump) {
                LOG.warn("Could not parse packet", (Throwable)e);
                LOG.warn(is);
            } else {
                LOG.warn("Could not parse the last packet", (Throwable)e);
            }
            throw new IOException(PhpBundle.message("dbgp.invalid.packet", new Object[0]));
        }
        if (element == null) {
            DbgpUtil.$$$reportNull$$$0(9);
        }
        return element;
    }

    @NotNull
    private static DbgpInputMessage parsePacket(@NotNull Element packet) throws IOException {
        String rootTagName;
        if (packet == null) {
            DbgpUtil.$$$reportNull$$$0(10);
        }
        if (ELEMENT_RESPONSE.equals(rootTagName = packet.getName())) {
            String commandName = packet.getAttributeValue(ATTR_RESPONSE_COMMAND);
            if (commandName == null) {
                throw new IOException("Deserialization exception: Cannot find attribute command name in response");
            }
            Element errorTag = packet.getChild(ELEMENT_ERROR, DBGP_NAMESPACE);
            if (errorTag != null) {
                DbgpInputMessage dbgpInputMessage = new ErrorResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(11);
                }
                return dbgpInputMessage;
            }
            if (DbgpRequest.STATUS_RESPONSE_SET.contains(commandName.toLowerCase())) {
                DbgpInputMessage dbgpInputMessage = new StatusResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(12);
                }
                return dbgpInputMessage;
            }
            if ("breakpoint_set".equalsIgnoreCase(commandName.toLowerCase())) {
                DbgpInputMessage dbgpInputMessage = new BreakpointSetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(13);
                }
                return dbgpInputMessage;
            }
            if ("breakpoint_remove".equalsIgnoreCase(commandName.toLowerCase())) {
                DbgpInputMessage dbgpInputMessage = new BreakpointRemoveResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(14);
                }
                return dbgpInputMessage;
            }
            if ("eval".equalsIgnoreCase(commandName.toLowerCase())) {
                DbgpInputMessage dbgpInputMessage = new EvalResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(15);
                }
                return dbgpInputMessage;
            }
            if ("property_get".equalsIgnoreCase(commandName.toLowerCase())) {
                DbgpInputMessage dbgpInputMessage = new PropertyGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(16);
                }
                return dbgpInputMessage;
            }
            if ("property_value".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new PropertyValueResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(17);
                }
                return dbgpInputMessage;
            }
            if ("stack_get".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new StackGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(18);
                }
                return dbgpInputMessage;
            }
            if ("context_names".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new ContextNamesResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(19);
                }
                return dbgpInputMessage;
            }
            if ("context_get".equalsIgnoreCase(commandName)) {
                DbgpInputMessage dbgpInputMessage = new ContextGetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(20);
                }
                return dbgpInputMessage;
            }
            if (DbgpRequest.SET_RESPONSE_SET.contains(commandName.toLowerCase())) {
                DbgpInputMessage dbgpInputMessage = new SetResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(21);
                }
                return dbgpInputMessage;
            }
        } else if (ELEMENT_STREAM.equals(rootTagName)) {
            String streamType = packet.getAttributeValue(ATTR_TYPE);
            if (STREAM_TYPE_STDOUT.equals(streamType)) {
                DbgpInputMessage dbgpInputMessage = new StdoutNotification().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(22);
                }
                return dbgpInputMessage;
            }
        } else {
            if (ELEMENT_INIT.equals(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new InitNotification().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(23);
                }
                return dbgpInputMessage;
            }
            if (ELEMENT_NOTIFY.equals(rootTagName)) {
                String name = packet.getAttributeValue(ATTR_NAME);
                if (StringUtil.equals((CharSequence)name, (CharSequence)ELEMENT_ERROR)) {
                    DbgpInputMessage dbgpInputMessage = new PhpErrorNotification().deserialize(packet);
                    if (dbgpInputMessage == null) {
                        DbgpUtil.$$$reportNull$$$0(24);
                    }
                    return dbgpInputMessage;
                }
                DbgpInputMessage dbgpInputMessage = new PhpUnknownNotification().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(25);
                }
                return dbgpInputMessage;
            }
            if ("proxyinit".equalsIgnoreCase(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new ProxyInitResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(26);
                }
                return dbgpInputMessage;
            }
            if ("proxystop".equalsIgnoreCase(rootTagName)) {
                DbgpInputMessage dbgpInputMessage = new ProxyStopResponse().deserialize(packet);
                if (dbgpInputMessage == null) {
                    DbgpUtil.$$$reportNull$$$0(27);
                }
                return dbgpInputMessage;
            }
        }
        throw new IOException("Unknown dbgp root tag:" + rootTagName);
    }

    @NotNull
    public static DbgpInputMessage readMessage(@NotNull InputStream is) throws IOException {
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(28);
        }
        DbgpInputMessage dbgpInputMessage = DbgpUtil.parsePacket(DbgpUtil.readDocument(is));
        if (dbgpInputMessage == null) {
            DbgpUtil.$$$reportNull$$$0(29);
        }
        return dbgpInputMessage;
    }

    @NotNull
    public static DbgpInputMessage readMessageFromProxyServer(@NotNull InputStream is) throws IOException {
        if (is == null) {
            DbgpUtil.$$$reportNull$$$0(30);
        }
        DbgpInputMessage dbgpInputMessage = DbgpUtil.parsePacket(DbgpUtil.readDocumentFromProxyServer(is));
        if (dbgpInputMessage == null) {
            DbgpUtil.$$$reportNull$$$0(31);
        }
        return dbgpInputMessage;
    }

    @NotNull
    private static String dump(@NotNull ByteArrayOutputStream buffer) {
        if (buffer == null) {
            DbgpUtil.$$$reportNull$$$0(32);
        }
        String string = "BASE64[" + Base64.getEncoder().encodeToString(buffer.toByteArray()) + "]";
        if (string == null) {
            DbgpUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    public static String encode(String expression, String encoding) throws UnsupportedEncodingException {
        return Base64.getEncoder().encodeToString(expression.getBytes(encoding));
    }

    public static boolean toBoolean(@Nullable String value) {
        return TRUE.equals(value);
    }

    @NotNull
    public static String decodeUrl(@NotNull String url) {
        String string;
        if (url == null) {
            DbgpUtil.$$$reportNull$$$0(34);
        }
        try {
            string = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (null == null) {
                DbgpUtil.$$$reportNull$$$0(36);
            }
            return null;
        }
        if (string == null) {
            DbgpUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packet";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/DbgpUtil";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/DbgpUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readDocumentFromProxyServer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readDocument";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDocument";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePacket";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "readMessage";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "readMessageFromProxyServer";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getXdebugMessageTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readDocumentFromProxyServer";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readDocument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseDocument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsePacket";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readMessage";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "readMessageFromProxyServer";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "decodeUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

