/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtilRt;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpResponse;
import com.jetbrains.php.debug.xdebug.dbgp.model.DbgpStackFrame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class StackGetResponse
extends DbgpResponse {
    private final List<DbgpStackFrame> myStackFrames = new ArrayList<DbgpStackFrame>();

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        super.deserialize(packet);
        for (Element frameElement : packet.getChildren("stack", DbgpUtil.DBGP_NAMESPACE)) {
            int level = StringUtilRt.parseInt((String)frameElement.getAttributeValue("level"), (int)0);
            String remoteUrl = DbgpUtil.decodeUrl(frameElement.getAttributeValue("filename"));
            int line = StringUtilRt.parseInt((String)frameElement.getAttributeValue("lineno"), (int)0) - 1;
            String functionName = frameElement.getAttributeValue("where");
            this.myStackFrames.add(new DbgpStackFrame(level, remoteUrl, line, functionName));
        }
        return this;
    }

    public List<DbgpStackFrame> getStackFrames() {
        return this.myStackFrames;
    }
}

