/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPairedBraceMatcher
extends PairedBraceMatcherAdapter {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN, false), new BracePair(PhpTokenTypes.chLBRACKET, PhpTokenTypes.chRBRACKET, false), new BracePair(PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE, true), new BracePair(PhpTokenTypes.DOLLAR_LBRACE, PhpTokenTypes.chRBRACE, false)};
    private static final BracePair[] ALT_PAIRS = new BracePair[]{new BracePair(PhpTokenTypes.chLPAREN, PhpTokenTypes.chRPAREN, false), new BracePair(PhpTokenTypes.chLBRACKET, PhpTokenTypes.chRBRACKET, false), new BracePair(PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwELSE, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwELSEIF, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwENDIF, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwENDFOR, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwENDFOREACH, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwENDWHILE, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwENDSWITCH, true), new BracePair(PhpTokenTypes.opCOLON, PhpTokenTypes.kwENDDECLARE, true), new BracePair(PhpTokenTypes.DOLLAR_LBRACE, PhpTokenTypes.chRBRACE, false)};

    public PhpPairedBraceMatcher() {
        super((PairedBraceMatcher)new MyPairedBraceMatcher(), (Language)PhpLanguage.INSTANCE);
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        if (!PhpPairedBraceMatcher.altSyntaxEnabled()) {
            return super.isLBraceToken(iterator, fileText, fileType);
        }
        if (iterator.getTokenType() != PhpTokenTypes.opCOLON) {
            return super.isLBraceToken(iterator, fileText, fileType);
        }
        boolean result = true;
        int count = 0;
        do {
            IElementType tokenType;
            iterator.retreat();
            ++count;
            if (iterator.atEnd() || (tokenType = iterator.getTokenType()) == PhpTokenTypes.kwSWITCH || tokenType == PhpTokenTypes.kwELSE || tokenType == PhpTokenTypes.kwELSEIF || tokenType == PhpTokenTypes.kwIF) break;
            if (tokenType == PhpTokenTypes.kwCASE || tokenType == PhpTokenTypes.kwDEFAULT || tokenType == PhpTokenTypes.kwFUNCTION) {
                result = false;
            } else {
                if (tokenType != PhpTokenTypes.opQUEST) continue;
                result = false;
            }
            break;
        } while (count <= 50);
        while (count-- > 0) {
            iterator.advance();
        }
        return result;
    }

    public boolean isRBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        if (!PhpPairedBraceMatcher.altSyntaxEnabled()) {
            return super.isRBraceToken(iterator, fileText, fileType);
        }
        if (iterator.getTokenType() != PhpTokenTypes.kwELSE && iterator.getTokenType() != PhpTokenTypes.kwELSEIF) {
            return super.isRBraceToken(iterator, fileText, fileType);
        }
        boolean result = true;
        int count = 0;
        do {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            IElementType tokenType = iterator.getTokenType();
            if (tokenType != PhpTokenTypes.chRBRACE && tokenType != PhpTokenTypes.kwIF) continue;
            result = false;
            break;
        } while (count <= 50);
        while (count-- > 0) {
            iterator.advance();
        }
        return result;
    }

    private static boolean altSyntaxEnabled() {
        return Registry.is((String)"php.brace.alt.syntax", (boolean)false);
    }

    private static class MyPairedBraceMatcher
    implements PairedBraceMatcher {
        private MyPairedBraceMatcher() {
        }

        @NotNull
        public BracePair[] getPairs() {
            BracePair[] bracePairArray = PhpPairedBraceMatcher.altSyntaxEnabled() ? ALT_PAIRS : PAIRS;
            if (bracePairArray == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(0);
            }
            return bracePairArray;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType tokenType) {
            if (lbraceType == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(1);
            }
            return PhpTokenTypes.WHITE_SPACE == tokenType || PhpTokenTypes.COMMENTS.contains(tokenType) || tokenType == PhpTokenTypes.opSEMICOLON || tokenType == PhpTokenTypes.opCOMMA || tokenType == PhpTokenTypes.chRPAREN || tokenType == PhpTokenTypes.chRBRACKET || tokenType == PhpTokenTypes.chRBRACE || null == tokenType;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            PsiElement element = file.findElementAt(openingBraceOffset);
            if (element == null || element instanceof PsiFile) {
                return openingBraceOffset;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof GroupStatement) {
                parent = parent.getParent();
            }
            return parent.getTextRange().getStartOffset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpPairedBraceMatcher$MyPairedBraceMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lbraceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPairs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpPairedBraceMatcher$MyPairedBraceMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

