/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpGenerateFieldAccessorHandlerBase
implements LanguageCodeInsightActionHandler {
    private boolean myFluentSetters = false;
    @Nullable
    private static Customizer ourCustomizer;

    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PhpFile)) {
            return false;
        }
        PhpClass phpClass = PhpCodeEditUtil.findClassAtCaret(editor, file);
        return phpClass != null && !phpClass.isInterface();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PhpFile phpFile;
        PhpClass targetClass;
        if (project == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(2);
        }
        if ((targetClass = PhpCodeEditUtil.findClassAtCaret(editor, (PsiFile)(phpFile = (PhpFile)file))) == null) {
            return;
        }
        PhpNamedElementNode[] fieldsToShow = this.collectFields(targetClass);
        if (fieldsToShow.length == 0) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                HintManager.getInstance().showErrorHint(editor, this.getErrorMessage());
            }
            return;
        }
        PhpNamedElementNode[] members = this.chooseMembers(fieldsToShow, true, file.getProject());
        if (members == null || members.length == 0) {
            return;
        }
        int insertPos = PhpGenerateFieldAccessorHandlerBase.getSuitableEditorPosition(editor, phpFile);
        CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE);
        boolean currLineBreaks = settings.KEEP_LINE_BREAKS;
        int currBlankLines = settings.KEEP_BLANK_LINES_IN_CODE;
        settings.KEEP_LINE_BREAKS = false;
        settings.KEEP_BLANK_LINES_IN_CODE = 0;
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (editor == null) {
                PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(6);
            }
            if (project == null) {
                PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(7);
            }
            if (file == null) {
                PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(8);
            }
            int insertedElementCount = 0;
            PhpClassReferenceResolver resolver = new PhpClassReferenceResolver();
            StringBuffer textBuf = new StringBuffer();
            for (PhpNamedElementNode member : members) {
                PhpAccessorMethodData[] accessors;
                PsiElement field = member.getPsiElement();
                for (PhpAccessorMethodData accessor : accessors = this.createAccessors(targetClass, field)) {
                    if (accessor == null) continue;
                    PhpDocComment comment = accessor.getDocComment();
                    if (comment != null) {
                        PhpDocComment originalComment;
                        textBuf.append(comment.getText());
                        if (field instanceof Field && (originalComment = ((Field)field).getDocComment()) != null) {
                            resolver.processElement((PsiElement)originalComment);
                            ++insertedElementCount;
                        }
                    }
                    textBuf.append('\n');
                    textBuf.append(accessor.getMethod().getText());
                }
            }
            if (textBuf.length() > 0 && insertPos >= 0) {
                PhpPsiElement scope;
                editor.getDocument().insertString(insertPos, (CharSequence)textBuf);
                int endPos = insertPos + textBuf.length();
                CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)phpFile, insertPos, endPos);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                List<PsiElement> insertedElements = PhpGenerateFieldAccessorHandlerBase.collectInsertedElements(file, insertPos, insertedElementCount);
                if (insertedElements != null && !insertedElements.isEmpty() && (scope = PhpCodeInsightUtil.findScopeForUseOperator(insertedElements.get(0))) != null) {
                    resolver.importReferences(scope, insertedElements);
                }
            }
        });
        settings.KEEP_LINE_BREAKS = currLineBreaks;
        settings.KEEP_BLANK_LINES_IN_CODE = currBlankLines;
    }

    @Nullable
    private static List<PsiElement> collectInsertedElements(@NotNull PsiFile file, int startPos, int count) {
        PsiElement element;
        if (file == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(3);
        }
        if ((element = file.findElementAt(startPos)) == null) {
            return null;
        }
        ArrayList<PsiElement> inserted = new ArrayList<PsiElement>(count);
        PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, false);
        while (sibling != null && inserted.size() < count) {
            if (sibling instanceof PhpDocComment) {
                inserted.add(sibling);
            }
            sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(sibling, true);
        }
        return inserted;
    }

    protected abstract PhpAccessorMethodData[] createAccessors(PhpClass var1, PsiElement var2);

    protected abstract boolean isSelectable(PhpClass var1, Field var2);

    protected abstract String getErrorMessage();

    protected abstract boolean containsSetters();

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected PhpNamedElementNode[] chooseMembers(PhpNamedElementNode[] members, boolean allowEmptySelection, Project project) {
        PhpNamedElementNode[] nodes = PhpGenerateFieldAccessorHandlerBase.fixOrderToBeAsOriginalFiles(members).toArray(new PhpNamedElementNode[members.length]);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myFluentSetters = ourCustomizer != null && ourCustomizer.isFluentSetters();
            return nodes;
        }
        MyMemberChooser chooser = new MyMemberChooser(nodes, allowEmptySelection, project, this.containsSetters());
        chooser.setTitle("Choose Fields");
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        List list = chooser.getSelectedElements();
        this.myFluentSetters = chooser.isFluentSetters();
        return list == null ? null : list.toArray(new PhpNamedElementNode[0]);
    }

    @NotNull
    protected PhpNamedElementNode[] collectFields(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(4);
        }
        TreeMap<String, PhpNamedElementNode> nodes = new TreeMap<String, PhpNamedElementNode>();
        Collection fields = phpClass.getFields();
        for (Field field : fields) {
            if (field.isConstant() || !this.isSelectable(phpClass, field)) continue;
            nodes.put(field.getName(), new PhpNamedElementNode((PhpNamedElement)field));
        }
        PhpNamedElementNode[] phpNamedElementNodeArray = nodes.values().toArray(new PhpNamedElementNode[0]);
        if (phpNamedElementNodeArray == null) {
            PhpGenerateFieldAccessorHandlerBase.$$$reportNull$$$0(5);
        }
        return phpNamedElementNodeArray;
    }

    private static Collection<PhpNamedElementNode> fixOrderToBeAsOriginalFiles(PhpNamedElementNode[] selected) {
        ArrayList newSelected = ContainerUtil.newArrayList((Object[])selected);
        Collections.sort(newSelected, (o1, o2) -> {
            PsiFile containingFile2;
            PsiElement psiElement = o1.getPsiElement();
            PsiElement psiElement2 = o2.getPsiElement();
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == (containingFile2 = psiElement2.getContainingFile())) {
                return psiElement.getTextOffset() - psiElement2.getTextOffset();
            }
            return containingFile.getName().compareTo(containingFile2.getName());
        });
        return newSelected;
    }

    private static int getSuitableEditorPosition(Editor editor, PhpFile phpFile) {
        PsiElement currElement = phpFile.findElementAt(editor.getCaretModel().getOffset());
        if (currElement != null) {
            PsiElement prevParent = currElement;
            for (PsiElement parent = currElement.getParent(); parent != null && !(parent instanceof PhpFile); parent = parent.getParent()) {
                if (PhpGenerateFieldAccessorHandlerBase.isClassMember(parent)) {
                    return PhpGenerateFieldAccessorHandlerBase.getNextPos(parent);
                }
                if (parent instanceof PhpClass) {
                    while (prevParent != null) {
                        if (PhpGenerateFieldAccessorHandlerBase.isClassMember(prevParent) || PhpPsiUtil.isOfType(prevParent, PhpTokenTypes.chLBRACE)) {
                            return PhpGenerateFieldAccessorHandlerBase.getNextPos(prevParent);
                        }
                        prevParent = prevParent.getPrevSibling();
                    }
                    for (PsiElement classChild = parent.getFirstChild(); classChild != null; classChild = classChild.getNextSibling()) {
                        if (!PhpPsiUtil.isOfType(classChild, PhpTokenTypes.chLBRACE)) continue;
                        return PhpGenerateFieldAccessorHandlerBase.getNextPos(classChild);
                    }
                }
                prevParent = parent;
            }
        }
        return -1;
    }

    private static boolean isClassMember(PsiElement element) {
        if (element == null) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        return elementType == PhpElementTypes.CLASS_FIELDS || elementType == PhpElementTypes.CLASS_CONSTANTS || elementType == PhpStubElementTypes.CLASS_METHOD;
    }

    private static int getNextPos(PsiElement element) {
        PsiElement next = element.getNextSibling();
        return next != null ? next.getTextOffset() : -1;
    }

    public boolean isFluentSetters() {
        return this.myFluentSetters;
    }

    public static void setCustomizer(@Nullable Customizer customizer) {
        ourCustomizer = customizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectInsertedElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectFields";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMemberChooser
    extends MemberChooser<PhpNamedElementNode> {
        private static final String FLUENT_SETTERS_LABEL = "Fluent setters";
        @Nullable
        private final JCheckBox myFluentSettersBox;

        protected MyMemberChooser(@NotNull PhpNamedElementNode[] nodes, boolean allowEmptySelection, @NotNull Project project, boolean containsSetters) {
            if (nodes == null) {
                MyMemberChooser.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyMemberChooser.$$$reportNull$$$0(1);
            }
            super((ClassMember[])nodes, allowEmptySelection, true, project, null, MyMemberChooser.getAdditionalControls(containsSetters));
            JComponent[] optionControls = this.getOptionControls();
            this.myFluentSettersBox = optionControls != null && optionControls.length > 0 ? (JCheckBox)optionControls[0] : null;
            this.setupMemberFiltering();
        }

        @Nullable
        private static JComponent[] getAdditionalControls(boolean containsSetters) {
            if (containsSetters) {
                JCheckBox fluentSettersBox = new JCheckBox(FLUENT_SETTERS_LABEL);
                fluentSettersBox.setMnemonic(FLUENT_SETTERS_LABEL.charAt(0));
                return new JComponent[]{fluentSettersBox};
            }
            return null;
        }

        private void setupMemberFiltering() {
            if (this.myFluentSettersBox != null) {
                final PhpNamedElementNode[] nonStatic = this.filterNonStatic();
                this.myFluentSettersBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        HashSet currSelectedList = (HashSet)mySelectedElements.clone();
                        this.resetElements(myFluentSettersBox.isSelected() ? nonStatic : (PhpNamedElementNode[])myElements);
                        this.selectElements(currSelectedList.toArray(new PhpNamedElementNode[0]));
                    }
                });
            }
        }

        private PhpNamedElementNode[] filterNonStatic() {
            ArrayList<PhpNamedElementNode> result = new ArrayList<PhpNamedElementNode>();
            for (PhpNamedElementNode node : (PhpNamedElementNode[])this.myElements) {
                PsiElement psi = node.getPsiElement();
                if (!(psi instanceof Field) || ((Field)psi).getModifier().isStatic()) continue;
                result.add(node);
            }
            return result.toArray(new PhpNamedElementNode[0]);
        }

        public boolean isFluentSetters() {
            return this.myFluentSettersBox != null && this.myFluentSettersBox.isSelected();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateFieldAccessorHandlerBase$MyMemberChooser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Customizer {
        public boolean isFluentSetters();
    }
}

