/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpShellCommandExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpExpressionResultUnusedInspection
extends PhpInspection {
    public static final String PROBLEM_DESCRIPTION = PhpBundle.message("inspection.expression.result.unused.problem", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (!PhpLangUtil.isShortCircuitOperator(expression.getOperationType())) {
                    PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)expression, holder);
                }
            }

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                if (!PhpCodeInsightUtil.isIncrementOrDecrementExpression(expr) && !PhpCodeInsightUtil.isSilenceExpression(expr)) {
                    PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)expr, holder);
                }
            }

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)expression, holder);
            }

            public void visitPhpExpression(PhpExpression expression) {
                if (!(expression instanceof PhpShellCommandExpression)) {
                    PhpExpressionResultUnusedInspection.analyzeExpression(expression, holder);
                }
            }

            public void visitPhpEmpty(PhpEmpty emptyExpression) {
                PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)emptyExpression, holder);
            }

            public void visitPhpIsset(PhpIsset issetExpression) {
                PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)issetExpression, holder);
            }

            public void visitPhpVariable(Variable variable) {
                PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)variable, holder);
            }
        };
        if (phpElementVisitor == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void analyzeExpression(@NotNull PhpExpression psiElement, @NotNull ProblemsHolder holder) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(3);
        }
        if (!PhpCodeInsightUtil.isResultUsed((PsiElement)psiElement)) {
            holder.registerProblem((PsiElement)psiElement, PROBLEM_DESCRIPTION, new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpExpressionResultUnusedInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpExpressionResultUnusedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

