/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpRemoveStatementQuickFix;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PhpUnusedPrivateMethodInspection
extends PhpInspection {
    private static final int MAX_TRAIT_INVESTIGATION_DEPTH = 20;
    private static final String DESCRIPTION_TEMPLATE = PhpBundle.message("inspection.unused.private.method.problem.batch", new Object[0]);
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{new PhpRemoveStatementQuickFix("method", (Condition<PsiElement>)Method.INSTANCEOF)};
    public boolean SKIP_CONSTRUCT_METHOD = true;
    public boolean SKIP_CLONE_METHOD = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                PsiElement namePsiElement = method.getNameIdentifier();
                if (namePsiElement == null || namePsiElement.getTextLength() == 0) {
                    return;
                }
                if (method.getAccess().isPrivate()) {
                    final CharSequence name = method.getNameCS();
                    PhpClass clazz = method.getContainingClass();
                    if (clazz == null) {
                        return;
                    }
                    Method.MethodType methodType = method.getMethodType(false);
                    if (methodType == Method.MethodType.CONSTRUCTOR) {
                        if (!PhpUnusedPrivateMethodInspection.this.SKIP_CONSTRUCT_METHOD && !PhpUnusedPrivateMethodInspection.isObjectCreationExist(clazz)) {
                            this.registerProblem(namePsiElement);
                        }
                    } else if (PhpLangUtil.equalsMethodNames("__clone", name)) {
                        if (!PhpUnusedPrivateMethodInspection.this.SKIP_CLONE_METHOD && !PhpUnusedPrivateMethodInspection.isObjectCloneExist(clazz)) {
                            this.registerProblem(namePsiElement);
                        }
                    } else {
                        SearchScope searchScope = this.constructSearchScope(clazz);
                        boolean hasRefs = PhpPsiUtil.hasReferencesInSearchScope(searchScope, (PsiElement)method, (CommonProcessors.FindProcessor<? super PsiReference>)new CommonProcessors.FindProcessor<PsiReference>(){

                            protected boolean accept(PsiReference reference) {
                                if (reference instanceof MethodReference) {
                                    Method outerMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)((MethodReference)reference), true, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                                    return outerMethod == null || !PhpLangUtil.equalsMethodNames(outerMethod.getNameCS(), name);
                                }
                                return true;
                            }
                        });
                        if (!hasRefs) {
                            this.registerProblem(namePsiElement);
                        }
                    }
                }
            }

            @NotNull
            private SearchScope constructSearchScope(@NotNull PhpClass clazz) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (clazz.isTrait()) {
                    HashSet allUsages = ContainerUtil.newHashSet((Object[])new PhpClass[]{clazz});
                    this.processTraitUsage(clazz, allUsages, 0);
                    LocalSearchScope localSearchScope = new LocalSearchScope(allUsages.toArray(PsiElement.EMPTY_ARRAY));
                    if (localSearchScope == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return localSearchScope;
                }
                SearchScope searchScope = new LocalSearchScope((PsiElement)clazz).union(new LocalSearchScope((PsiElement[])clazz.getTraits()));
                if (searchScope == null) {
                    1.$$$reportNull$$$0(2);
                }
                return searchScope;
            }

            private void processTraitUsage(@NotNull PhpClass clazz, @NotNull Collection<PhpClass> allUsages, int depth) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (allUsages == null) {
                    1.$$$reportNull$$$0(4);
                }
                Collection classes = PhpIndex.getInstance((Project)clazz.getProject()).getTraitUsages(clazz);
                for (PhpClass aClass : classes) {
                    if (allUsages.contains(aClass)) continue;
                    allUsages.add(aClass);
                    if (depth >= 20 || !aClass.isTrait()) continue;
                    this.processTraitUsage(aClass, allUsages, depth + 1);
                }
            }

            private void registerProblem(@NotNull PsiElement namePsiElement) {
                if (namePsiElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                holder.registerProblem(namePsiElement, DESCRIPTION_TEMPLATE, ProblemHighlightType.LIKE_UNUSED_SYMBOL, FIXES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "allUsages";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "namePsiElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "constructSearchScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "constructSearchScope";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "processTraitUsage";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "registerProblem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (phpElementVisitor == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean isObjectCreationExist(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(2);
        }
        final String fqn = clazz.getFQN();
        PhpInspection.PhpReferenceSearchVisitor visitor = new PhpInspection.PhpReferenceSearchVisitor(){

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference reference = expression.getClassReference();
                if (reference != null && PhpLangUtil.equalsClassNames(fqn, reference.getFQN())) {
                    this.foundRef.set((Object)true);
                }
                super.visitPhpNewExpression(expression);
            }
        };
        clazz.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static boolean isObjectCloneExist(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpUnusedPrivateMethodInspection.$$$reportNull$$$0(3);
        }
        final String fqn = clazz.getFQN();
        PhpInspection.PhpReferenceSearchVisitor visitor = new PhpInspection.PhpReferenceSearchVisitor(){

            public void visitPhpUnaryExpression(UnaryExpression expr) {
                PhpPsiElement value;
                ASTNode node = expr.getNode();
                if (node != null && node.getElementType() == PhpElementTypes.CLONE_EXPRESSION && (value = expr.getValue()) instanceof PhpTypedElement) {
                    PhpType phpType = ((PhpTypedElement)value).getType();
                    for (String type : phpType.getTypes()) {
                        if (!PhpLangUtil.equalsClassNames(type, fqn)) continue;
                        this.foundRef.set((Object)true);
                    }
                }
                super.visitPhpUnaryExpression(expr);
            }
        };
        clazz.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpUnusedPrivateMethodInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isObjectCreationExist";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isObjectCloneExist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox constructMethodCheckBox;
        private JCheckBox cloneMethodCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.constructMethodCheckBox.setSelected(PhpUnusedPrivateMethodInspection.this.SKIP_CONSTRUCT_METHOD);
            this.constructMethodCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedPrivateMethodInspection.this.SKIP_CONSTRUCT_METHOD = OptionsPanel.this.constructMethodCheckBox.isSelected();
                }
            });
            this.cloneMethodCheckBox.setSelected(PhpUnusedPrivateMethodInspection.this.SKIP_CLONE_METHOD);
            this.cloneMethodCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpUnusedPrivateMethodInspection.this.SKIP_CLONE_METHOD = OptionsPanel.this.cloneMethodCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.cloneMethodCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.private.method.option.ignore.clone"));
            jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.constructMethodCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.unused.private.method.option.ignore.constructor"));
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

