/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.exception;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConstructorCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExceptionAnalysisService {
    private static final Logger LOG = Logger.getInstance(PhpExceptionAnalysisService.class);
    private static final Key<ParameterizedCachedValue<Map<String, SignatureList>, PsiFile>> GIST_KEY = Key.create((String)"PhpExceptionAnalysisService.GIST_KEY");
    private static final DataExternalizer<Map<String, SignatureList>> EXTERNALIZER = new DataExternalizer<Map<String, SignatureList>>(){

        public void save(@NotNull DataOutput out, Map<String, SignatureList> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (Map.Entry<String, SignatureList> entry : value.entrySet()) {
                out.writeUTF(entry.getKey());
                SignatureList list = entry.getValue();
                String[] exceptions = list.exceptions;
                out.writeInt(exceptions.length);
                for (String exception : exceptions) {
                    try {
                        out.writeUTF(exception);
                    }
                    catch (UTFDataFormatException e) {
                        out.writeUTF("");
                        LOG.error("Signature is too long to analyze", (Throwable)e, new Attachment[]{new Attachment("signature.txt", exception)});
                    }
                }
                Signature[] signatures = list.signatures;
                out.writeInt(signatures.length);
                for (Signature signature : signatures) {
                    this.writeTextRange(out, signature.thrownRange);
                    int[] thrownExceptions = signature.thrownExceptions;
                    out.writeInt(thrownExceptions.length);
                    for (int thrownException : thrownExceptions) {
                        out.writeInt(thrownException);
                    }
                    RangeCode[] coughExceptions = signature.coughExceptions;
                    out.writeInt(coughExceptions.length);
                    for (RangeCode coughException : coughExceptions) {
                        this.writeTextRange(out, coughException.range);
                        out.writeInt(coughException.code);
                    }
                }
            }
        }

        private void writeTextRange(@NotNull DataOutput out, @NotNull TextRange thrownRange) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(1);
            }
            if (thrownRange == null) {
                1.$$$reportNull$$$0(2);
            }
            out.writeInt(thrownRange.getStartOffset());
            out.writeInt(thrownRange.getEndOffset());
        }

        public Map<String, SignatureList> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(3);
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int valueSize = in.readInt();
            for (int i = 0; i < valueSize; ++i) {
                String name = in.readUTF();
                int exceptionsLength = in.readInt();
                String[] exceptions = ArrayUtil.newStringArray((int)exceptionsLength);
                for (int j = 0; j < exceptionsLength; ++j) {
                    exceptions[j] = in.readUTF();
                }
                int signaturesSize = in.readInt();
                Signature[] signatures = (Signature[])Signature.ARRAY_FACTORY.create(signaturesSize);
                for (int j = 0; j < signaturesSize; ++j) {
                    TextRange thrownRange = this.readTextRange(in);
                    int thrownExceptionsLength = in.readInt();
                    int[] thrownExceptions = ArrayUtil.newIntArray((int)thrownExceptionsLength);
                    for (int k = 0; k < thrownExceptionsLength; ++k) {
                        thrownExceptions[k] = in.readInt();
                    }
                    int coughExceptionsSize = in.readInt();
                    RangeCode[] coughExceptions = (RangeCode[])RangeCode.ARRAY_FACTORY.create(coughExceptionsSize);
                    for (int k = 0; k < coughExceptionsSize; ++k) {
                        coughExceptions[k] = new RangeCode(this.readTextRange(in), in.readInt());
                    }
                    signatures[j] = new Signature(thrownRange, thrownExceptions, coughExceptions);
                }
                builder.put((Object)name, (Object)new SignatureList(exceptions, signatures));
            }
            return builder.build();
        }

        @NotNull
        private TextRange readTextRange(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(4);
            }
            TextRange textRange = TextRange.create((int)in.readInt(), (int)in.readInt());
            if (textRange == null) {
                1.$$$reportNull$$$0(5);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thrownRange";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "writeTextRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "read";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readTextRange";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final NullableFunction<PsiFile, Map<String, SignatureList>> PROVIDER = file -> {
        THashMap map = ContainerUtil.newTroveMap();
        if (file instanceof PhpFile) {
            map.put(file.getName(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)((PhpFile)file)));
            for (PhpNamedElement element : ((PhpFile)file).getTopLevelDefs().values()) {
                if (element instanceof PhpNamespace || element instanceof Function) {
                    map.put(element.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)element));
                    continue;
                }
                if (!(element instanceof PhpClass)) continue;
                for (Method method : ((PhpClass)element).getOwnMethods()) {
                    if (method instanceof PhpDocMethod) continue;
                    map.put(method.getFQN(), LocalControlFlowProcessor.calculateSignatures((PhpScopeHolder)method));
                }
            }
        }
        return map;
    };
    private static final PsiFileGist<Map<String, SignatureList>> GIST = GistManager.getInstance().newPsiFileGist("PhpExceptionAnalysisService.GIST", 1, EXTERNALIZER, PROVIDER);
    private static final RecursionGuard GUARD = RecursionManager.createGuard((String)"PhpExceptionAnalysisService.GUARD");
    private static final Object[] PSI_MODIFICATION_COUNT = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
    private static final TIntObjectHashMap<Key<CachedValue<Set<String>>>> KEY_MAP;

    @NotNull
    public static Set<Pair<TextRange, String>> getThrownExceptionsWithRanges(@NotNull PhpScopeHolder scope, int depth, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(0);
        }
        THashSet exceptions = ContainerUtil.newTroveSet();
        BiConsumer<TextRange, String> collector = (arg_0, arg_1) -> PhpExceptionAnalysisService.lambda$getThrownExceptionsWithRanges$1((Set)exceptions, arg_0, arg_1);
        PhpExceptionAnalysisService.collectThrownExceptions(collector, scope, 0, depth, thrownRange, coughRange, strictThrownRangeComparison);
        THashSet tHashSet = exceptions;
        if (tHashSet == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    @NotNull
    public static Set<String> getThrownExceptions(@NotNull PhpScopeHolder scope, int depth, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(2);
        }
        Set<String> set = PhpExceptionAnalysisService.getThrownExceptions(scope, 0, depth, thrownRange, coughRange, strictThrownRangeComparison);
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Set<String> getThrownExceptions(@NotNull PhpScopeHolder scopeHolder, int level, int depth, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scopeHolder == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(4);
        }
        if (scopeHolder instanceof PhpDocMethod || GUARD.currentStack().contains(scopeHolder)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(5);
            }
            return set;
        }
        if (thrownRange != null || coughRange != null) {
            Set<String> set = PhpExceptionAnalysisService.getPreventingRecursion(scopeHolder, level, depth, thrownRange, coughRange, strictThrownRangeComparison);
            if (set == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set set = (Set)CachedValuesManager.getManager((Project)scopeHolder.getProject()).getCachedValue((UserDataHolder)scopeHolder, (Key)KEY_MAP.get(level), () -> {
            if (scopeHolder == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(25);
            }
            Set<String> exceptions = PhpExceptionAnalysisService.getPreventingRecursion(scopeHolder, level, depth, null, null, strictThrownRangeComparison);
            return CachedValueProvider.Result.create(exceptions, (Object[])PSI_MODIFICATION_COUNT);
        }, false);
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    private static Set<String> getPreventingRecursion(@NotNull PhpScopeHolder scope, int level, int depth, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(8);
        }
        Set set = (Set)GUARD.doPreventingRecursion((Object)scope, false, () -> {
            if (scope == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(24);
            }
            THashSet exceptions = ContainerUtil.newTroveSet();
            BiConsumer<TextRange, String> collector = (arg_0, arg_1) -> PhpExceptionAnalysisService.lambda$null$3((Set)exceptions, arg_0, arg_1);
            PhpExceptionAnalysisService.collectThrownExceptions(collector, scope, level, depth, thrownRange, coughRange, strictThrownRangeComparison);
            return !exceptions.isEmpty() ? exceptions : Collections.emptySet();
        });
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static void collectThrownExceptions(BiConsumer<TextRange, String> collector, @NotNull PhpScopeHolder scope, int level, int depth, @Nullable TextRange thrownRange, @Nullable TextRange coughRange, boolean strictThrownRangeComparison) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(10);
        }
        SignatureList list = PhpExceptionAnalysisService.loadSignatures(scope);
        Project project = scope.getProject();
        PhpIndex index = PhpIndex.getInstance((Project)project);
        for (Signature signature : list.signatures) {
            if (thrownRange != null && (strictThrownRangeComparison && !thrownRange.equals((Object)signature.thrownRange) || !strictThrownRangeComparison && !thrownRange.contains(signature.thrownRange))) continue;
            for (int thrownExceptionCode : signature.thrownExceptions) {
                String thrownException = list.exceptions[thrownExceptionCode];
                if (thrownException.length() < 5 || thrownException.charAt(2) != '?') {
                    PhpExceptionAnalysisService.addIfNotCough(collector, thrownException, signature, index, coughRange, list);
                    continue;
                }
                String kind = thrownException.substring(0, 2);
                String reference = thrownException.substring(3);
                if (level >= depth && "#C".equals(kind)) continue;
                for (PhpNamedElement phpNamedElement : PhpExceptionAnalysisService.getBySignature(reference, index)) {
                    if (!(phpNamedElement instanceof Function)) continue;
                    if ("#T".equals(kind)) {
                        for (String type : phpNamedElement.getType().global(project).getTypes()) {
                            PhpExceptionAnalysisService.addIfNotCough(collector, type, signature, index, coughRange, list);
                        }
                        continue;
                    }
                    if (!"#C".equals(kind)) continue;
                    List<PhpDocTag> tags = PhpDocUtil.collectTagsConsideringInheritance((Function)phpNamedElement, "@throws");
                    Set docExceptions = StreamEx.of(tags).map(PhpTypedElement::getType).flatCollection(PhpType::getTypes).toSet();
                    if (!docExceptions.isEmpty()) {
                        for (String type : docExceptions) {
                            for (String globalType : PhpExceptionAnalysisService.global(type, (PsiElement)phpNamedElement)) {
                                PhpExceptionAnalysisService.addIfNotCough(collector, globalType, signature, index, coughRange, list);
                            }
                        }
                        continue;
                    }
                    PhpScopeHolder newScope = (PhpScopeHolder)phpNamedElement;
                    for (String type : PhpExceptionAnalysisService.getThrownExceptions(newScope, level + 1, depth, null, null, strictThrownRangeComparison)) {
                        PhpExceptionAnalysisService.addIfNotCough(collector, type, signature, index, coughRange, list);
                    }
                }
            }
        }
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> getBySignature(@NotNull String reference, @NotNull PhpIndex index) {
        if (reference == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(11);
        }
        if (index == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(12);
        }
        if (reference.indexOf(124) > 0) {
            THashSet result = ContainerUtil.newTroveSet();
            for (String signature : reference.split("\\|")) {
                result.addAll(index.getBySignature(signature));
            }
            THashSet tHashSet = result;
            if (tHashSet == null) {
                PhpExceptionAnalysisService.$$$reportNull$$$0(13);
            }
            return tHashSet;
        }
        Collection collection = index.getBySignature(reference);
        if (collection == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    private static Set<String> global(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(16);
        }
        Set set = new PhpType().add(type).globalLocationAware(context).getTypes();
        if (set == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static void addIfNotCough(@NotNull BiConsumer<TextRange, String> collector, @NotNull String exception, @NotNull Signature signature, @NotNull PhpIndex index, @Nullable TextRange coughRange, @NotNull SignatureList list) {
        if (collector == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(18);
        }
        if (exception == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(19);
        }
        if (signature == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(20);
        }
        if (index == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(21);
        }
        if (list == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(22);
        }
        for (RangeCode coughException : signature.coughExceptions) {
            if (coughRange != null && !coughRange.contains(coughException.range) || !PhpType.findSuper((String)list.exceptions[coughException.code], (String)exception, (PhpIndex)index)) continue;
            return;
        }
        collector.accept(signature.thrownRange, exception);
    }

    private static SignatureList loadSignatures(@NotNull PhpScopeHolder scope) {
        if (scope == null) {
            PhpExceptionAnalysisService.$$$reportNull$$$0(23);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)scope.getProject());
        PsiFile containingFile = scope.getContainingFile();
        Map data = (Map)manager.getParameterizedCachedValue((UserDataHolder)containingFile, GIST_KEY, file -> CachedValueProvider.Result.create((Object)GIST.getFileData(file), (Object[])new Object[]{file}), false, (Object)containingFile);
        return data.getOrDefault(scope instanceof PhpNamedElement ? ((PhpNamedElement)scope).getFQN() : scope.getName(), SignatureList.EMPTY);
    }

    private static /* synthetic */ void lambda$null$3(Set exceptions, TextRange range, String exception) {
        exceptions.add(exception);
    }

    private static /* synthetic */ void lambda$getThrownExceptionsWithRanges$1(Set exceptions, TextRange range, String exception) {
        exceptions.add(Pair.create((Object)range, (Object)exception));
    }

    static {
        int depth = 3;
        TIntObjectHashMap map = new TIntObjectHashMap(3);
        for (int i = 0; i <= 3; ++i) {
            map.put(i, (Object)Key.create((String)("PhpExceptionAnalysisService.KEY.LEVEL" + i)));
        }
        KEY_MAP = map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService";
                break;
            }
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptionsWithRanges";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreventingRecursion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBySignature";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "global";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptionsWithRanges";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPreventingRecursion";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectThrownExceptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBySignature";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "global";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotCough";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "loadSignatures";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPreventingRecursion$4";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getThrownExceptions$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RangeCode {
        private static final RangeCode[] EMPTY_ARRAY = new RangeCode[0];
        private static final ArrayFactory<RangeCode> ARRAY_FACTORY = size -> size == 0 ? EMPTY_ARRAY : new RangeCode[size];
        private final TextRange range;
        private final int code;

        private RangeCode(@NotNull TextRange range, int code) {
            if (range == null) {
                RangeCode.$$$reportNull$$$0(0);
            }
            this.range = range;
            this.code = code;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$RangeCode", "<init>"));
        }
    }

    private static final class Signature {
        private static final Signature[] EMPTY_ARRAY = new Signature[0];
        private static final ArrayFactory<Signature> ARRAY_FACTORY = size -> size == 0 ? EMPTY_ARRAY : new Signature[size];
        private final TextRange thrownRange;
        private final int[] thrownExceptions;
        private final RangeCode[] coughExceptions;

        private Signature(@NotNull TextRange thrownRange, @NotNull int[] thrownExceptions, @NotNull RangeCode[] coughExceptions) {
            if (thrownRange == null) {
                Signature.$$$reportNull$$$0(0);
            }
            if (thrownExceptions == null) {
                Signature.$$$reportNull$$$0(1);
            }
            if (coughExceptions == null) {
                Signature.$$$reportNull$$$0(2);
            }
            this.thrownRange = thrownRange;
            this.thrownExceptions = thrownExceptions;
            this.coughExceptions = coughExceptions;
        }

        static /* synthetic */ Signature[] access$1400() {
            return EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thrownRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thrownExceptions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "coughExceptions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$Signature";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SignatureList {
        private static final SignatureList EMPTY = new SignatureList(ArrayUtil.EMPTY_STRING_ARRAY, Signature.access$1400());
        private final String[] exceptions;
        private final Signature[] signatures;

        private SignatureList(@NotNull String[] exceptions, @NotNull Signature[] signatures) {
            if (exceptions == null) {
                SignatureList.$$$reportNull$$$0(0);
            }
            if (signatures == null) {
                SignatureList.$$$reportNull$$$0(1);
            }
            this.exceptions = exceptions;
            this.signatures = signatures;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exceptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "signatures";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$SignatureList";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LocalControlFlowProcessor
    extends PhpInstructionProcessor {
        private static final String THROW = "#T";
        private static final String CALL = "#C";
        private static final char SEPARATOR = '?';
        private final TObjectIntHashMap<String> exceptions = new TObjectIntHashMap();
        private final List<Signature> signatures = ContainerUtil.newArrayList();

        private LocalControlFlowProcessor() {
        }

        @NotNull
        private static SignatureList calculateSignatures(@NotNull PhpScopeHolder scope) {
            if (scope == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(0);
            }
            LocalControlFlowProcessor processor = new LocalControlFlowProcessor();
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)scope.getControlFlow().getExitPoint(), false, processor);
            SignatureList signatureList = new SignatureList(LocalControlFlowProcessor.toArray(processor.exceptions), (Signature[])ContainerUtil.toArray(processor.signatures, (ArrayFactory)Signature.ARRAY_FACTORY));
            if (signatureList == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(1);
            }
            return signatureList;
        }

        @NotNull
        private static String[] toArray(@NotNull TObjectIntHashMap<String> exceptions) {
            if (exceptions == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(2);
            }
            String[] array = ArrayUtil.newStringArray((int)exceptions.size());
            exceptions.forEachEntry((s, i) -> {
                array[i] = s;
                return true;
            });
            if (array == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(3);
            }
            return array;
        }

        public boolean processThrowInstruction(PhpThrowInstruction instruction) {
            Set types;
            TextRange thrownRange = instruction.getStatement().getTextRange();
            PsiElement argument = instruction.getArgument();
            if (argument instanceof NewExpression) {
                String fqn;
                ClassReference thrownException = ((NewExpression)argument).getClassReference();
                if (thrownException != null && (fqn = thrownException.getFQN()) != null) {
                    int[] thrownExceptions = new int[]{this.getCode(fqn)};
                    this.signatures.add(new Signature(thrownRange, thrownExceptions, this.getCoughExceptions(instruction.getCatchTargets())));
                }
            } else if (argument instanceof FunctionReference || argument instanceof Variable) {
                Set types2 = ((PhpReference)argument).resolveLocalType().filterNull().getTypes();
                if (types2.isEmpty()) {
                    List exceptions = StringUtil.split((String)((PhpReference)argument).getSignature(), (String)"|");
                    int[] thrownExceptions = new int[exceptions.size()];
                    for (int i = 0; i < exceptions.size(); ++i) {
                        thrownExceptions[i] = this.getCode("#T?" + (String)exceptions.get(i));
                    }
                    this.signatures.add(new Signature(thrownRange, thrownExceptions, this.getCoughExceptions(instruction.getCatchTargets())));
                } else {
                    TIntHashSet thrownExceptions = new TIntHashSet();
                    for (String exception : types2) {
                        if (argument instanceof Variable && types2.size() > 1 && "\\Exception".equals(exception) && ((Variable)argument).resolveLocal().stream().anyMatch(v -> v.getParent() instanceof Catch)) continue;
                        if (PhpType.isUnresolved((String)exception)) {
                            thrownExceptions.add(this.getCode("#T?" + exception));
                            continue;
                        }
                        thrownExceptions.add(this.getCode(exception));
                    }
                    if (!thrownExceptions.isEmpty()) {
                        this.signatures.add(new Signature(thrownRange, thrownExceptions.toArray(), this.getCoughExceptions(instruction.getCatchTargets())));
                    }
                }
            } else if (argument instanceof PhpExpression && !(types = ((PhpExpression)argument).getType().getTypes()).isEmpty()) {
                TIntHashSet thrownExceptions = new TIntHashSet();
                for (String exception : types) {
                    if (PhpType.isUnresolved((String)exception)) {
                        thrownExceptions.add(this.getCode("#T?" + exception));
                        continue;
                    }
                    thrownExceptions.add(this.getCode(exception));
                }
                this.signatures.add(new Signature(thrownRange, thrownExceptions.toArray(), this.getCoughExceptions(instruction.getCatchTargets())));
            }
            return true;
        }

        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            FunctionReference functionReference = instruction.getFunctionReference();
            TextRange thrownRange = functionReference.getTextRange();
            List exceptions = StringUtil.split((String)functionReference.getSignature(), (String)"|");
            int[] thrownExceptions = new int[exceptions.size()];
            for (int i = 0; i < exceptions.size(); ++i) {
                thrownExceptions[i] = this.getCode("#C?" + (String)exceptions.get(i));
            }
            RangeCode[] coughExceptions = this.getCoughExceptions(instruction.getCatchTargets());
            this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions));
            return true;
        }

        public boolean processConstructorCallInstruction(PhpConstructorCallInstruction instruction) {
            NewExpression newExpression = instruction.getNewExpression();
            ClassReference classReference = newExpression.getClassReference();
            if (classReference != null) {
                TextRange thrownRange = newExpression.getTextRange();
                String signature = PhpTypeSignatureKey.METHOD.sign((CharSequence)(classReference.getSignature() + "." + "__construct"));
                int[] thrownExceptions = new int[]{this.getCode("#C?" + signature)};
                RangeCode[] coughExceptions = this.getCoughExceptions(instruction.getCatchTargets());
                this.signatures.add(new Signature(thrownRange, thrownExceptions, coughExceptions));
            }
            return true;
        }

        private RangeCode[] getCoughExceptions(@NotNull Collection<PhpHostInstruction> catchTargets) {
            if (catchTargets == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(4);
            }
            List coughExceptions = ContainerUtil.newSmartList();
            for (PhpHostInstruction catchTarget : catchTargets) {
                for (PhpInstruction successor : catchTarget.getSuccessors()) {
                    if (!(successor instanceof PhpCatchConditionInstruction)) continue;
                    PhpCatchConditionInstruction catchCondition = (PhpCatchConditionInstruction)successor;
                    Variable variable = catchCondition.getException();
                    TextRange coughRange = variable != null ? variable.getTextRange() : null;
                    for (ClassReference coughException : catchCondition.getExceptionTypes()) {
                        String fqn = coughException.getFQN();
                        if (fqn == null) continue;
                        coughExceptions.add(new RangeCode(coughRange != null ? coughRange : coughException.getTextRange(), this.getCode(fqn)));
                    }
                }
            }
            return (RangeCode[])ContainerUtil.toArray((Collection)coughExceptions, (ArrayFactory)RangeCode.ARRAY_FACTORY);
        }

        private int getCode(@NotNull String exception) {
            if (exception == null) {
                LocalControlFlowProcessor.$$$reportNull$$$0(5);
            }
            if (this.exceptions.containsKey((Object)exception)) {
                return this.exceptions.get((Object)exception);
            }
            int i = this.exceptions.size();
            this.exceptions.put((Object)exception, i);
            return i;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptions";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchTargets";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exception";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/exception/PhpExceptionAnalysisService$LocalControlFlowProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateSignatures";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calculateSignatures";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCoughExceptions";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

