/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.UpdatePhpDocQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDocSignatureInspection
extends PhpInspection {
    static final UpdatePhpDocQuickFix UPDATE_PHP_DOC_QUICK_FIX = new UpdatePhpDocQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX};
    private static final PhpType TRUE_FALSE = PhpType.builder().add("true").add("false").build();
    public boolean ALLOW_MISSING_PARAMETERS = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || docComment.hasInheritDocTag() || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                PhpDocSignatureInspection.this.checkSignature(docComment, function, holder);
            }

            public void visitPhpMethod(Method method) {
                this.visitPhpFunction((Function)method);
            }
        };
        if (phpElementVisitor == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PhpBundle.message("inspection.doc.signature", new Object[0]);
        if (string == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void checkSignature(@NotNull PhpDocComment comment, @NotNull Function function, ProblemsHolder holder) {
        if (comment == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(3);
        }
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(4);
        }
        Parameter[] parameters = function.getParameters();
        LinkedHashMap<String, PhpDocParamTag> paramTags = PhpDocSignatureInspection.getNonGlobalTags(comment, function, holder);
        LinkedHashMap parameterMap = new LinkedHashMap();
        for (Parameter parameter : parameters) {
            String paramName = parameter.getName();
            if (StringUtil.isEmpty((String)paramName)) continue;
            parameterMap.put(paramName, parameter);
            if (paramTags.containsKey((Object)paramName)) {
                PhpType docType = PhpDocUtil.getParamType((PhpDocTag)paramTags.get((Object)paramName), function);
                if (PhpDocSignatureInspection.typesMatch(function.getProject(), docType, PhpDocUtil.getParameterType(parameter))) continue;
                holder.registerProblem((PsiElement)paramTags.get((Object)paramName), "Argument type does not match", FIXES);
                continue;
            }
            if (this.ALLOW_MISSING_PARAMETERS && parameter.getFirstPsiChild() != null) continue;
            holder.registerProblem((PsiElement)parameter, "Argument PHPDoc missing", FIXES);
        }
        for (String name : paramTags.keySet()) {
            if (parameterMap.containsKey(name)) continue;
            holder.registerProblem((PsiElement)paramTags.get((Object)name), "PHPDoc for non-existing argument", FIXES);
        }
        PhpDocReturnTag returnTag = comment.getReturnTag();
        if (returnTag == null) {
            return;
        }
        if (!PhpDocSignatureInspection.returnTypesMatch(returnTag, function)) {
            holder.registerProblem((PsiElement)returnTag, "Return type does not match", FIXES);
        }
    }

    private static LinkedHashMap<String, PhpDocParamTag> getNonGlobalTags(PhpDocComment comment, Function function, ProblemsHolder holder) {
        LinkedHashMap nonGlobalTags = new LinkedHashMap();
        int paramIndex = 0;
        Parameter[] funcParameters = function.getParameters();
        for (PhpDocParamTag paramTag : comment.getParamTags()) {
            if (paramTag.getName().equals("@global")) continue;
            String paramName = PhpDocUtil.getParamName((PhpDocTag)paramTag, function);
            if (paramName == null) {
                String string = paramName = paramIndex < funcParameters.length ? funcParameters[paramIndex].getName() : null;
            }
            if (paramName != null && nonGlobalTags.put((Object)paramName, (Object)paramTag) != null) {
                holder.registerProblem((PsiElement)paramTag, "Duplicate argument PHPDoc", FIXES);
            }
            ++paramIndex;
        }
        return nonGlobalTags;
    }

    static boolean typesMatch(Project project, PhpType docType, PhpType paramType) {
        return PhpDocSignatureInspection.typesMatch(docType, paramType, PhpIndex.getInstance((Project)project), true);
    }

    private static boolean typesMatch(PhpType docType, PhpType paramType, PhpIndex index, boolean strict) {
        return (paramType = paramType.filterNull().filterUnknown()).isEmpty() || PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)paramType) || PhpType.intersects((PhpType)PhpType.MIXED, (PhpType)docType) || docType.equals((Object)paramType) || PhpType.isSubType((PhpType)paramType, (PhpType)docType) || !strict && PhpType.isSubType((PhpType)docType, (PhpType)paramType) || docType.getTypes().stream().anyMatch(PhpType::isPluralType) && paramType.getTypes().stream().anyMatch(PhpType::isArray) || PhpType.intersects((PhpType)TRUE_FALSE, (PhpType)docType) && PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)paramType) || PhpType.intersects((PhpType)PhpType.BOOLEAN, (PhpType)docType) && PhpType.intersects((PhpType)TRUE_FALSE, (PhpType)paramType) || PhpType.ITERABLE.equals((Object)paramType) && PhpType.ITERABLE.isConvertibleFrom(docType, index);
    }

    static boolean returnTypesMatch(@NotNull PhpDocReturnTag tag, @NotNull Function function) {
        PhpType tagType;
        if (tag == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(5);
        }
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(6);
        }
        if ((tagType = tag.getType().globalLocationAware((PsiElement)function)).isEmpty()) {
            return false;
        }
        PhpType declaredType = function.getDeclaredType().globalLocationAware((PsiElement)function);
        PhpIndex index = PhpIndex.getInstance((Project)function.getProject());
        if (!declaredType.isEmpty()) {
            if (tagType.isNotExtendablePrimitiveType()) {
                return PhpDocSignatureInspection.typesMatch(tagType, declaredType, index, false);
            }
            return declaredType.isConvertibleFrom(tagType, PhpIndex.getInstance((Project)function.getProject()));
        }
        PhpType inferredType = function.getInferredType().globalLocationAware((PsiElement)function);
        return tagType.isConvertibleFrom(inferredType, index) || inferredType.isConvertibleFrom(tagType, index);
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkSignature";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "returnTypesMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myAllowMissingParameters;

        private OptionsPanel() {
            this.$$$setupUI$$$();
            this.myAllowMissingParameters.setSelected(PhpDocSignatureInspection.this.ALLOW_MISSING_PARAMETERS);
            this.myAllowMissingParameters.getModel().addChangeListener(e -> {
                PhpDocSignatureInspection.this.ALLOW_MISSING_PARAMETERS = this.myAllowMissingParameters.isSelected();
            });
        }

        private JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBCheckBox jBCheckBox = new JBCheckBox();
            this.myAllowMissingParameters = jBCheckBox;
            jBCheckBox.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.doc.signature.option.allow.missing.parameters.with.type.hints"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

