/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeParameterTypeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpIncompatibleReturnTypeInspection;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStrictTypeCheckingInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){
            private Boolean strict;

            private synchronized boolean isStrict(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.strict == null) {
                    PhpFile file = (PhpFile)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpFile.INSTANCEOF);
                    this.strict = file != null && PhpCodeInsightUtil.isStrictTypes(file);
                }
                return this.strict;
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                PhpType declaredType;
                Project project = returnStatement.getProject();
                if (!PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.RETURN_TYPES)) {
                    return;
                }
                if (!this.isStrict((PsiElement)returnStatement)) {
                    return;
                }
                Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
                Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
                if (function != null && PhpStrictTypeCheckingInspection.isScalar(declaredType = function.getDeclaredType())) {
                    List<PsiElement> arguments = PhpIncompatibleReturnTypeInspection.collectArguments(returnStatement);
                    for (PsiElement argument : arguments) {
                        Object inferredType = argument instanceof PhpTypedElement ? ((PhpTypedElement)argument).getType().global(project).filterUnknown() : (argument == null ? PhpType.VOID : null);
                        if (inferredType == null || PhpStrictTypeCheckingInspection.canAccept(declaredType, inferredType)) continue;
                        holder.registerProblem((PsiElement)(arguments.size() == 1 || argument == null ? returnStatement : argument), isOnTheFly ? PhpBundle.message("inspection.strict.type.checking.return", declaredType, inferredType.toStringRelativized(function.getNamespaceName())) : PhpBundle.message("inspection.strict.type.checking.return.batch", new Object[0]), new LocalQuickFix[]{PhpStrictTypeCheckingInspection.isScalar(inferredType) ? new PhpChangeReturnTypeQuickFix(declaredType, (PhpType)inferredType) : null});
                    }
                }
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.visitFunctionCall((ParameterListOwner)reference, (PhpReference)reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.visitFunctionCall((ParameterListOwner)reference, (PhpReference)reference);
            }

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference reference = expression.getClassReference();
                if (reference != null) {
                    this.visitFunctionCall((ParameterListOwner)expression, (PhpReference)reference);
                }
            }

            private void visitFunctionCall(@NotNull ParameterListOwner parameterListOwner, @NotNull PhpReference reference) {
                ResolveResult[] results;
                Project project;
                if (parameterListOwner == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (reference == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!PhpProjectConfigurationFacade.getInstance(project = parameterListOwner.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.SCALAR_TYPE_HINTS)) {
                    return;
                }
                if (!this.isStrict((PsiElement)parameterListOwner)) {
                    return;
                }
                Object[] referenceParameters = parameterListOwner.getParameters();
                if (ArrayUtil.isEmpty((Object[])referenceParameters)) {
                    return;
                }
                block0: for (ResolveResult result : results = reference.multiResolve(false)) {
                    Object referenceParameter;
                    FunctionParametersHolder functionParameters;
                    PsiElement function;
                    if (!result.isValidResult() || !((function = result.getElement()) instanceof Function) || !(functionParameters = new FunctionParametersHolder(((Function)function).getParameters())).isValid()) continue;
                    for (int i = 0; i < referenceParameters.length && !PhpCodeInsightUtil.isUnpackedArgument((PsiElement)(referenceParameter = referenceParameters[i])); ++i) {
                        PhpType inferredType;
                        if (!(referenceParameter instanceof PhpTypedElement)) continue;
                        PhpType declaredType = functionParameters.getDeclaredType(i);
                        if (declaredType == null) continue block0;
                        if (!PhpStrictTypeCheckingInspection.isScalar(declaredType) || PhpStrictTypeCheckingInspection.canAccept(declaredType, inferredType = ((PhpTypedElement)referenceParameter).getType().global(project).filterUnknown()) || PhpType.intersects((PhpType)PhpType.NULL, (PhpType)declaredType) && (PhpType.NULL.equals((Object)inferredType) || declaredType.filterNull().equals((Object)inferredType))) continue;
                        holder.registerProblem((PsiElement)referenceParameter, isOnTheFly ? PhpBundle.message("inspection.strict.type.checking.parameter", declaredType, inferredType.toStringRelativized(((Function)function).getNamespaceName())) : PhpBundle.message("inspection.strict.type.checking.parameter.batch", new Object[0]), new LocalQuickFix[]{PhpStrictTypeCheckingInspection.isScalar(inferredType) && results.length == 1 ? new PhpChangeParameterTypeQuickFix(i, declaredType, inferredType) : null});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameterListOwner";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isStrict";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionCall";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            class FunctionParametersHolder {
                private final Parameter[] myFunctionParameters;
                boolean variadic;
                PhpType variadicDeclaredType;

                FunctionParametersHolder(Parameter[] functionParameters) {
                    this.myFunctionParameters = functionParameters;
                }

                boolean isValid() {
                    return this.myFunctionParameters.length > 0 && this.myFunctionParameters.length <= 10;
                }

                @Nullable
                private PhpType getDeclaredType(int i) {
                    if (this.variadic) {
                        return this.variadicDeclaredType;
                    }
                    if (i >= this.myFunctionParameters.length) {
                        return null;
                    }
                    Parameter functionParameter = this.myFunctionParameters[i];
                    this.variadic = functionParameter.isVariadic();
                    PhpType declaredType = new PhpType().add(functionParameter.getDeclaredType());
                    PsiElement value = functionParameter.getDefaultValue();
                    if (value instanceof ConstantReference && PhpLangUtil.isNull((ConstantReference)value)) {
                        declaredType.add(PhpType.NULL);
                    }
                    return !this.variadic ? declaredType : (this.variadicDeclaredType = declaredType.unpluralize());
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    public static boolean isScalar(@NotNull PhpType type) {
        if (type == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(2);
        }
        int size = type.getTypes().size();
        return PhpType.intersects((PhpType)type, (PhpType)PhpType.SCALAR) && (size == 1 || size == 2 && PhpType.intersects((PhpType)PhpType.NULL, (PhpType)type));
    }

    static boolean canAccept(@NotNull PhpType declaredType, @NotNull PhpType inferredType) {
        if (declaredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(3);
        }
        if (inferredType == null) {
            PhpStrictTypeCheckingInspection.$$$reportNull$$$0(4);
        }
        return inferredType.isUndefined() || PhpType.intersects((PhpType)declaredType, (PhpType)inferredType) || PhpType.FLOAT.equals((Object)declaredType) && PhpType.intersects((PhpType)inferredType, (PhpType)PhpType.FLOAT_INT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpStrictTypeCheckingInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isScalar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canAccept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

