/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.NotNull;

public abstract class PhpAddFieldAccessorBase
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Field field;
        if (project == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        return parent instanceof Field && PhpAddFieldAccessorBase.isApplicableToContainingClass(field = (Field)parent) && !field.isConstant() && !this.hasAccessors(field);
    }

    private static boolean isApplicableToContainingClass(@NotNull Field field) {
        PhpClass phpClass;
        if (field == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(2);
        }
        return (phpClass = field.getContainingClass()) != null && !phpClass.isInterface();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpAddFieldAccessorBase.$$$reportNull$$$0(4);
        }
        if (element.getParent() == null) {
            return;
        }
        PsiElement parent = element.getParent();
        PhpAccessorMethodData[] accessors = this.createAccessors(parent);
        for (int i = 0; i < accessors.length; ++i) {
            PhpAccessorMethodData accessor = accessors[i];
            if (accessor == null) continue;
            PsiElement addedAccessor = PhpCodeEditUtil.insertClassMemberWithPhpDoc(accessor.getTargetClass(), (PsiElement)accessor.getMethod(), accessor.getDocComment());
            if (i != 0 || addedAccessor == null) continue;
            PhpCodeUtil.openRelatedFile(project, addedAccessor);
        }
    }

    protected abstract PhpAccessorMethodData[] createAccessors(PsiElement var1);

    protected abstract boolean hasAccessors(Field var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpAddFieldAccessorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableToContainingClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

