/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.expressions;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.expressions.UnaryExpression;

public class InstanceofExpression {
    public static IElementType parse(PhpPsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        IElementType result = UnaryExpression.parse(builder);
        if (result != PhpElementTypes.EMPTY_INPUT && builder.compareAndEat(PhpTokenTypes.kwINSTANCEOF)) {
            PsiBuilder.Marker var = builder.mark();
            result = Variable.parse(builder);
            if (result == PhpElementTypes.CLASS_CONSTANT_REFERENCE) {
                var.done(result);
                builder.error(PhpParserErrors.unexpected(result));
            } else if (result == PhpElementTypes.EMPTY_INPUT) {
                var.rollbackTo();
                result = ClassReference.parseClassNameReference(builder);
                if (result == PhpElementTypes.EMPTY_INPUT) {
                    builder.error(PhpParserErrors.expected("class reference"));
                }
            } else {
                var.done(result);
            }
            marker.done(PhpElementTypes.INSTANCEOF_EXPRESSION);
            result = PhpElementTypes.INSTANCEOF_EXPRESSION;
        } else {
            marker.drop();
        }
        return result;
    }
}

