/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ConstantImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpParameterStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterImpl
extends PhpNamedElementImpl<PhpParameterStub>
implements Parameter {
    public ParameterImpl(ASTNode node) {
        super(node);
    }

    public ParameterImpl(PhpParameterStub stub) {
        super(stub, PhpStubElementTypes.PARAMETER);
    }

    @Override
    @NotNull
    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                ParameterImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            String name = nameNode.getText();
            String string = name.charAt(0) == '$' ? name.substring(1) : name;
            if (string == null) {
                ParameterImpl.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("" == null) {
            ParameterImpl.$$$reportNull$$$0(2);
        }
        return "";
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        ASTNode nameNode = this.getNameNode();
        CharSequence name = nameNode != null ? nameNode.getChars() : "";
        CharSequence charSequence = name.length() > 0 && name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name;
        if (charSequence == null) {
            ParameterImpl.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(PhpTokenTypes.VARIABLE);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode astNode;
        if (name == null) {
            ParameterImpl.$$$reportNull$$$0(4);
        }
        if ((astNode = this.getNameNode()) != null && !this.getName().equals(name)) {
            Variable variable = PhpPsiElementFactory.createVariable(this.getProject(), name, true);
            ASTNode nameNode = variable.getNameNode();
            assert (nameNode != null);
            astNode.getTreeParent().replaceChild(astNode, nameNode);
        }
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ParameterImpl.$$$reportNull$$$0(5);
        }
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpParameter((Parameter)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public SearchScope getUseScope() {
        Function f = (Function)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (f != null) {
            PhpDocComment docComment = f.getDocComment();
            if (docComment != null) {
                LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{f, docComment});
                if (localSearchScope == null) {
                    ParameterImpl.$$$reportNull$$$0(6);
                }
                return localSearchScope;
            }
            LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)f);
            if (localSearchScope == null) {
                ParameterImpl.$$$reportNull$$$0(7);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            ParameterImpl.$$$reportNull$$$0(8);
        }
        return searchScope;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpIcons.PARAMETER;
    }

    public boolean isOptional() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isOptional();
        }
        if (this.findChildByType(PhpElementTypes.PARAMETER_DEFAULT_VALUE) != null) {
            return true;
        }
        PhpDocParamTag paramTag = this.getDocTag();
        return paramTag != null && paramTag.isOptional();
    }

    public boolean isVariadic() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isVariadic();
        }
        return this.getNode().findChildByType(PhpTokenTypes.opVARIADIC) != null;
    }

    public boolean isPassByRef() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isPassByRef();
        }
        return this.getNode().findChildByType(PhpTokenTypes.opBIT_AND) != null;
    }

    @NotNull
    public PhpType getDeclaredType() {
        PhpParameterStub stub = (PhpParameterStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType type = ParameterImpl.getTypeFromDeclaration(this);
        if (this.isVariadic()) {
            type = !type.isEmpty() ? type.pluralise() : PhpType.ARRAY;
        }
        PhpType phpType = type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @NotNull
    public PhpType getDocType() {
        PhpDocParamTag docTag = this.getDocTag();
        PhpType phpType = docTag != null ? docTag.getDocType() : PhpType.EMPTY;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(11);
        }
        return phpType;
    }

    public static PhpType getTypeFromDeclaration(PhpPsiElement parameter) {
        PhpType type = new PhpType();
        boolean phpDocMethod = PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Method.INSTANCEOF) instanceof PhpDocMethod;
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType;
            if (child instanceof ClassReference) {
                String text = child.getText();
                Project project = parameter.getProject();
                boolean primitiveType = phpDocMethod ? PhpType.isPrimitiveType((String)text) : PhpLangUtil.isParameterTypeHint(text, project);
                PhpType t = new PhpType().add(primitiveType ? text : ((ClassReference)child).getFQN());
                PsiElement next = child.getNextSibling();
                if (PhpPsiUtil.isOfType(next, PhpTokenTypes.chLBRACKET)) {
                    t = t.pluralise();
                    child = next;
                }
                type.add(t);
                continue;
            }
            ASTNode childNode = child.getNode();
            IElementType iElementType = elementType = childNode == null ? null : childNode.getElementType();
            if (elementType == PhpTokenTypes.VARIABLE) break;
            if (elementType == PhpTokenTypes.kwARRAY) {
                type.add(PhpType.ARRAY);
                continue;
            }
            if (elementType == PhpTokenTypes.kwCALLABLE) {
                type.add(PhpType.CALLABLE);
                continue;
            }
            if (elementType != PhpTokenTypes.opQUEST || PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true), PhpTokenTypes.VARIABLE)) continue;
            type.add(PhpType.NULL);
        }
        return type;
    }

    @NotNull
    public PhpType getInferredType() {
        PsiElement defaultValue = this.getDefaultValue();
        PhpType phpType = defaultValue instanceof PhpTypedElement ? ((PhpTypedElement)defaultValue).getType() : PhpType.EMPTY;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    @NotNull
    public PhpType getLocalType() {
        PhpDocParamTag tag;
        PsiElement value;
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getType();
            if (phpType == null) {
                ParameterImpl.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        PhpType hint = this.getDeclaredType();
        type.add(hint);
        if (hint.isEmpty() && (value = this.getDefaultValue()) != null) {
            type.add(value);
        }
        if ((tag = this.getDocTag()) != null) {
            type.add(tag.getType());
        }
        PhpType phpType = type;
        if (phpType == null) {
            ParameterImpl.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @Nullable
    public PsiElement getDefaultValue() {
        PsiElement e = this.findChildByType(PhpElementTypes.PARAMETER_DEFAULT_VALUE);
        return e != null ? e.getFirstChild() : null;
    }

    @Nullable
    public String getDefaultValuePresentation() {
        PhpParameterStub stub = (PhpParameterStub)this.getStub();
        if (stub != null) {
            return stub.getDefaultValuePresentation();
        }
        PsiElement defaultValue = this.getDefaultValue();
        return defaultValue != null ? ConstantImpl.getValuePresentationInternal(defaultValue) : null;
    }

    @Nullable
    public PhpDocParamTag getDocTag() {
        PhpDocComment docComment = this.getDocComment();
        return docComment != null ? docComment.getParamTagByName(this.getName()) : null;
    }

    @Override
    @NotNull
    public String getFQN() {
        String string = ((Function)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)Function.INSTANCEOF)).getFQN() + "(" + this.getName() + ")";
        if (string == null) {
            ParameterImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor) {
        Method method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)Method.INSTANCEOF);
        if (method != null) {
            method.processDocs(processor);
        }
    }

    @Override
    public PhpDocComment getDocComment() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        Function function = stub != null ? (Function)stub.getParentStubOfType(Function.class) : (Function)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)Function.INSTANCEOF);
        return function != null ? function.getDocComment() : null;
    }

    public boolean isWriteAccess() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ParameterImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ParameterImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

