/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceByVariableTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceInObjectContextTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableDeclaredTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTypeAnalyserVisitor
extends PhpElementVisitor
implements PhpElementTypes {
    public static final boolean INFER_FROM_CONSTRUCTOR = true;
    @NotNull
    private PhpType type = new PhpType();

    public void addType(@Nullable PsiElement element) {
        this.type.add(element);
    }

    public void addType(@Nullable String signature) {
        this.type.add(signature);
    }

    public void addType(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(0);
        }
        if (!phpType.isEmpty()) {
            this.type.add(phpType);
        }
    }

    private boolean addTypeFromExpression(@NotNull PhpExpression expression) {
        PhpType declaredType;
        if (expression == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(1);
        }
        if ((declaredType = PhpTypeAnalyserVisitor.inferType((PhpPsiElement)expression)) != null) {
            this.addType(declaredType);
            return !declaredType.equals((Object)PhpType.ARRAY);
        }
        return false;
    }

    @NotNull
    private static PhpType inferThis(@NotNull PhpPsiElement curAnchor) {
        Variable variable;
        if (curAnchor == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(2);
        }
        if (curAnchor instanceof Variable && "this".contentEquals((variable = (Variable)curAnchor).getNameCS())) {
            final PhpType type = new PhpType();
            List<PhpNamedElement> dds = variable.resolveLocal().stream().filter(element -> element instanceof PhpDocVariable).collect(Collectors.toList());
            dds.forEach(d -> type.add((PsiElement)d));
            PhpClass phpClass = PhpClassImpl.getContainingClass((PhpPsiElement)variable);
            type.add((PsiElement)phpClass);
            PhpRecursiveElementVisitor elementVisitor = new PhpRecursiveElementVisitor(){

                public void visitPhpBinaryExpression(BinaryExpression expression) {
                    if (expression.getOperationType() == PhpTokenTypes.kwINSTANCEOF) {
                        PsiElement left = expression.getLeftOperand();
                        PsiElement right = expression.getRightOperand();
                        if (left instanceof Variable && left.getText().equals("$this") && right instanceof ClassReference) {
                            type.add(((ClassReference)right).getFQN());
                        }
                    }
                    super.visitPhpBinaryExpression(expression);
                }
            };
            TernaryExpression ternary = (TernaryExpression)PhpPsiUtil.getParentByCondition((PsiElement)variable, true, (Condition<? super PsiElement>)TernaryExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (ternary != null) {
                elementVisitor.apply((PsiElement)ternary.getCondition());
            }
            ControlStatement control = (ControlStatement)PhpPsiUtil.getParentByCondition((PsiElement)variable, true, (Condition<? super PsiElement>)ControlStatement.INSTANCEOF, (Condition<? super PsiElement>)Function.INSTANCEOF);
            for (int i = 0; control != null && i < 3; ++i) {
                elementVisitor.apply((PsiElement)control.getCondition());
                control = (ControlStatement)PhpPsiUtil.getParentByCondition((PsiElement)control, true, (Condition<? super PsiElement>)ControlStatement.INSTANCEOF, (Condition<? super PsiElement>)Function.INSTANCEOF);
            }
            PhpType phpType = type;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(3);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @Nullable
    private static PhpType inferType(@NotNull PhpPsiElement curAnchor) {
        ArrayAccessExpression arrayAccessExpression;
        ArrayIndex arrayIndex;
        PhpPsiElement value;
        PsiElement grandParent;
        PsiElement parent;
        if (curAnchor == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(5);
        }
        if (curAnchor instanceof Variable) {
            Variable variable = (Variable)curAnchor;
            PsiElement parent2 = variable.getParent();
            if (parent2 instanceof ForeachStatement) {
                ForeachStatement foreach = (ForeachStatement)parent2;
                PsiElement arr = foreach.getArray();
                if (arr instanceof PhpTypedElement) {
                    if (variable == foreach.getKey()) {
                        PhpType type = new PhpType();
                        for (String t : ((PhpTypedElement)arr).getType().getTypes()) {
                            type.add(PhpTypeSignatureKey.ARRAY_KEY.sign((CharSequence)PhpTypeSignatureKey.CLASS.signIfUnsigned(t)));
                        }
                        type.add(PhpType.NUMERIC);
                        return type;
                    }
                    if (variable == foreach.getValue()) {
                        return ((PhpTypedElement)arr).getType().elementType();
                    }
                }
            } else {
                if (parent2 instanceof Catch) {
                    PhpType phpType = new PhpType().add(PhpType.EXCEPTION);
                    ((Catch)parent2).getExceptionTypes().forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                    return phpType;
                }
                if (parent2 instanceof Global) {
                    return new PhpType().add(variable.getSignature());
                }
            }
        }
        if (PhpPsiUtil.isOfType(parent = curAnchor.getParent(), ARRAY_VALUE) && (grandParent = parent.getParent()) instanceof ArrayCreationExpression) {
            parent = grandParent.getParent();
        }
        if (parent instanceof MultiassignmentExpression) {
            PhpPsiElement valueExpression = ((MultiassignmentExpression)parent).getValue();
            if (PhpPsiUtil.isOfType((PsiElement)valueExpression, EXPRESSION) && (value = valueExpression.getFirstPsiChild()) instanceof PhpTypedElement) {
                return ((PhpTypedElement)value).getType().elementType();
            }
        } else if (parent instanceof SelfAssignmentExpression) {
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)parent;
            PhpPsiElement variable = selfAssignmentExpression.getVariable();
            if (variable == curAnchor) {
                PsiElement operation = selfAssignmentExpression.getOperation();
                if (operation != null && PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
                    return PhpType.STRING;
                }
                PhpPsiElement value2 = selfAssignmentExpression.getValue();
                if (value2 instanceof PhpTypedElement) {
                    return ((PhpTypedElement)value2).getType();
                }
            }
        } else if (parent instanceof AssignmentExpression) {
            AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
            if (assignmentExpression.getVariable() == curAnchor && (value = assignmentExpression.getValue()) instanceof PhpTypedElement) {
                return ((PhpTypedElement)value).getType();
            }
        } else if (parent instanceof ArrayAccessExpression && (arrayIndex = (arrayAccessExpression = (ArrayAccessExpression)parent).getIndex()) != null && arrayIndex.getFirstPsiChild() == null) {
            return PhpType.ARRAY;
        }
        return null;
    }

    @NotNull
    public PhpType getType() {
        PhpType phpType = this.type;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    protected void visitPhpReference(PhpReference ref) {
        PhpType localType = ref.resolveLocalType();
        if (!localType.isEmpty()) {
            this.addType(localType);
        } else {
            String signature = ref.getSignature();
            if (signature.indexOf(124) < 0) {
                this.addType(signature);
            } else {
                List split = StringUtil.split((String)signature, (String)"|");
                for (String s : split) {
                    this.addType(s);
                }
            }
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expression) {
        IElementType o = expression.getOperation().getNode().getElementType();
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.POSTFIX_EXPRESSION)) {
            this.addType(PhpType.INT);
        } else if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_EXPRESSION)) {
            if (o == PhpTokenTypes.opPLUS || o == PhpTokenTypes.opMINUS) {
                this.addType(PhpType.INT);
            } else {
                this.addType(PhpType.BOOLEAN);
            }
        } else if (PhpTokenTypes.tsCAST_OPS.contains(o)) {
            if (o == PhpTokenTypes.opINTEGER_CAST) {
                this.addType(PhpType.INT);
            } else if (o == PhpTokenTypes.opFLOAT_CAST) {
                this.addType(PhpType.FLOAT);
            } else if (o == PhpTokenTypes.opBOOLEAN_CAST) {
                this.addType(PhpType.BOOLEAN);
            } else if (o == PhpTokenTypes.opSTRING_CAST) {
                this.addType(PhpType.STRING);
            } else if (o == PhpTokenTypes.opARRAY_CAST) {
                this.addType(PhpType.ARRAY);
            } else if (o == PhpTokenTypes.opOBJECT_CAST) {
                this.addType(PhpType.OBJECT);
            } else if (o == PhpTokenTypes.opUNSET_CAST) {
                this.addType(PhpType.UNSET);
            }
        } else if (o == PhpTokenTypes.opNOT) {
            this.addType(PhpType.BOOLEAN);
        } else {
            this.addType((PsiElement)expression.getValue());
        }
    }

    public void visitPhpVariable(Variable variable) {
        PhpAccessVariableInstruction instruction;
        PhpScopeHolder scopeHolder;
        boolean finish;
        PhpAccessVariableInstruction instruction2;
        PhpType docType = variable.getDocType();
        this.addType(docType);
        if (!docType.isEmpty()) {
            return;
        }
        if (PhpLangUtil.isThisReference((PsiElement)variable)) {
            PhpType thisType = PhpTypeAnalyserVisitor.inferThis((PhpPsiElement)variable);
            this.addType(thisType);
            return;
        }
        CharSequence variableName = variable.getName();
        if (!StringUtil.isEmpty((String)variableName) && (instruction2 = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) != null) {
            PhpVariableDeclaredTypeAnalyzerProcessor processor = new PhpVariableDeclaredTypeAnalyzerProcessor((String)variableName);
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction2, false, processor);
            PhpType type = processor.getType();
            this.addType(type);
            if (type.isNotExtendablePrimitiveType()) {
                return;
            }
        }
        variableName = variable.getNameCS();
        PhpType result = new PhpType();
        if (!StringUtil.isEmpty((CharSequence)variableName) && !(finish = this.addTypeFromExpression((PhpExpression)variable)) && (scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable)) != null && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) != null) {
            PhpVariableInferredTypeAnalyzerProcessor processor = new PhpVariableInferredTypeAnalyzerProcessor(variableName, scopeHolder);
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, false, processor);
            result.add(processor.getType());
        }
        for (String s : result.getTypes()) {
            if (!docType.isEmpty() && (PhpType.isMixedType((String)s) || PhpType.isArray((String)s) || PhpType.isObject((String)s) || PhpType.isUnresolved((String)s))) continue;
            this.addType(s);
        }
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        this.addType((PsiElement)expr.getValue());
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
            this.addType(PhpType.STRING);
        } else {
            this.visitPhpAssignmentExpression((AssignmentExpression)expression);
        }
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        this.visitPhpAssignmentExpression((AssignmentExpression)multiassignmentExpression);
    }

    public void visitPhpConstant(Constant constant) {
        PsiElement value = constant.getValue();
        if (value != null) {
            this.addType(value);
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        this.addType(PhpType.ARRAY);
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        ArrayIndex index;
        String key;
        ArrayIndex index2;
        CharSequence variableName;
        PhpPsiElement reference = expression.getValue();
        if (reference instanceof Variable && !StringUtil.isEmpty((CharSequence)(variableName = ((Variable)reference).getNameCS())) && (index2 = expression.getIndex()) != null && !StringUtil.isEmpty((CharSequence)(key = PhpCodeInsightUtil.getKey(index2)))) {
            boolean finish = this.addTypeFromExpression((PhpExpression)expression);
            if (finish) {
                return;
            }
            PhpArrayAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)expression, PhpArrayAccessInstruction.class);
            if (instruction != null) {
                PhpArrayAccessTypeAnalyzer processor = new PhpArrayAccessTypeAnalyzer(variableName, key);
                PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor);
                PhpType phpType = processor.getType();
                if (!phpType.isEmpty()) {
                    this.addType(phpType);
                    return;
                }
            }
        }
        if ((index = expression.getIndex()) != null) {
            PhpPsiElement value = expression.getValue();
            if (value instanceof PhpTypedElement) {
                PhpType elementType = ((PhpTypedElement)value).getType().elementType();
                Set types = elementType.getTypes();
                for (String s : types) {
                    if (("$this".equals(s) || "static".equals(s)) && reference instanceof MemberReference) {
                        this.addType((PsiElement)((MemberReference)reference).getClassReference());
                        continue;
                    }
                    this.addType(s);
                }
            }
        } else {
            this.addType(PhpType.ARRAY);
        }
    }

    public void visitPhpExpression(PhpExpression expression) {
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        this.addType((PsiElement)expression.unparenthesize());
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        IElementType o = expression.getOperationType();
        if (o == PhpTokenTypes.opCONCAT) {
            this.addType(PhpType.STRING);
        } else if (PhpTokenTypes.tsLOGICAL_OPS.contains(o) || PhpTokenTypes.tsCOMPARE_OPS.contains(o)) {
            if (o == PhpTokenTypes.opSPACESHIP) {
                this.addType(PhpType.INT);
            } else {
                this.addType(PhpType.BOOLEAN);
            }
        } else if (o == PhpTokenTypes.opREM || PhpTokenTypes.tsBIT_OPS.contains(o)) {
            this.addType(PhpType.INT);
        } else if (PhpTokenTypes.tsCOMPARE_OPS.contains(o)) {
            this.addType(PhpType.BOOLEAN);
        } else if (PhpTokenTypes.tsMATH_OPS.contains(o)) {
            PsiElement rightOperand = expression.getRightOperand();
            PsiElement leftOperand = expression.getLeftOperand();
            if (PhpPsiUtil.isOfType(rightOperand, PhpElementTypes.NUMBER) && PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)((PhpTypedElement)rightOperand).getType()) || PhpPsiUtil.isOfType(leftOperand, PhpElementTypes.NUMBER) && PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)((PhpTypedElement)leftOperand).getType())) {
                this.addType(PhpType.FLOAT);
                return;
            }
        }
        if (o == PhpTokenTypes.opDIV || o == PhpTokenTypes.opMUL) {
            this.addType(PhpType.INT);
            this.addType(PhpType.FLOAT);
        }
        if (this.type.isEmpty()) {
            PsiElement leftOperand = expression.getLeftOperand();
            PsiElement rightOperand = expression.getRightOperand();
            this.addType(leftOperand);
            this.addType(rightOperand);
        }
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        PsiElement[] children = expression.getChildren();
        this.type = new PhpType();
        if (children.length > 2) {
            this.addType(children[children.length - 2]);
        }
        if (children.length > 1) {
            this.addType(children[children.length - 1]);
        }
    }

    public void visitPhpParameter(Parameter parameter) {
        PhpType local = parameter.getLocalType();
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)parameter, true, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if ((local.isEmpty() || !local.isComplete()) && function instanceof Method && ((Method)function).getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
            PhpClass aClass = ((Method)function).getContainingClass();
            assert (aClass != null);
            List names = Lists.asList((Object)aClass.getSuperFQN(), (Object[])aClass.getInterfaceNames());
            for (String superFQN : names) {
                if (superFQN == null) continue;
                Parameter[] parameters = function.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter p = parameters[i];
                    if (!p.equals(parameter)) continue;
                    String sig = PhpTypeSignatureKey.PARAMETER.sign((CharSequence)PhpTypeSignatureKey.METHOD.sign((CharSequence)PhpTypeSignatureKey.CLASS.sign((CharSequence)(superFQN + "." + function.getName() + "." + i))));
                    this.addType(sig);
                }
            }
        }
        this.addType(local);
    }

    public void visitPhpNewExpression(NewExpression value) {
        ClassReference reference = value.getClassReference();
        if (reference != null) {
            this.addType(reference.resolveLocalType());
        } else {
            PhpPsiElement child = value.getFirstPsiChild();
            if (child instanceof PhpClass) {
                this.addType((PsiElement)child);
            }
        }
    }

    public void visitPhpFunction(Function function) {
        this.addType(function.getLocalType(false));
    }

    public void visitPhpMethod(Method method) {
        this.addType(method.getLocalType(false));
    }

    public void visitPhpField(Field field) {
        Map<String, AssignmentExpression> accessMap;
        PhpExpression expression;
        PhpClass phpClass;
        PhpDocComment docComment = field.getDocComment();
        if (docComment != null) {
            PhpDocParamTag varTag = docComment.getVarTag();
            this.addType((PsiElement)varTag);
        }
        if (this.type.isEmpty()) {
            PsiElement value = field.getDefaultValue();
            this.addType(value);
        }
        if ((phpClass = field.getContainingClass()) != null && (expression = (PhpExpression)(accessMap = PhpClassImpl.getAssignmentsPerField(phpClass)).get(field.getName())) != null) {
            this.addType(expression.getType());
        }
    }

    public void visitPhpClassReference(ClassReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpReturnType(PhpReturnType returnType) {
        this.addType(returnType.getType());
    }

    public void visitPhpMethodReference(MethodReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpClassConstantReference(ClassConstantReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        CharSequence fieldName = fieldReference.getNameCS();
        if (!StringUtil.isEmpty((CharSequence)fieldName)) {
            boolean finish = this.addTypeFromExpression((PhpExpression)fieldReference);
            if (finish) {
                return;
            }
            PhpExpression reference = fieldReference.getClassReference();
            if (reference != null) {
                PhpAccessFieldInObjectContextInstruction instruction;
                if (reference instanceof Variable) {
                    PhpAccessFieldByVariableInstruction instruction2;
                    CharSequence variableName = ((Variable)reference).getNameCS();
                    if (!StringUtil.isEmpty((CharSequence)variableName) && (instruction2 = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class)) != null) {
                        PhpFieldReferenceByVariableTypeAnalyzer processor = new PhpFieldReferenceByVariableTypeAnalyzer(fieldName, variableName);
                        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction2, false, processor);
                        PhpType phpType = processor.getType();
                        if (!phpType.isEmpty()) {
                            this.addType(phpType);
                        }
                    }
                } else if (reference instanceof ClassReference && PhpLangUtil.isSelfReference((ClassReference)reference) && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldInObjectContextInstruction.class)) != null) {
                    PhpFieldReferenceInObjectContextTypeAnalyzer processor = new PhpFieldReferenceInObjectContextTypeAnalyzer(fieldName);
                    PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor);
                    PhpType phpType = processor.getType();
                    if (!phpType.isEmpty()) {
                        this.addType(phpType);
                    }
                }
            }
        }
        this.visitPhpReference((PhpReference)fieldReference);
    }

    public void visitPhpConstantReference(ConstantReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpFunctionCall(FunctionReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curAnchor";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeAnalyserVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeAnalyserVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "inferThis";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inferThis";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

