/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassMemberBase {
    protected static final Logger LOG = Logger.getInstance(PhpMoveClassMemberBase.class);
    private static final TokenSet FIELD_LIST_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS});
    private static final Condition<PsiElement> FIELD_LIST_CONDITION = element -> {
        ASTNode node = element.getNode();
        IElementType elementType = node == null ? null : node.getElementType();
        return FIELD_LIST_TOKEN_SET.contains(elementType);
    };
    protected PhpClass myTargetClass;
    protected boolean myShouldWeakAccess;

    private PhpMoveClassMemberBase(PhpClass targetClass, boolean shouldWeakAccess) {
        this.myTargetClass = targetClass;
        this.myShouldWeakAccess = shouldWeakAccess;
    }

    @NotNull
    public static PhpMoveClassMemberBase getInstance(@NotNull PhpClass targetClass, boolean shouldWeakAccess) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(0);
        }
        if (targetClass.isInterface()) {
            PhpMoveClassMemberToInterface phpMoveClassMemberToInterface = new PhpMoveClassMemberToInterface(targetClass, shouldWeakAccess);
            if (phpMoveClassMemberToInterface == null) {
                PhpMoveClassMemberBase.$$$reportNull$$$0(1);
            }
            return phpMoveClassMemberToInterface;
        }
        PhpMoveClassMember phpMoveClassMember = new PhpMoveClassMember(targetClass, shouldWeakAccess);
        if (phpMoveClassMember == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(2);
        }
        return phpMoveClassMember;
    }

    public static void removeMembers(@NotNull List<? extends PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(3);
        }
        for (PhpClassMember phpClassMember : members) {
            if (phpClassMember instanceof Field) {
                PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)phpClassMember);
                continue;
            }
            if (!shouldRemoveMethods || !(phpClassMember instanceof Method)) continue;
            PhpMoveClassMemberBase.removeMethodWithPhpDoc((Method)phpClassMember);
        }
    }

    private static void removeFieldWithPhpDoc(Field field) {
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        LOG.assertTrue(fieldList != null);
        if (PhpMoveClassMemberBase.isSingleFieldList(fieldList)) {
            PsiElement parent = fieldList.getParent();
            PhpDocComment comment = field.getDocComment();
            parent.deleteChildRange((PsiElement)(comment == null ? fieldList : comment), fieldList);
        } else {
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
        }
    }

    public static void removeMethodWithPhpDoc(Method method) {
        PsiElement methodParent = method.getParent();
        if (method instanceof PhpDocMethod) {
            methodParent.getParent().deleteChildRange(methodParent, methodParent);
            return;
        }
        PhpDocComment comment = method.getDocComment();
        methodParent.deleteChildRange((PsiElement)(comment != null ? comment : method), (PsiElement)method);
    }

    @NotNull
    public List<PsiElement> move(@NotNull List<PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(4);
        }
        List<PsiElement> list = this.cutAndMove(members, shouldRemoveMethods);
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> move(@NotNull List<PhpClassMember> members, PhpModifier.Access access, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(6);
        }
        for (PhpClassMember memberIt : members) {
            PhpMoveClassMemberBase.changeMemberVisibility(access, memberIt);
        }
        List<PsiElement> list = this.cutAndMove(members, shouldRemoveMethods);
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static void changeMemberVisibility(PhpModifier.Access access, PhpClassMember member) {
        PsiElement modifierList;
        PhpModifier modifier = member.getModifier();
        PhpModifierList newModifierList = PhpPsiElementFactory.createModifierList(member.getProject(), PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)modifier.getAbstractness(), (PhpModifier.State)modifier.getState()));
        PhpClassMember element = member;
        if (member instanceof Field) {
            element = member.getParent();
        }
        if ((modifierList = PhpPsiUtil.getChildOfType((PsiElement)element, PhpElementTypes.MODIFIER_LIST)) instanceof PhpModifierList) {
            PsiElement replace = modifierList.replace((PsiElement)newModifierList);
            if (modifierList.getTextRange().isEmpty()) {
                replace.getParent().addAfter((PsiElement)PhpPsiElementFactory.createWhiteSpace(replace.getProject()), replace);
            }
        }
    }

    public List<PsiElement> move(List<PhpClassMember> members) {
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        referenceResolver.processElements(members);
        boolean hasAbstractMembers = false;
        ArrayList<PsiElement> movedMembers = new ArrayList<PsiElement>();
        for (PhpClassMember member : members) {
            if (member instanceof Method) {
                movedMembers.add((PsiElement)this.moveMethod((Method)member, members));
                hasAbstractMembers = hasAbstractMembers || ((Method)member).isAbstract();
                continue;
            }
            movedMembers.add(this.moveField((Field)member));
        }
        if (hasAbstractMembers && !this.myTargetClass.isAbstract()) {
            PsiElement abstractClass = PhpPsiElementFactory.createFromText(this.myTargetClass.getProject(), PhpTokenTypes.kwABSTACT, "abstract class A {}");
            PsiElement child = this.myTargetClass.getFirstChild();
            if (child != null) {
                this.myTargetClass.addBefore(abstractClass, child);
            }
        }
        PhpPsiElement scopeHolder = PhpMoveClassMemberBase.getScopeHolder(this.myTargetClass);
        referenceResolver.importReferences(scopeHolder, movedMembers);
        return movedMembers;
    }

    @NotNull
    public List<PsiElement> cutAndMove(@NotNull List<PhpClassMember> members, boolean shouldRemoveMethods) {
        if (members == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(8);
        }
        List<PsiElement> movedMembers = this.move(members);
        PhpMoveClassMemberBase.removeMembers(members, shouldRemoveMethods);
        List<PsiElement> list = movedMembers;
        if (list == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static PhpPsiElement getScopeHolder(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(10);
        }
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)targetClass);
        assert (scopeHolder != null);
        PhpPsiElement phpPsiElement = scopeHolder;
        if (phpPsiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(11);
        }
        return phpPsiElement;
    }

    @NotNull
    protected abstract Method moveMethod(@NotNull Method var1, List<PhpClassMember> var2);

    @NotNull
    private PsiElement moveField(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(12);
        }
        PsiElement psiElement = PhpMoveClassMemberBase.addField(this.myTargetClass, this.myShouldWeakAccess, field);
        if (psiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    protected void updateMethodAccess(@NotNull Method method, @NotNull String currentAccess, @NotNull String destinationAccess) {
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(14);
        }
        if (currentAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(15);
        }
        if (destinationAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(16);
        }
        String methodCode = method.getText().replaceFirst(currentAccess, destinationAccess);
        Method newMethod = PhpPsiElementFactory.createMethod(method.getProject(), methodCode);
        method.replace((PsiElement)newMethod);
    }

    @NotNull
    protected Method addMethodUp(@NotNull PhpClass clazz, @NotNull Method method, @NotNull String methodCode, @Nullable String currentAccess, @NotNull String destinationAccess) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(17);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(18);
        }
        if (methodCode == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(19);
        }
        if (destinationAccess == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(20);
        }
        if (!(method instanceof PhpDocMethod)) {
            if (currentAccess != null) {
                methodCode = methodCode.replaceFirst(currentAccess, destinationAccess);
            }
            Method method2 = this.addMethodWithPhpDoc(clazz, method, methodCode);
            if (method2 == null) {
                PhpMoveClassMemberBase.$$$reportNull$$$0(21);
            }
            return method2;
        }
        this.addPhpDocMethod(clazz, method);
        Method method3 = method;
        if (method3 == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(22);
        }
        return method3;
    }

    @NotNull
    private static PsiElement addField(@NotNull PhpClass clazz, boolean moveUp, @NotNull Field field) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(23);
        }
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(24);
        }
        PsiElement fieldList = PhpMoveClassMemberBase.getFieldListElement(field);
        assert (fieldList != null);
        PhpPsiElement newField = PhpMoveClassMemberBase.constructField(field, moveUp);
        PhpDocComment comment = PhpMoveClassMemberBase.isSingleFieldList(fieldList) ? field.getDocComment() : null;
        PsiElement insertedField = PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)newField, comment);
        assert (insertedField != null);
        PsiElement psiElement = insertedField;
        if (psiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(25);
        }
        return psiElement;
    }

    @NotNull
    private static PhpPsiElement constructField(@NotNull Field field, boolean moveUp) {
        PhpModifier modifier;
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(26);
        }
        StringBuilder builder = new StringBuilder("class A {\n");
        if (field.isConstant()) {
            modifier = field.getModifier();
            if (PhpProjectConfigurationFacade.getInstance(field.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY)) {
                if (modifier.isPrivate() && moveUp) {
                    builder.append("protected ");
                } else if (modifier.isPublic()) {
                    builder.append("public ");
                } else if (modifier.isPrivate()) {
                    builder.append("private ");
                }
            }
            builder.append("const");
        } else {
            modifier = field.getModifier();
            builder.append(modifier.isPrivate() && moveUp ? modifier.toString().replaceFirst("private", "protected") : modifier.toString());
        }
        builder.append(" ");
        builder.append(field.getText());
        builder.append(";\n }");
        PhpPsiElement newField = PhpPsiElementFactory.createPhpPsiFromText(field.getProject(), FIELD_LIST_TOKEN_SET, builder.toString());
        assert (newField != null);
        PhpPsiElement phpPsiElement = newField;
        if (phpPsiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(27);
        }
        return phpPsiElement;
    }

    @Nullable
    private static PsiElement getFieldListElement(@NotNull Field field) {
        if (field == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(28);
        }
        return PhpPsiUtil.getParentByCondition((PsiElement)field, false, FIELD_LIST_CONDITION);
    }

    private static boolean isSingleFieldList(@NotNull PsiElement fieldList) {
        List childFields;
        if (fieldList == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(29);
        }
        return (childFields = PhpPsiUtil.getChildren(fieldList, (Condition<? super PsiElement>)Field.INSTANCEOF)).size() <= 1;
    }

    @NotNull
    protected Method addMethodWithPhpDoc(@NotNull PhpClass clazz, @NotNull Method method, @NotNull String methodCode) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(30);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(31);
        }
        if (methodCode == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(32);
        }
        Method newMethod = PhpPsiElementFactory.createMethod(clazz.getProject(), methodCode);
        PsiElement insertedMethod = PhpCodeEditUtil.insertClassMemberWithPhpDoc(clazz, (PsiElement)newMethod, method.getDocComment());
        assert (insertedMethod instanceof Method);
        Method method2 = (Method)insertedMethod;
        if (method2 == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(33);
        }
        return method2;
    }

    @NotNull
    protected PsiElement addPhpDocMethod(@NotNull PhpClass clazz, @NotNull Method method) {
        if (clazz == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(34);
        }
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(35);
        }
        PsiElement psiElement = PhpCodeEditUtil.insertDocMethodBeforeClass(clazz, method.getParent());
        if (psiElement == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(36);
        }
        return psiElement;
    }

    protected Method resolvePhpDoc(final Method method) {
        PhpDocComment doc = method.getDocComment();
        if (doc != null) {
            doc.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                public void visitPhpDocType(PhpDocType type) {
                    PhpMoveClassMemberBase.resolveReferencesInDoc(type, method);
                }
            });
        }
        return method;
    }

    protected Method refactorInternalReferences(final @NotNull Method method, final PhpClass fromClass, final List<PhpClassMember> members) {
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(37);
        }
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
                if (fieldReference == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.refactorInternalReference((MemberReference)fieldReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.refactorInternalReference((MemberReference)constantReference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.refactorInternalReference((MemberReference)reference);
                super.visitPhpMethodReference(reference);
            }

            public void visitPhpClassReference(ClassReference classReference) {
                this.refactorInternalClassReference(classReference);
            }

            public void visitPhpDocType(PhpDocType type) {
                PhpMoveClassMemberBase.resolveReferencesInDoc(type, method);
            }

            private void refactorInternalClassReference(@NotNull ClassReference reference) {
                if (reference == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(reference.getParent() instanceof MemberReference)) {
                    String newName;
                    PhpClass resolvedClass;
                    PsiElement element = reference.resolve();
                    String classReferenceName = reference.getName();
                    if (element != null && (resolvedClass = (PhpClass)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && !(newName = resolvedClass.getName()).isEmpty() && classReferenceName != null && (classReferenceName.equalsIgnoreCase("parent") || classReferenceName.equalsIgnoreCase("self"))) {
                        reference.getElement().replace((PsiElement)PhpPsiElementFactory.createClassReference(reference.getProject(), newName));
                    }
                }
            }

            private void refactorInternalReference(@NotNull MemberReference reference) {
                PhpClass refClass;
                PsiElement lastChild;
                if (reference == null) {
                    2.$$$reportNull$$$0(2);
                }
                PhpExpression classRefExpression = reference.getClassReference();
                PsiElement resolvedMember = reference.resolve();
                if (classRefExpression != null && (resolvedMember = PhpMoveClassMemberBase.this.refactorClassKeyword(reference, resolvedMember, lastChild = reference.getLastChild(), fromClass)) != null && (refClass = (PhpClass)PhpPsiUtil.getParentByCondition(resolvedMember, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null) {
                    String name = classRefExpression.getName();
                    if (refClass.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)PhpMoveClassMemberBase.this.myTargetClass)) {
                        name = "self";
                    }
                    if (name != null && PhpMoveClassMemberBase.shouldBeReplacedByClassName(refClass, name, fromClass) && !name.equalsIgnoreCase("static") && !resolvedMember.getManager().areElementsEquivalent(resolvedMember, (PsiElement)method)) {
                        if (resolvedMember instanceof PhpClassMember) {
                            if (((PhpClassMember)resolvedMember).getModifier().isStatic()) {
                                PsiElement firstChild = classRefExpression.getFirstChild();
                                String newName = members.contains(resolvedMember) && name.equalsIgnoreCase("self") ? "self" : refClass.getName();
                                firstChild.replace(PhpPsiElementFactory.createFromText(reference.getProject(), PhpTokenTypes.IDENTIFIER, newName));
                            }
                        } else {
                            PsiElement firstChild = classRefExpression.getFirstChild();
                            firstChild.replace(PhpPsiElementFactory.createFromText(reference.getProject(), PhpTokenTypes.IDENTIFIER, refClass.getName()));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldReference";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPhpFieldReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "refactorInternalClassReference";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "refactorInternalReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return method;
    }

    private PsiElement refactorClassKeyword(MemberReference reference, PsiElement resolvedMember, PsiElement lastChild, PhpClass fromClass) {
        if (resolvedMember == null && PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.kwCLASS)) {
            PsiElement firstChild = reference.getFirstChild();
            String firstChildText = firstChild.getText();
            if (firstChildText.equalsIgnoreCase("self")) {
                resolvedMember = fromClass;
            }
            if (firstChildText.equalsIgnoreCase("$this")) {
                resolvedMember = fromClass;
            }
            if (firstChildText.equalsIgnoreCase("parent")) {
                resolvedMember = fromClass.getSuperClass();
            }
        }
        return resolvedMember;
    }

    public static boolean shouldBeReplacedByClassName(@Nullable PhpClass refClass, String name, @NotNull PhpClass fromClass) {
        if (fromClass == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(38);
        }
        if (refClass != null) {
            return PhpLangUtil.isClassNameSpecial(name) || refClass.getManager().areElementsEquivalent((PsiElement)refClass, (PsiElement)fromClass) || PhpClassHierarchyUtils.isSuperClass((PhpClass)refClass, (PhpClass)fromClass, (boolean)true);
        }
        return true;
    }

    private static void resolveReferencesInDoc(PhpDocType type, Method method) {
        PhpClass fromClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (fromClass != null) {
            PhpDocType element;
            PhpClass parentClass = fromClass.getSuperClass();
            String fromClassName = fromClass.getName();
            String parentClassName = null;
            if (parentClass != null) {
                parentClassName = parentClass.getName();
            }
            Object object = element = type.getText().equalsIgnoreCase("$this") ? type : PhpPsiUtil.getChildOfType((PsiElement)type, PhpDocTokenTypes.DOC_IDENTIFIER);
            if (element != null) {
                if (element.getText().equalsIgnoreCase("self")) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + fromClassName + "*/"));
                }
                if (element.getText().equalsIgnoreCase("parent") && parentClassName != null) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + parentClassName + "*/"));
                }
                if (element.getText().equalsIgnoreCase("$this")) {
                    element.replace(PhpPsiElementFactory.createFromText(type.getProject(), PhpDocTokenTypes.DOC_IDENTIFIER, "/** " + fromClassName + "*/"));
                }
            }
        }
    }

    protected Method resolveAliasesInParameters(@NotNull Method method) {
        Parameter[] parameters;
        if (method == null) {
            PhpMoveClassMemberBase.$$$reportNull$$$0(39);
        }
        for (Parameter it : parameters = method.getParameters()) {
            PhpClass phpClass;
            PsiReference reference;
            ClassReference firstChild;
            if (!(it.getFirstChild() instanceof ClassReference) || (firstChild = (ClassReference)it.getFirstChild()) == null || (reference = firstChild.getReference()) == null || (phpClass = (PhpClass)reference.resolve()) == null) continue;
            String name = phpClass.getName();
            if (!phpClass.getNamespaceName().equals(this.myTargetClass.getNamespaceName())) continue;
            firstChild.replace((PsiElement)PhpPsiElementFactory.createClassReference(method.getProject(), name));
        }
        return method;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 33: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 33: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 12: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: 
            case 18: 
            case 31: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentAccess";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationAccess";
                break;
            }
            case 17: 
            case 23: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 19: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCode";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldList";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "move";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cutAndMove";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "moveField";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethodUp";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addField";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "constructField";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethodWithPhpDoc";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "addPhpDocMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 33: 
            case 36: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeMembers";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cutAndMove";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScopeHolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "moveField";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateMethodAccess";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMethodUp";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addField";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "constructField";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFieldListElement";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSingleFieldList";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addMethodWithPhpDoc";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addPhpDocMethod";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "refactorInternalReferences";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeReplacedByClassName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasesInParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 25: 
            case 27: 
            case 33: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpMoveClassMemberToInterface
    extends PhpMoveClassMemberBase {
        private static final String DESTINATION_ACCESS = "public";

        PhpMoveClassMemberToInterface(PhpClass clazz, boolean shouldWeakAccess) {
            super(clazz, shouldWeakAccess);
        }

        @Override
        @NotNull
        protected Method moveMethod(@NotNull Method method, List<PhpClassMember> members) {
            if (method == null) {
                PhpMoveClassMemberToInterface.$$$reportNull$$$0(0);
            }
            String methodCode = PhpFunctionCodeGenerator.DECLARATION.generate((Function)method) + ";";
            PhpModifier.Access access = method.getAccess();
            String currentAccess = !this.myShouldWeakAccess || access.isPublic() ? null : StringUtil.toLowerCase((String)access.toString());
            Method declaration = this.addMethodUp(this.myTargetClass, method, methodCode, currentAccess, DESTINATION_ACCESS);
            if (currentAccess != null) {
                this.updateMethodAccess(method, currentAccess, DESTINATION_ACCESS);
            }
            Method method2 = declaration;
            if (method2 == null) {
                PhpMoveClassMemberToInterface.$$$reportNull$$$0(1);
            }
            return method2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMemberToInterface";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMemberToInterface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "moveMethod";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpMoveClassMember
    extends PhpMoveClassMemberBase {
        private PhpMoveClassMember(PhpClass targetClass, boolean shouldWeakAccess) {
            super(targetClass, shouldWeakAccess);
        }

        @Override
        @NotNull
        protected Method moveMethod(@NotNull Method method, List<PhpClassMember> members) {
            if (method == null) {
                PhpMoveClassMember.$$$reportNull$$$0(0);
            }
            PhpModifier.Access access = method.getAccess();
            String currentAccess = this.myShouldWeakAccess && access.isPrivate() ? StringUtil.toLowerCase((String)access.toString()) : null;
            PhpClass fromClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            method = this.resolveAliasesInParameters(method);
            method = this.resolvePhpDoc(method);
            method = this.refactorInternalReferences(method, fromClass, members);
            Method method2 = this.addMethodUp(this.myTargetClass, method, method.getText(), currentAccess, "protected");
            if (method2 == null) {
                PhpMoveClassMember.$$$reportNull$$$0(1);
            }
            return method2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMember";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/refactoring/PhpMoveClassMemberBase$PhpMoveClassMember";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moveMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "moveMethod";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

