/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.makeStatic;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticConflicts;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticDialog;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettings;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMakeStaticProcessor
extends BaseRefactoringProcessor {
    final PhpMakeStaticSettings mySettings;
    private final Method myMethod;

    protected PhpMakeStaticProcessor(@NotNull Project project, Method method, PhpMakeStaticSettings settings) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myMethod = method;
        this.mySettings = settings;
    }

    public static Method doMakeStatic(Method input, final PhpMakeStaticSettings settings) {
        final Project project = input.getProject();
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)input, PhpElementTypes.PARAMETER_LIST);
        if (settings.isPassedByObject()) {
            PhpChangeSignatureProcessor.addParameter(parameterList, PhpPsiElementFactory.createParameter(project, settings.getObjectName()));
        }
        if (settings.isPassedByFields()) {
            for (PhpMakeStaticParameterInfo info : settings.getSelectedParameterInfos()) {
                PhpChangeSignatureProcessor.addParameter(parameterList, PhpPsiElementFactory.createParameter(project, info.name));
            }
        }
        PhpMakeStaticProcessor.fixDoc(input, settings, project);
        Method output = PhpMakeStaticProcessor.makeStaticMethod(input, project);
        final ArrayList fieldReferences = new ArrayList();
        output.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(FieldReference fieldReference) {
                fieldReferences.add(fieldReference);
                super.visitPhpFieldReference(fieldReference);
            }

            public void visitPhpVariable(Variable variable) {
                if (settings.isPassedByObject() && variable.getName().equals("this") && settings.isPassedByObject()) {
                    variable.replace((PsiElement)PhpPsiElementFactory.createVariable(project, settings.getObjectName(), true));
                }
                super.visitPhpVariable(variable);
            }
        });
        for (FieldReference fieldReference : fieldReferences) {
            String fieldReferenceName = fieldReference.getName();
            if (fieldReferenceName == null) continue;
            PhpMakeStaticParameterInfo parameterInfo = PhpMakeStaticProcessor.findParameterInfo(fieldReferenceName, settings);
            if (parameterInfo != null) {
                fieldReference.replace((PsiElement)PhpPsiElementFactory.createVariable(fieldReference.getProject(), parameterInfo.name, true));
                continue;
            }
            if (!settings.isPassedByObject()) continue;
            fieldReference.replace((PsiElement)PhpPsiElementFactory.createFieldReference(project, settings.getObjectName(), fieldReferenceName));
        }
        return output;
    }

    @NotNull
    private static Method makeStaticMethod(Method input, Project project) {
        PhpModifierList newModifierList;
        PhpPsiElement modifierList = input.getFirstPsiChild();
        if (modifierList != null && modifierList.getTextLength() > 0 && (newModifierList = PhpPsiElementFactory.createFirstFromText(project, PhpModifierList.class, "class A {" + modifierList.getText() + " static function f(){}}")) != null) {
            modifierList.replace((PsiElement)newModifierList);
            Method method = input;
            if (method == null) {
                PhpMakeStaticProcessor.$$$reportNull$$$0(1);
            }
            return method;
        }
        Method method = PhpPsiElementFactory.createMethod(project, "static " + input.getText());
        if (method == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(2);
        }
        return method;
    }

    private static void fixDoc(Method input, PhpMakeStaticSettings settings, Project project) {
        PhpDocComment original2 = input.getDocComment();
        if (original2 == null) {
            PsiElement parent = input.getParent();
            if (settings.isPassedByObject() || settings.isPassedByFields()) {
                PhpDocComment docComment = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, "<?php /**\n*/");
                assert (docComment != null);
                parent.addBefore((PsiElement)docComment, (PsiElement)input);
            }
        }
        PhpChangeSignatureUsageProcessor.fixPhpDoc((Function)input, false);
        PhpDocComment docComment = input.getDocComment();
        PhpClass containingClass = settings.getMethod().getContainingClass();
        if (docComment != null) {
            PhpDocParamTag docParamTag;
            PhpDocParamTag tagByName = docComment.getParamTagByName(settings.getObjectName());
            if (containingClass != null && (docParamTag = PhpPsiElementFactory.createFromText(project, PhpDocParamTag.class, "/** @param " + containingClass.getName() + " $" + settings.getObjectName() + "\n")) != null && tagByName != null) {
                tagByName.replace((PsiElement)docParamTag);
            }
        }
    }

    public static PhpMakeStaticParameterInfo findParameterInfo(String fieldReferenceName, PhpMakeStaticSettings settings) {
        for (PhpMakeStaticParameterInfo it : settings.getSelectedParameterInfos()) {
            if (!it.getName().equals(fieldReferenceName)) continue;
            return it;
        }
        return null;
    }

    private static void refactorUsages(@NotNull Project project, @NotNull UsageInfo[] usages, @NotNull PhpMakeStaticSettings settings, Method method) {
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(5);
        }
        ArrayList<PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo> newUsages = new ArrayList<PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo>();
        PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor((Function)method);
        List<PhpParameterInfo> allParams = methodDescriptor.getParameters();
        allParams.addAll(PhpMakeStaticDialog.getAllParametersList(settings, "placeholder"));
        PhpChangeInfo phpChangeInfo = new PhpChangeInfo(methodDescriptor, allParams.toArray(new PhpParameterInfo[0]), methodDescriptor.getVisibility(), methodDescriptor.getName(), methodDescriptor.getReturnTypeText(), new HashSet<Function>(), false);
        for (UsageInfo it : usages) {
            PsiElement element = it.getElement();
            if (!(element instanceof MethodReference)) continue;
            MethodReference methodReference = (MethodReference)element;
            newUsages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)methodReference, phpChangeInfo, false));
        }
        for (PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo it : newUsages) {
            allParams = methodDescriptor.getParameters();
            PsiElement itElement = it.getElement();
            if (!(itElement instanceof MethodReference)) continue;
            MethodReference methodReference = (MethodReference)itElement;
            if (((MethodReference)itElement).isStatic()) {
                PhpClass containingClass = settings.getMethod().getContainingClass();
                if (containingClass != null && PhpMakeStaticProcessor.classReferenceSpecial(methodReference, containingClass)) {
                    allParams.addAll(PhpMakeStaticDialog.getAllParametersList(settings, "$this"));
                }
            } else {
                PhpExpression classReference = methodReference.getClassReference();
                if (classReference != null) {
                    allParams.addAll(PhpMakeStaticDialog.getAllParametersList(settings, classReference.getText()));
                }
            }
            it.process(new PhpChangeInfo(methodDescriptor, allParams.toArray(new PhpParameterInfo[0]), methodDescriptor.getVisibility(), methodDescriptor.getName(), methodDescriptor.getReturnTypeText(), new HashSet<Function>(), false), false);
            PhpMakeStaticProcessor.makeStaticCall(project, methodReference);
        }
    }

    private static boolean classReferenceSpecial(@NotNull MethodReference methodRef, @NotNull PhpClass clazz) {
        PsiElement resolvedElement;
        if (methodRef == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(7);
        }
        return (resolvedElement = methodRef.resolve()) instanceof PhpClassMember && ("parent".equals(methodRef.getName()) || "self".equals(methodRef.getName()) || clazz.equals(((PhpClassMember)resolvedElement).getContainingClass()));
    }

    @Nullable
    public static PsiReference getClassReference(PhpExpression classReference) {
        PhpExpression reference;
        if (classReference instanceof MemberReference && (reference = ((MemberReference)classReference).getClassReference()) != null) {
            return reference.getReference();
        }
        return null;
    }

    private static void makeStaticCall(@NotNull Project project, @NotNull MethodReference methodReference) {
        PsiReference reference;
        PhpExpression classReference;
        if (project == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(8);
        }
        if (methodReference == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(9);
        }
        if ((classReference = methodReference.getClassReference()) != null && !(classReference instanceof MemberReference) && (reference = classReference.getReference()) != null) {
            PsiElement resolved = methodReference.resolve();
            PhpClass resolve = (PhpClass)PhpPsiUtil.getParentByCondition(resolved, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)methodReference);
            if (resolve != null) {
                PsiElement siblingIgnoreWhitespace;
                String name = resolve.getName();
                String aliasName = null;
                if (scopeForUseOperator != null) {
                    List<PhpUseList> imports = PhpCodeInsightUtil.collectImports(scopeForUseOperator);
                    for (PhpUseList list : imports) {
                        PhpUse[] declarations;
                        for (PhpUse declaration : declarations = list.getDeclarations()) {
                            if (!PhpLangUtil.equalsClassNames(declaration.getFQN(), resolve.getFQN())) continue;
                            name = declaration.getName();
                            aliasName = declaration.getAliasName();
                        }
                    }
                }
                if ((siblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace(methodReference.getFirstChild(), false)) != null) {
                    String methodCallText = methodReference.getText().substring(siblingIgnoreWhitespace.getTextRange().getEndOffset() - methodReference.getTextOffset());
                    String newMethodReferenceText = (aliasName == null ? name : aliasName) + methodCallText;
                    newMethodReferenceText = newMethodReferenceText.replaceFirst("->", "::");
                    methodReference.replace((PsiElement)PhpPsiElementFactory.createMethodReference(project, newMethodReferenceText));
                }
            }
        }
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(10);
        }
        UsageViewDescriptor usageViewDescriptor = new UsageViewDescriptor(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{PhpMakeStaticProcessor.this.myMethod};
                if (psiElementArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.make.method.static.method.converts.method.to.static", new Object[0]);
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return PhpBundle.message("refactoring.make.method.static.references.to.be.changed", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
            }

            @Nullable
            public String getCommentReferencesText(int usagesCount, int filesCount) {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticProcessor$2", "getElements"));
            }
        };
        if (usageViewDescriptor == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(11);
        }
        return usageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        Collection<PsiReference> references = PhpMoveMemberProcessor.findReferences((PsiElement)this.myMethod);
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            result.add(new UsageInfo(element));
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(12);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(13);
        }
        CommandProcessor.getInstance().executeCommand(this.myMethod.getProject(), () -> {
            if (usages == null) {
                PhpMakeStaticProcessor.$$$reportNull$$$0(16);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (usages == null) {
                    PhpMakeStaticProcessor.$$$reportNull$$$0(17);
                }
                PhpMakeStaticProcessor.refactorUsages(this.myProject, usages, this.mySettings, this.myMethod);
                Method newStaticMethod = PhpMakeStaticProcessor.doMakeStatic(this.myMethod, this.mySettings);
                this.myMethod.replace((PsiElement)newStaticMethod);
                PhpChangeSignatureUsageProcessor.fixPhpDoc((Function)newStaticMethod, false);
            });
        }, "Make static", null);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(14);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        ArrayList<PsiFile> affectedFiles = new ArrayList<PsiFile>();
        for (UsageInfo it : usages) {
            PsiElement methodReference = it.getElement();
            if (methodReference == null) continue;
            PsiFile containingFile = methodReference.getContainingFile();
            affectedFiles.add(containingFile);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, affectedFiles, (boolean)true)) {
            return false;
        }
        PhpMakeStaticConflicts conflicts = new PhpMakeStaticConflicts(this.myMethod);
        conflicts.checkInternalReferences(this.myMethod, this.mySettings);
        conflicts.checkUsagesForConflicts((UsageInfo[])refUsages.get(), this.mySettings);
        conflicts.checkSettings(this.mySettings);
        conflicts.checkOverriding(this.myMethod);
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    @NotNull
    protected String getCommandName() {
        if ("Make method static" == null) {
            PhpMakeStaticProcessor.$$$reportNull$$$0(15);
        }
        return "Make method static";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticProcessor";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStaticMethod";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refactorUsages";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "classReferenceSpecial";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeStaticCall";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performRefactoring$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

