/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.hierarchy.PhpHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpMemberDocVisitor;
import com.jetbrains.php.refactoring.move.member.PhpAbstractMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberConflicts
extends PhpAbstractMemberConflicts {
    protected final Collection<PhpClassMember> mySelectedMembers;
    protected final PhpClass myFromClass;
    protected final PhpClass myTargetClass;

    public PhpMoveMemberConflicts(Collection<PhpClassMember> members, PhpClass fromClass, PhpClass targetClass) {
        this.mySelectedMembers = members;
        this.myFromClass = fromClass;
        this.myTargetClass = targetClass;
    }

    protected static String validateMemberInfo(Collection<? extends PhpClassMember> members) {
        for (PhpClassMember phpClassMember : members) {
            if (phpClassMember.getModifier().isPublic()) continue;
            return PhpBundle.message("refactoring.move.members.member.will.change.visibility.to.public", phpClassMember.getName());
        }
        return null;
    }

    protected static String getValidationResult(Collection<? extends PhpClass> classes, String destClassText, PhpClass fromClass, Collection<? extends PhpClassMember> selectedMembers, boolean inTimeValidation) {
        PhpClass toClass;
        String constToInterface;
        ArrayList<String> validationResults = new ArrayList<String>();
        String validateClassNames = PhpMoveMemberDialog.validateClassNames(fromClass, destClassText, classes);
        if (validateClassNames != null) {
            validationResults.add(validateClassNames);
        }
        if (classes.size() == 1 && (constToInterface = PhpMoveMemberConflicts.constToInterface(selectedMembers, toClass = classes.iterator().next())) != null) {
            validationResults.add(constToInterface);
        }
        if (inTimeValidation) {
            if (classes.size() == 1) {
                toClass = classes.iterator().next();
                for (PhpClassMember phpClassMember : selectedMembers) {
                    PhpClass containingClass;
                    String alreadyContainsMethodMessage = PhpMoveMemberConflicts.alreadyContainsMethodMessage(toClass, fromClass, (PhpPsiElement)phpClassMember);
                    if (alreadyContainsMethodMessage != null && validationResults.isEmpty()) {
                        validationResults.add(alreadyContainsMethodMessage);
                    }
                    if (!(phpClassMember instanceof Method)) continue;
                    Method method = (Method)phpClassMember;
                    PhpClass superClass = fromClass.getSuperClass();
                    PhpClass[] superInterfaces = fromClass.getImplementedInterfaces();
                    PhpClass[] traits = fromClass.getTraits();
                    Method baseMethod = PhpHierarchyUtils.findMethodInSuperClasses(fromClass, method);
                    PhpClass implementedInterface = null;
                    PhpClass implementedTrait = null;
                    if (baseMethod == null) continue;
                    for (PhpClass superInterface : superInterfaces) {
                        containingClass = baseMethod.getContainingClass();
                        if (containingClass == null || !containingClass.equals(superInterface)) continue;
                        implementedInterface = superInterface;
                    }
                    for (PhpClass traitIt : traits) {
                        containingClass = baseMethod.getContainingClass();
                        if (containingClass == null || !containingClass.equals(traitIt)) continue;
                        implementedTrait = traitIt;
                    }
                    if (superClass != null && baseMethod.isAbstract()) {
                        validationResults.add(PhpBundle.message("refactoring.move.members.method.implements.abstract.method", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)true)));
                    }
                    if (implementedInterface != null) {
                        validationResults.add(PhpBundle.message("refactoring.move.members.method.implements.method.in", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)implementedInterface, (boolean)true)));
                    }
                    if (implementedTrait == null) continue;
                    validationResults.add(PhpBundle.message("refactoring.move.members.method.implements.method.in", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)implementedTrait, (boolean)true)));
                }
            }
            validationResults.add(PhpMoveMemberConflicts.validateMemberInfo(selectedMembers));
        }
        return PhpMoveMemberConflicts.createMessage(validationResults);
    }

    @Nullable
    private static String constToInterface(Collection<? extends PhpClassMember> selectedMembers, PhpClass toClass) {
        if (toClass.isInterface() && !PhpMoveMemberDialog.constantsOnly(selectedMembers)) {
            return PhpBundle.message("refactoring.move.members.only.constants.can.be.moved.to.interface", new Object[0]);
        }
        return null;
    }

    public void checkUsagesForConflicts(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(0);
        }
        for (UsageInfo usage : usages) {
            PsiElement child;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            if (element instanceof StringLiteralExpression) {
                PhpPsiElement statement = PhpMoveMemberConflicts.getStatementOrParameter(element);
                String message = PhpBundle.message("refactoring.move.members.unable.to.resolve.usage.callback.found", statement != null ? statement.getText() : "", RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true));
                this.myConflicts.putValue((Object)element, (Object)message);
            }
            if (!((child = element.getFirstChild()) instanceof ClassReference) || !PhpPsiUtil.isOfType(child.getFirstChild(), PhpTokenTypes.kwSTATIC)) continue;
            PsiElement statement = element instanceof Expression ? element : element.getParent();
            String message = PhpBundle.message("refactoring.move.members.unable.to.resolve.usage.late.static.binding.detected", statement == null ? "" : statement.getText(), RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true));
            this.myConflicts.putValue((Object)child, (Object)message);
        }
    }

    @Nullable
    private static PhpPsiElement getStatementOrParameter(@NotNull PsiElement element) {
        if (element == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(1);
        }
        return (PhpPsiElement)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)element1 -> element1 instanceof Statement || element1 instanceof Parameter));
    }

    @Override
    public void processClassReference(ClassReference classRef) {
        super.processClassReference(classRef);
        String name = classRef.getName();
        if (name != null && this.myFromClass.isAnonymous() && name.equalsIgnoreCase("self") && this.getConflicts().get((Object)classRef).isEmpty()) {
            this.getConflicts().putValue((Object)classRef, (Object)PhpBundle.message("refactoring.move.members.self.from.anonymous.class", classRef.getText(), RefactoringUIUtil.getDescription((PsiElement)classRef, (boolean)true)));
        }
    }

    public void checkInternalReferences(@NotNull Method method) {
        if (method == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(2);
        }
        MultiMap usedMembers = new MultiMap();
        PhpDocComment comment = method.getDocComment();
        if (comment != null) {
            comment.accept((PsiElementVisitor)new PhpMemberDocVisitor((MultiMap<PsiElement, String>)this.myConflicts));
        }
        method.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFieldReference(@NotNull FieldReference fieldReference) {
                if (fieldReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.processMemberReference((MemberReference)fieldReference);
                super.visitPhpFieldReference(fieldReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.processMemberReference((MemberReference)constantReference);
                super.visitPhpClassConstantReference(constantReference);
            }

            public void visitPhpClassReference(ClassReference constantReference) {
                PhpMoveMemberConflicts.this.processClassReference(constantReference);
                super.visitPhpClassReference(constantReference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.processMemberReference((MemberReference)reference);
                super.visitPhpMethodReference(reference);
            }

            private boolean isConflictParentSelfNonStaticCase(String classReferenceName, PhpClassMember member) {
                return (classReferenceName.equalsIgnoreCase("parent") || classReferenceName.equalsIgnoreCase("self")) && !member.getModifier().isStatic();
            }

            private void processMemberReference(@NotNull MemberReference reference) {
                PsiElement firstChild;
                if (reference == null) {
                    1.$$$reportNull$$$0(1);
                }
                PhpExpression classRef = reference.getClassReference();
                PsiElement resolvedMember = reference.resolve();
                PsiElement lastChild = reference.getLastChild();
                if (resolvedMember == null && PhpPsiUtil.isOfType(lastChild, PhpTokenTypes.kwCLASS) && (firstChild = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.kwSTATIC)) != null && PhpMoveMemberConflicts.this.getConflicts().get((Object)firstChild).isEmpty()) {
                    PhpMoveMemberConflicts.this.getConflicts().putValue((Object)PhpPsiUtil.getChildOfType(firstChild, PhpTokenTypes.kwSTATIC), (Object)PhpBundle.message("refactoring.move.members.late.static.binding.detected", reference.getText(), RefactoringUIUtil.getDescription((PsiElement)reference, (boolean)true)));
                }
                if (resolvedMember != null) {
                    String name;
                    PhpClass resolvedClass = (PhpClass)PhpPsiUtil.getParentByCondition(resolvedMember, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (classRef != null && (name = classRef.getName()) != null) {
                        if (name.equalsIgnoreCase("static") && PhpMoveMemberConflicts.this.getConflicts().get((Object)classRef).isEmpty()) {
                            PhpMoveMemberConflicts.this.getConflicts().putValue((Object)PhpPsiUtil.getChildOfType((PsiElement)classRef, PhpTokenTypes.kwSTATIC), (Object)PhpBundle.message("refactoring.move.members.late.static.binding.detected", reference.getText(), RefactoringUIUtil.getDescription((PsiElement)resolvedMember, (boolean)true)));
                        }
                        if (this.isConflictParentSelfNonStaticCase(name, (PhpClassMember)resolvedMember)) {
                            PhpMoveMemberConflicts.this.getConflicts().putValue((Object)reference, (Object)PhpBundle.message("refactoring.move.members.unable.to.resolve", reference.getText(), RefactoringUIUtil.getDescription((PsiElement)resolvedMember, (boolean)true)));
                        }
                        boolean contains = false;
                        for (PhpClassMember it : PhpMoveMemberConflicts.this.mySelectedMembers) {
                            if (!it.equals(resolvedMember)) continue;
                            contains = true;
                        }
                        if (!contains && !PhpMoveMemberConflicts.isAccessible(PhpMoveMemberConflicts.this.myTargetClass, (PhpClassMember)resolvedMember, resolvedClass)) {
                            PhpMoveMemberConflicts.this.getConflicts().putValue((Object)reference, (Object)PhpBundle.message("refactoring.move.members.is.not.accessible", reference.getText(), RefactoringUIUtil.getDescription((PsiElement)PhpMoveMemberConflicts.this.myTargetClass, (boolean)true)));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldReference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberConflicts$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPhpFieldReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processMemberReference";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (Map.Entry referenceToMember : usedMembers.entrySet()) {
            for (PhpReference memberReference : (Collection)referenceToMember.getValue()) {
                String message;
                PhpClassMember member;
                if (this.shouldBeMoved(memberReference) || (member = (PhpClassMember)memberReference.resolve()) == null || (message = this.checkMemberAccess((String)referenceToMember.getKey(), member)) == null) continue;
                this.getConflicts().putValue((Object)memberReference, (Object)message);
            }
        }
    }

    public static boolean isAccessible(PhpClass targetClass, PhpClassMember member, PhpClass resolvedClass) {
        if (member.getModifier().isPrivate()) {
            return false;
        }
        if (member.getModifier().isProtected()) {
            return resolvedClass.equals(targetClass) || PhpClassHierarchyUtils.isSuperClass((PhpClass)resolvedClass, (PhpClass)targetClass, (boolean)true);
        }
        return true;
    }

    private boolean shouldBeMoved(@NotNull PhpReference member) {
        if (member == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(3);
        }
        for (PhpClassMember info : this.mySelectedMembers) {
            String referenceClassFQN = PhpMoveMemberProcessor.getClass(member.resolve()).getFQN();
            if (!PhpLangUtil.equalsMethodNames(info.getName(), member.getNameCS()) || !PhpLangUtil.equalsClassNames(referenceClassFQN, this.myFromClass.getFQN())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected String checkMemberAccess(@NotNull String classReference, @NotNull PhpClassMember member) {
        if (classReference == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(4);
        }
        if (member == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(5);
        }
        if (PhpLangUtil.equalsClassNames("parent", classReference)) {
            return PhpBundle.message("refactoring.pull.up.may.not.be.accessible.in.the.target.class", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true));
        }
        if (!PhpLangUtil.equalsClassNames(classReference, this.myFromClass.getNameCS()) && !member.getModifier().isPublic()) {
            return PhpBundle.message("refactoring.pull.up.will.not.be.accessible.in.the.target.class", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true));
        }
        return null;
    }

    public void checkFinalMethods(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(6);
        }
        for (PhpClassMember member : this.mySelectedMembers) {
            PhpClass subClass = PhpMoveMemberConflicts.isAlreadyImplemented(this.myFromClass, targetClass, (PhpPsiElement)member);
            if (subClass == null) continue;
            this.getConflicts().putValue((Object)member, (Object)PhpBundle.message("refactoring.move.member.method.is.overridden.in.a.sublclass", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)subClass, (boolean)false)));
        }
    }

    public void checkAlreadyDefinedMembers(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(7);
        }
        for (PhpClassMember member : this.mySelectedMembers) {
            String message = PhpMoveMemberConflicts.alreadyContainsMethodMessage(targetClass, this.myFromClass, (PhpPsiElement)member);
            if (message == null) continue;
            this.getConflicts().putValue((Object)member, (Object)message);
        }
    }

    public static String alreadyContainsMethodMessage(PhpClass targetClass, PhpClass fromClass, PhpPsiElement member) {
        MethodNameConflictType containsMember = PhpMoveMemberConflicts.alreadyContainsMember(targetClass, member, fromClass);
        if (containsMember == MethodNameConflictType.DUPLICATE) {
            return RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
        }
        if (containsMember == MethodNameConflictType.HIDE) {
            return PhpBundle.message("refactoring.move.members.0.will.be.hidden.in.1", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)false));
        }
        return null;
    }

    public static boolean hidesMember(PhpClassMember foundMember, PhpClass fromClass) {
        PhpClass aClass = foundMember.getContainingClass();
        return !foundMember.getModifier().isPrivate() && (aClass == null || !aClass.equals(fromClass));
    }

    @NotNull
    private static MethodNameConflictType checkContains(PhpClassMember foundMember, PhpClassMember foundOwnMember, PhpClass fromClass) {
        MethodNameConflictType answer = MethodNameConflictType.NONE;
        if (foundMember != null) {
            if (PhpMoveMemberConflicts.hidesMember(foundMember, fromClass)) {
                answer = MethodNameConflictType.HIDE;
            }
            if (foundOwnMember != null) {
                answer = MethodNameConflictType.DUPLICATE;
            }
        }
        MethodNameConflictType methodNameConflictType = answer;
        if (methodNameConflictType == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(8);
        }
        return methodNameConflictType;
    }

    public static MethodNameConflictType alreadyContainsMember(PhpClass targetClass, PhpPsiElement member, PhpClass fromClass) {
        MethodNameConflictType answer = MethodNameConflictType.NONE;
        String memberName = member.getName();
        if (member instanceof Field) {
            Field foundField = targetClass.findFieldByName((CharSequence)memberName, ((Field)member).isConstant());
            Field foundOwnField = targetClass.findOwnFieldByName((CharSequence)memberName, ((Field)member).isConstant());
            answer = PhpMoveMemberConflicts.checkContains((PhpClassMember)foundField, (PhpClassMember)foundOwnField, fromClass);
        }
        if (member instanceof Method) {
            Method foundMethod = targetClass.findMethodByName((CharSequence)memberName);
            Method foundOwnMethod = targetClass.findOwnMethodByName((CharSequence)memberName);
            answer = PhpMoveMemberConflicts.checkContains((PhpClassMember)foundMethod, (PhpClassMember)foundOwnMethod, fromClass);
        }
        if (PhpClassHierarchyUtils.isSuperClass((PhpClass)fromClass, (PhpClass)targetClass, (boolean)true) || PhpMoveMemberConflicts.chekIfFromClassIsTraitInTargetClass(targetClass, fromClass) && answer != MethodNameConflictType.DUPLICATE) {
            return MethodNameConflictType.NONE;
        }
        return answer;
    }

    private static boolean chekIfFromClassIsTraitInTargetClass(PhpClass targetClass, PhpClass fromClass) {
        return fromClass.isTrait() && ArrayUtil.contains((Object)fromClass, (Object[])targetClass.getTraits());
    }

    @Nullable
    public static PhpClass isAlreadyImplemented(@NotNull PhpClass fromClass, @NotNull PhpClass targetClass, @NotNull PhpPsiElement member) {
        if (fromClass == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(9);
        }
        if (targetClass == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(10);
        }
        if (member == null) {
            PhpMoveMemberConflicts.$$$reportNull$$$0(11);
        }
        PhpClass answer = null;
        String memberName = member.getName();
        if (member instanceof Method) {
            Collection subclasses = PhpClassHierarchyUtils.getAllSubclasses((PhpClass)targetClass);
            for (PhpClass subclass : subclasses) {
                if (subclass.equals(fromClass) || subclass.findOwnMethodByName((CharSequence)memberName) == null) continue;
                answer = subclass;
            }
        }
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberConflicts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberConflicts";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "checkContains";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkUsagesForConflicts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStatementOrParameter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkInternalReferences";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeMoved";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberAccess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFinalMethods";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAlreadyDefinedMembers";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyImplemented";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum MethodNameConflictType {
        NONE,
        HIDE,
        DUPLICATE;

    }
}

