/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpNameUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PhpRenameInputValidator
implements RenameInputValidator {
    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.psiElement(PhpNamedElement.class);
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        if (element instanceof PhpFile) {
            String oldFileName = ((PhpFile)element).getName();
            if (!PhpNameUtil.getExtension(oldFileName).equals(PhpNameUtil.getExtension(newName))) {
                return false;
            }
            return PhpNameUtil.isValidFileName(newName);
        }
        return PhpRenameInputValidator.isValidName((PhpNamedElement)element, newName);
    }

    @Contract(value="_, null -> false")
    private static boolean isValidName(@NotNull PhpNamedElement element, String name) {
        if (element == null) {
            PhpRenameInputValidator.$$$reportNull$$$0(0);
        }
        if (name == null || name.length() == 0) {
            return false;
        }
        if (element instanceof Variable || element instanceof PhpDocVariable) {
            return PhpNameUtil.isValidVariableName(name);
        }
        if (element instanceof PhpClass) {
            return PhpNameUtil.isValidClassName(name);
        }
        if (element instanceof Method) {
            return PhpNameUtil.isValidMethodName(name);
        }
        if (element instanceof Function) {
            return PhpNameUtil.isValidFunctionName(name);
        }
        if (element instanceof Field) {
            return ((Field)element).isConstant() ? PhpNameUtil.isValidClassConstantName(name) : PhpNameUtil.isValidFieldName(name);
        }
        if (element instanceof Parameter) {
            return PhpNameUtil.isValidParameterName(name);
        }
        if (element instanceof Constant) {
            return PhpNameUtil.isValidConstantName(name);
        }
        if (element instanceof PhpNamespace) {
            return PhpNameUtil.isValidNamespaceName(name);
        }
        if (element instanceof PhpGotoLabel) {
            return PhpNameUtil.isValidGotoLabelName(name);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/rename/PhpRenameInputValidator", "isValidName"));
    }
}

