/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInplaceRenamer
extends VariableInplaceRenamer {
    private Set<CharSequence> myUsedVariableNames;

    public PhpVariableInplaceRenamer(PsiNamedElement rename, Editor editor) {
        super(rename, editor);
        this.collectVariables(rename);
    }

    public PhpVariableInplaceRenamer(PsiNamedElement elementToRename, Editor editor, Project project, String initialName, String oldName) {
        super(elementToRename, editor, project, initialName, oldName);
        this.collectVariables(elementToRename);
    }

    protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
        PsiElement element;
        PsiReference referenceAtCaret = PhpRefactoringUtil.getReferenceAtCaret(scope, this.myEditor);
        if (referenceAtCaret != null && (element = referenceAtCaret.getElement()) != null) {
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, element, referenceAtCaret.getRangeInElement());
        }
        return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
    }

    private void collectVariables(PsiNamedElement elementToRename) {
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations((PsiElement)elementToRename, true, null);
        this.myUsedVariableNames = new THashSet();
        for (PhpNamedElement phpNamedElement : declarations) {
            this.myUsedVariableNames.add(phpNamedElement.getNameCS());
        }
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(0);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(2);
        }
        PsiElement element = reference.getElement();
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), element);
        if (textRange == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    protected boolean performRefactoring() {
        if (!PhpLangUtil.equalsVariableNames(this.myOldName, this.myInsertedName) && this.myUsedVariableNames.contains(this.myInsertedName)) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)PhpBundle.message("conflict.variable.with.same.name.already.exists", new Object[0]), (String)"", null);
        }
        return super.performRefactoring();
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        PhpVariableInplaceRenamer phpVariableInplaceRenamer = new PhpVariableInplaceRenamer(variable, editor, this.myProject, initialName, this.myOldName);
        if (phpVariableInplaceRenamer == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(4);
        }
        return phpVariableInplaceRenamer;
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        if (this.myElementToRename instanceof Parameter) {
            Object clazz = PhpPsiUtil.getParentByCondition((PsiElement)this.myElementToRename, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            return clazz == null ? this.myElementToRename.getContainingFile() : null;
        }
        if (this.myElementToRename instanceof PhpGotoLabel) {
            Object function = PhpPsiUtil.getParentByCondition((PsiElement)this.myElementToRename, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (function != null) {
                return function;
            }
            return this.myElementToRename.getContainingFile();
        }
        return super.checkLocalScope();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInplaceRenamerToRestart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

