/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.deploymentAware.phpunit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnitRemoteCreateDialog<S extends PhpUnitSettings, T extends ComboboxWithBrowseButton>
extends DialogWrapper {
    protected Project myProject;
    protected List<S> mySettings;
    protected T myComboBox;

    protected PhpUnitRemoteCreateDialog(@Nullable Project project, @NotNull List<? extends PhpTestFrameworkConfiguration> settings) {
        if (settings == null) {
            PhpUnitRemoteCreateDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myProject = project;
        this.mySettings = ContainerUtil.newArrayList();
        for (PhpTestFrameworkConfiguration phpTestFrameworkConfiguration : settings) {
            this.filterSettings(phpTestFrameworkConfiguration);
        }
    }

    protected abstract void initComboBox();

    protected void filterSettings(@NotNull PhpTestFrameworkConfiguration settings) {
        if (settings == null) {
            PhpUnitRemoteCreateDialog.$$$reportNull$$$0(1);
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.initComboBox();
        Disposer.register((Disposable)this.getDisposable(), this.myComboBox);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        JLabel label = new JLabel(this.getLabelText());
        panel.add((Component)label, gc);
        gc.weightx = 1.0;
        ++gc.gridx;
        this.myComboBox.setPreferredSize(new Dimension(200, this.myComboBox.getPreferredSize().height));
        label.setLabelFor((Component)this.myComboBox);
        panel.add((Component)this.myComboBox, gc);
        Font font = this.myComboBox.getFont();
        if (font != null) {
            FontMetrics fontMetrics = this.myComboBox.getFontMetrics(font);
            int width = fontMetrics.charWidth('a') * 60;
            panel.setPreferredSize(new Dimension(width, 50));
        }
        return panel;
    }

    protected abstract String getLabelText();

    protected boolean postponeValidation() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "settings";
        objectArray2[1] = "com/jetbrains/php/run/deploymentAware/phpunit/PhpUnitRemoteCreateDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "filterSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

