/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run.remoteDebug;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.remoteDebug.PhpRemoteDebugRunConfigurationEditor;
import org.jetbrains.annotations.NotNull;

public class PhpRemoteDebugRunConfiguration
extends PhpRunConfiguration<Settings>
implements RunConfigurationWithSuppressedDefaultRunAction {
    public PhpRemoteDebugRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @Override
    @NotNull
    protected Settings createSettings() {
        Settings settings = new Settings();
        if (settings == null) {
            PhpRemoteDebugRunConfiguration.$$$reportNull$$$0(0);
        }
        return settings;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        PhpRemoteDebugRunConfigurationEditor phpRemoteDebugRunConfigurationEditor = new PhpRemoteDebugRunConfigurationEditor(this.getProject());
        if (phpRemoteDebugRunConfigurationEditor == null) {
            PhpRemoteDebugRunConfiguration.$$$reportNull$$$0(1);
        }
        return phpRemoteDebugRunConfigurationEditor;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PhpRemoteDebugRunConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            PhpRemoteDebugRunConfiguration.$$$reportNull$$$0(3);
        }
        try {
            this.checkConfiguration();
        }
        catch (RuntimeConfigurationWarning runtimeConfigurationWarning) {
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Settings settings = (Settings)this.getSettings();
        if (settings.isFilterEnabled()) {
            PhpRunUtil.checkServerConfigurationByServerName(this.getProject(), settings.getServerName());
            String sessionId = settings.getSessionId();
            if (StringUtil.isEmpty((String)sessionId)) {
                throw new RuntimeConfigurationError(PhpBundle.message("PhpRemoteDebugRunConfigurationEditor.session.id.cannot.be.empty", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/remoteDebug/PhpRemoteDebugRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Settings {
        private String myServerName = null;
        private String mySessionId = "";
        private FilterConnections myFilterState = FilterConnections.NOT_INITIALIZED;

        @Attribute(value="server_name")
        public String getServerName() {
            return this.myServerName;
        }

        public void setServerName(String serverName) {
            this.myServerName = serverName;
        }

        @Attribute(value="session_id")
        public String getSessionId() {
            return this.mySessionId;
        }

        public void setSessionId(String sessionId) {
            this.mySessionId = sessionId;
        }

        @Attribute(value="filter_connections")
        public FilterConnections getFilterState() {
            return this.myFilterState;
        }

        public void setFilterState(FilterConnections filterState) {
            this.myFilterState = filterState;
        }

        public boolean isFilterEnabled() {
            if (this.myFilterState == FilterConnections.FILTER) {
                return true;
            }
            return this.myFilterState == FilterConnections.NOT_INITIALIZED & StringUtil.isNotEmpty((String)this.getServerName());
        }
    }

    public static enum FilterConnections {
        NOT_INITIALIZED,
        FILTER,
        NOT_FILTER;

    }
}

