/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.util.PhpConfigurationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="local_configuration")
public class PhpTestFrameworkConfigurationIml
implements PhpTestFrameworkConfiguration {
    private static final String LOCAL = "Local";
    private PhpTestFrameworkType myFrameworkType;
    private boolean myUseConfigurationFile;
    @Nullable
    private String myExecutablePath;
    @Nullable
    private String myConfigurationFilePath;

    public PhpTestFrameworkConfigurationIml() {
        this.myUseConfigurationFile = false;
    }

    public PhpTestFrameworkConfigurationIml(@NotNull PhpTestFrameworkType frameworkType) {
        if (frameworkType == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(0);
        }
        this.myUseConfigurationFile = false;
        this.myFrameworkType = frameworkType;
    }

    @Override
    @NotNull
    public String getId() {
        if (LOCAL == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(1);
        }
        return LOCAL;
    }

    @Override
    @NotNull
    public String getPresentableName(@Nullable Project project) {
        String string = this.getId();
        if (string == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isLocal() {
        return LOCAL.equals(this.getId());
    }

    @Override
    @Transient
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @Transient
    @NotNull
    public PhpTestFrameworkType getFrameworkType() {
        PhpTestFrameworkType phpTestFrameworkType = this.myFrameworkType;
        if (phpTestFrameworkType == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(3);
        }
        return phpTestFrameworkType;
    }

    @Override
    public void setFrameworkType(@NotNull PhpTestFrameworkType type) {
        if (type == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(4);
        }
        this.myFrameworkType = type;
    }

    @Override
    @Transient
    @Nullable
    public String getExecutablePath() {
        return this.myExecutablePath;
    }

    @Override
    public void setExecutablePath(@Nullable String executable) {
        this.myExecutablePath = executable;
    }

    @Attribute(value="executable_path")
    @Nullable
    public String getSerializedExecutablePath() {
        return this.serialize(this.myExecutablePath);
    }

    public void setSerializedExecutablePath(@Nullable String path) {
        this.myExecutablePath = this.deserialize(path);
    }

    @Override
    @Attribute(value="use_configuration_file")
    public boolean isUseConfigurationFile() {
        return this.myUseConfigurationFile;
    }

    @Override
    public void setUseConfigurationFile(boolean useConfigurationFile) {
        this.myUseConfigurationFile = useConfigurationFile;
    }

    @Override
    @Transient
    @Nullable
    public String getConfigurationFilePath() {
        return this.myConfigurationFilePath;
    }

    @Override
    public void setConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = StringUtil.nullize((String)configurationFilePath);
    }

    @Attribute(value="configuration_file_path")
    @Nullable
    public String getSerializedConfigurationFilePath() {
        return this.serialize(this.myConfigurationFilePath);
    }

    public void setSerializedConfigurationFilePath(@Nullable String configurationFilePath) {
        this.myConfigurationFilePath = this.deserialize(configurationFilePath);
    }

    protected String serialize(@Nullable String path) {
        return PhpConfigurationUtil.serializePath(path);
    }

    protected String deserialize(@Nullable String path) {
        return PhpConfigurationUtil.deserializePath(path);
    }

    @Override
    @Nullable
    public PhpTestFrameworkConfiguration copyWithSettingsSource(@Nullable Project project) {
        return null;
    }

    @Override
    @NotNull
    public PhpTestFrameworkConfiguration copy() {
        PhpTestFrameworkConfigurationIml configuration = new PhpTestFrameworkConfigurationIml();
        this.copyTo(configuration);
        PhpTestFrameworkConfigurationIml phpTestFrameworkConfigurationIml = configuration;
        if (phpTestFrameworkConfigurationIml == null) {
            PhpTestFrameworkConfigurationIml.$$$reportNull$$$0(5);
        }
        return phpTestFrameworkConfigurationIml;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpTestFrameworkConfigurationIml configuration = (PhpTestFrameworkConfigurationIml)o;
        if (this.myUseConfigurationFile != configuration.myUseConfigurationFile) {
            return false;
        }
        if (this.myExecutablePath != null ? !this.myExecutablePath.equals(configuration.myExecutablePath) : configuration.myExecutablePath != null) {
            return false;
        }
        return !(this.myConfigurationFilePath != null ? !this.myConfigurationFilePath.equals(configuration.myConfigurationFilePath) : configuration.myConfigurationFilePath != null);
    }

    public int hashCode() {
        int result = this.myUseConfigurationFile ? 1 : 0;
        result = 31 * result + (this.myExecutablePath != null ? this.myExecutablePath.hashCode() : 0);
        result = 31 * result + (this.myConfigurationFilePath != null ? this.myConfigurationFilePath.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkConfigurationIml";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkConfigurationIml";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

