/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurationBaseManager<C extends QualityToolConfiguration>
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(QualityToolConfigurationBaseManager.class);
    private static final SerializationFilter myFilter = new SkipDefaultsSerializationFilter();
    private static final String ROOT = "root";
    private static final String MIGRATED = "_migrated";
    private List<C> mySettings = new ArrayList<C>();
    private boolean myMigrated = false;

    public List<C> initLocalAndGetSettings() {
        if (!ContainerUtil.exists(this.mySettings, config -> config != null && config.isLocal())) {
            this.initLocalSettings();
        }
        return this.mySettings;
    }

    public List<C> getSettings() {
        return this.mySettings;
    }

    public void setSettings(@NotNull List<C> settings) {
        if (settings == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
    }

    @NotNull
    protected C initLocalSettings() {
        C local = this.createLocalSettings();
        this.mySettings.add(local);
        C c = local;
        if (c == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(1);
        }
        return c;
    }

    @Nullable
    public Element getState() {
        Element root = new Element(ROOT);
        if (this.myMigrated) {
            root.addContent(new Element(this.getConfigurationRootName() + MIGRATED));
        }
        if (this.mySettings.isEmpty()) {
            return root;
        }
        Element element = null;
        for (QualityToolConfiguration configurations : this.mySettings) {
            Element settingElement = XmlSerializer.serializeIfNotDefault((Object)configurations, (SerializationFilter)myFilter);
            if (settingElement == null) continue;
            if (element == null) {
                element = new Element(this.getConfigurationRootName());
            }
            element.addContent(settingElement);
        }
        if (element != null) {
            root.addContent(element);
        }
        return root;
    }

    @Nullable
    private C load(@Nullable QualityToolConfigurationProvider<C> provider, @NotNull Element settingElement) {
        if (settingElement == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(2);
        }
        if (provider == null || !provider.canLoad(settingElement.getName())) {
            return null;
        }
        return provider.load(settingElement);
    }

    @NotNull
    protected abstract C createLocalSettings();

    public void loadState(@NotNull Element element) {
        if (element == null) {
            QualityToolConfigurationBaseManager.$$$reportNull$$$0(3);
        }
        this.myMigrated = element.getChild(this.getConfigurationRootName() + MIGRATED) != null;
        this.mySettings.clear();
        Element settings = element.getChild(this.getConfigurationRootName());
        if (settings == null) {
            C local = this.createLocalSettings();
            List options = element.getChildren("option");
            for (Element option : options) {
                Attribute name = option.getAttribute("name");
                Attribute value = option.getAttribute("value");
                if (name == null || value == null) continue;
                if ("maxMessagesPerFile".equals(name.getValue())) {
                    try {
                        local.setMaxMessagesPerFile(Integer.parseInt(value.getValue()));
                    }
                    catch (NumberFormatException e) {
                        LOG.warn(this.getQualityToolName() + " - Can not parse old-style local configuration: messages per file setting");
                    }
                    continue;
                }
                if (this.getOldStyleToolPathName().equals(name.getValue())) {
                    String valuePresentation = value.getValue();
                    if (!StringUtil.isNotEmpty((String)valuePresentation)) continue;
                    local.setToolPath(valuePresentation);
                    continue;
                }
                if (!"timeoutMs".equals(name.getValue())) continue;
                try {
                    local.setTimeout(Integer.parseInt(value.getValue()));
                }
                catch (NumberFormatException e) {
                    LOG.warn(this.getQualityToolName() + " - Can not parse old-style local configuration: timeout");
                }
            }
            this.mySettings.add(local);
        } else {
            boolean localIsLoaded = false;
            QualityToolConfigurationProvider<C> provider = this.getConfigurationProvider();
            for (Element settingElement : settings.getChildren()) {
                C configuration = this.load(provider, settingElement);
                if (configuration == null && !localIsLoaded) {
                    configuration = this.loadLocal(settingElement);
                    boolean bl = localIsLoaded = configuration != null;
                }
                if (configuration == null) continue;
                this.mySettings.add(configuration);
            }
        }
    }

    @NotNull
    protected abstract String getQualityToolName();

    @NotNull
    protected abstract String getOldStyleToolPathName();

    @NotNull
    protected abstract String getConfigurationRootName();

    @Nullable
    protected abstract QualityToolConfigurationProvider<C> getConfigurationProvider();

    @Nullable
    protected abstract C loadLocal(Element var1);

    public boolean migrated() {
        return this.myMigrated;
    }

    public void setMigrated(boolean migrated) {
        this.myMigrated = migrated;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurationBaseManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurationBaseManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initLocalSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

