/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.execution.ExecutionException;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.phpcs.PhpCSBlackList;
import com.jetbrains.php.tools.quality.phpcs.PhpCSCustomRulesSetupDialog;
import com.jetbrains.php.tools.quality.phpcs.PhpCSProjectConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import com.jetbrains.php.tools.quality.phpcs.PhpCSXmlMessageProcessor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSAnnotatorProxy
extends QualityToolAnnotator {
    private static final Logger LOG = Logger.getInstance(PhpCSAnnotatorProxy.class);
    private static final String TEMP_DIRECTORY = "phpcs_temp.tmp";
    public static final PhpCSAnnotatorProxy INSTANCE = new PhpCSAnnotatorProxy();

    @Override
    @Nullable
    protected QualityToolConfiguration getConfiguration(@NotNull Project project, @NotNull LocalInspectionTool inspection) {
        if (project == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(0);
        }
        if (inspection == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(1);
        }
        try {
            return PhpCSProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
        }
        catch (QualityToolValidationException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    @Override
    @NotNull
    protected String getTemporaryFilesFolder() {
        if (TEMP_DIRECTORY == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(2);
        }
        return TEMP_DIRECTORY;
    }

    @Override
    @NotNull
    protected String getInspectionId() {
        String string = new PhpCSValidationInspection().getID();
        if (string == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void runTool(@NotNull QualityToolMessageProcessor messageProcessor, @NotNull QualityToolAnnotatorInfo collectedInfo, @NotNull PhpSdkFileTransfer transfer) throws ExecutionException {
        if (messageProcessor == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(4);
        }
        if (collectedInfo == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(5);
        }
        if (transfer == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(6);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(collectedInfo.getFilePath());
        PhpCSValidationInspection inspection = (PhpCSValidationInspection)collectedInfo.getInspection();
        if (inspection.IGNORE_WARNINGS) {
            params.add("-n");
        }
        String workingDirectory = null;
        if (!inspection.CODING_STANDARD.isEmpty()) {
            String codingStandard = inspection.CODING_STANDARD;
            if ("Custom".equals(codingStandard)) {
                codingStandard = inspection.CUSTOM_RULESET_PATH;
                if (codingStandard == null || codingStandard.isEmpty()) {
                    messageProcessor.setFatalError();
                    return;
                }
                workingDirectory = PhpCSCustomRulesSetupDialog.isCodingStandardFile(codingStandard) ? PathUtil.getParentPath((String)codingStandard) : codingStandard;
            }
            params.add("--standard=" + codingStandard);
        }
        if (inspection.USE_INSTALLED_PATHS && !StringUtil.isEmpty((String)inspection.INSTALLED_PATHS)) {
            params.add("--runtime-set");
            params.add("installed_paths");
            params.add(inspection.INSTALLED_PATHS);
        }
        params.add("--encoding=utf-8");
        params.add("--report=xml");
        params.add(PhpCSAnnotatorProxy.getExtensions(inspection));
        messageProcessor.addSubstitution(collectedInfo.getFileName(), collectedInfo.getOriginalFileName());
        PhpCSBlackList blackList = PhpCSBlackList.getInstance(collectedInfo.getProject());
        QualityToolProcessCreator.runToolProcess(collectedInfo, blackList, messageProcessor, workingDirectory, transfer, params);
        if (messageProcessor.getInternalErrorMessage() != null) {
            if (collectedInfo.isOnTheFly()) {
                String message = messageProcessor.getInternalErrorMessage().getMessageText();
                PhpCSAnnotatorProxy.showProcessErrorMessage(collectedInfo, blackList, message);
                PhpCSAnnotatorProxy.logWarning(collectedInfo, message, null);
            }
            messageProcessor.setFatalError();
        }
    }

    private static String getExtensions(PhpCSValidationInspection inspection) {
        ArrayList<String> enabledExtensions = new ArrayList<String>();
        if (inspection.CHECK_PHP) {
            enabledExtensions.add("php");
        }
        if (inspection.CHECK_JS) {
            enabledExtensions.add("js");
        }
        if (inspection.CHECK_CSS) {
            enabledExtensions.add("css");
        }
        if (inspection.CHECK_INC) {
            enabledExtensions.add("inc");
        }
        return enabledExtensions.isEmpty() ? "" : "--extensions=" + StringUtil.join(enabledExtensions, (String)",");
    }

    @Override
    protected boolean isFileSuitable(@NotNull PsiFile file) {
        if (file == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(7);
        }
        return (file instanceof PhpFile && file.getViewProvider().getBaseLanguage() == PhpLanguage.INSTANCE || file instanceof CssFile && file.getLanguage() == CSSLanguage.INSTANCE || file.getLanguage().getBaseLanguage() == Language.findLanguageByID((String)"JavaScript")) && file.getContext() == null;
    }

    @Override
    protected QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo collectedInfo) {
        if (collectedInfo == null) {
            PhpCSAnnotatorProxy.$$$reportNull$$$0(8);
        }
        PhpCSValidationInspection inspection = (PhpCSValidationInspection)collectedInfo.getInspection();
        return new PhpCSXmlMessageProcessor(collectedInfo, collectedInfo.getMaxMessagesPerFile(), inspection.SHOW_SNIFF_NAMES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSAnnotatorProxy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transfer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSAnnotatorProxy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryFilesFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFileSuitable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMessageProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

