/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpTextFieldWithSdkBasedBrowse;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSCustomRulesSetupDialog;
import com.jetbrains.php.tools.quality.phpcs.PhpCSProjectConfiguration;
import com.jetbrains.php.tools.quality.phpcs.PhpCSValidationInspection;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.stream.IntStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSOptionsPanel {
    private static final Logger LOG = Logger.getInstance(PhpCSOptionsPanel.class);
    @NotNull
    private final Project myProject;
    private JPanel myOptionsPanel;
    private JCheckBox myShowWarningsBox;
    private JComboBox<String> myStandardCombo;
    private JButton myRefreshButton;
    private JButton mySetupCustomStandardButton;
    private JPanel myWarningsPanel;
    private JCheckBox myShowSniffNamesBox;
    private JCheckBox myUseInstalledPaths;
    private PhpTextFieldWithSdkBasedBrowse myInstalledPathsTextField;
    private JBCheckBox myPhpJBCheckBox;
    private JBCheckBox myIncJBCheckBox;
    private JBCheckBox myJsJBCheckBox;
    private JBCheckBox myCssJBCheckBox;
    private final PhpCSValidationInspection myInspection;
    private LevelChooserAction myWarningLevelChooser;

    public PhpCSOptionsPanel(PhpCSValidationInspection inspection, @NotNull Project project) {
        if (project == null) {
            PhpCSOptionsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myRefreshButton.addActionListener(e -> this.updateStandards());
        this.myInspection = inspection;
        this.myShowWarningsBox.setSelected(!this.myInspection.IGNORE_WARNINGS);
        this.myShowWarningsBox.addActionListener(e -> {
            this.myInspection.IGNORE_WARNINGS = !this.myShowWarningsBox.isSelected();
        });
        this.mySetupCustomStandardButton.addActionListener(e -> {
            if (this.checkCustomStandardEnabled()) {
                this.setupCustomRules();
            }
        });
        this.myUseInstalledPaths.setSelected(this.myInspection.USE_INSTALLED_PATHS);
        this.myUseInstalledPaths.addActionListener(e -> this.myInstalledPathsTextField.setEnabled(this.myUseInstalledPaths.isSelected()));
        this.myUseInstalledPaths.addActionListener(e -> {
            this.myInspection.USE_INSTALLED_PATHS = this.myUseInstalledPaths.isSelected();
        });
        this.myInstalledPathsTextField.setText(this.myInspection.INSTALLED_PATHS);
        this.myInstalledPathsTextField.setEnabled(this.myInspection.USE_INSTALLED_PATHS);
        this.myInstalledPathsTextField.init(project, PhpCSOptionsPanel.getSdkAdditionalData(project), PhpBundle.message("quality.tool.phpcs.installed.paths", new Object[0]), false, true);
        this.myInstalledPathsTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((PhpCSOptionsPanel)PhpCSOptionsPanel.this).myInspection.INSTALLED_PATHS = PhpCSOptionsPanel.this.myInstalledPathsTextField.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel$1", "textChanged"));
            }
        });
        this.mySetupCustomStandardButton.setText("");
        this.myShowSniffNamesBox.setSelected(this.myInspection.SHOW_SNIFF_NAMES);
        this.myShowSniffNamesBox.addActionListener(e -> {
            this.myInspection.SHOW_SNIFF_NAMES = this.myShowSniffNamesBox.isSelected();
        });
        this.myWarningLevelChooser.setChosen(this.myInspection.getWarningLevel().getSeverity());
        this.myPhpJBCheckBox.setSelected(this.myInspection.CHECK_PHP);
        this.myPhpJBCheckBox.addActionListener(e -> {
            this.myInspection.CHECK_PHP = this.myPhpJBCheckBox.isSelected();
        });
        this.myIncJBCheckBox.setSelected(this.myInspection.CHECK_INC);
        this.myIncJBCheckBox.addActionListener(e -> {
            this.myInspection.CHECK_INC = this.myIncJBCheckBox.isSelected();
        });
        this.myCssJBCheckBox.setSelected(this.myInspection.CHECK_CSS);
        this.myCssJBCheckBox.addActionListener(e -> {
            this.myInspection.CHECK_CSS = this.myCssJBCheckBox.isSelected();
        });
        this.myJsJBCheckBox.setSelected(this.myInspection.CHECK_JS);
        this.myJsJBCheckBox.addActionListener(e -> {
            this.myInspection.CHECK_JS = this.myJsJBCheckBox.isSelected();
        });
    }

    @Nullable
    private static PhpSdkAdditionalData getSdkAdditionalData(@NotNull Project project) {
        if (project == null) {
            PhpCSOptionsPanel.$$$reportNull$$$0(1);
        }
        try {
            PhpCSConfiguration configuration = (PhpCSConfiguration)PhpCSProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
            if (configuration == null || StringUtil.isEmpty((String)configuration.getInterpreterId())) {
                return null;
            }
            PhpInterpreter id = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(configuration.getInterpreterId());
            return id != null ? id.getPhpSdkAdditionalData() : null;
        }
        catch (QualityToolValidationException e) {
            return null;
        }
    }

    public void init() {
        try {
            PhpCSConfiguration configuration = (PhpCSConfiguration)PhpCSProjectConfiguration.getInstance(this.myProject).findSelectedConfiguration(this.myProject);
            if (configuration != null && PhpCSOptionsPanel.standardsMatch(this.myInspection.CODING_STANDARD, configuration.getStandards())) {
                this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(configuration.getStandards()));
                if (!this.myInspection.CODING_STANDARD.isEmpty()) {
                    this.myStandardCombo.setSelectedItem(this.myInspection.CODING_STANDARD);
                }
            } else {
                this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.myInspection.CODING_STANDARD}));
            }
        }
        catch (QualityToolValidationException e2) {
            this.myStandardCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.myInspection.CODING_STANDARD}));
        }
        this.myStandardCombo.addActionListener(e -> {
            Object selection = this.myStandardCombo.getSelectedItem();
            if (selection instanceof String) {
                this.myInspection.CODING_STANDARD = (String)selection;
            }
        });
    }

    private void updateStandards() {
        try {
            PhpCSConfiguration configuration = (PhpCSConfiguration)PhpCSProjectConfiguration.getInstance(this.myProject).findSelectedConfiguration(this.myProject);
            if (configuration == null) {
                PhpUiUtil.showBalloon(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Code Sniffer"), MessageType.ERROR, this.myStandardCombo);
                return;
            }
            Object[] installedStandards = PhpCSOptionsPanel.getInstalledStandards(this.myProject, configuration, this.getOptionsPanel(), this.myInspection.USE_INSTALLED_PATHS ? this.myInspection.INSTALLED_PATHS : null);
            if (installedStandards.length == 0) {
                PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.phpcs.can.not.retrieve.standards", new Object[0]), MessageType.ERROR, this.myStandardCombo);
                return;
            }
            installedStandards = (String[])ArrayUtil.append((Object[])installedStandards, (Object)"Custom");
            configuration.setStandards((String[])installedStandards);
            Object selection = this.myStandardCombo.getSelectedItem();
            String currentStandard = selection instanceof String ? (String)selection : "";
            this.myStandardCombo.setModel(new DefaultComboBoxModel<Object>(installedStandards));
            this.myStandardCombo.setSelectedItem(PhpCSOptionsPanel.standardsMatch(currentStandard, (String[])installedStandards) ? currentStandard : installedStandards[0]);
            PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.coding.stardards.has.been.updated", new Object[0]), MessageType.INFO, this.myStandardCombo);
        }
        catch (QualityToolValidationException e) {
            PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
        }
    }

    private void createUIComponents() {
        this.myRefreshButton = new FixedSizeButton();
        this.myRefreshButton.setIcon(PhpIcons.REFRESH);
        this.mySetupCustomStandardButton = new FixedSizeButton();
        this.myWarningsPanel = new JPanel();
        this.myWarningsPanel.setLayout(new BorderLayout());
        this.myWarningLevelChooser = new LevelChooserAction(InspectionProfileManager.getInstance().getSeverityRegistrar()){

            protected void onChosen(HighlightSeverity severity) {
                PhpCSOptionsPanel.this.myInspection.setWarningLevel(HighlightDisplayLevel.find((HighlightSeverity)severity));
            }
        };
        this.myWarningsPanel.add(this.myWarningLevelChooser.createCustomComponent(this.myWarningLevelChooser.getTemplatePresentation()));
    }

    private static boolean standardsMatch(String current, String[] collected) {
        return current == null || current.isEmpty() || Arrays.asList(collected).contains(current);
    }

    public JPanel getOptionsPanel() {
        return this.myOptionsPanel;
    }

    @NotNull
    static String[] getInstalledStandards(@Nullable Project project, @NotNull PhpCSConfiguration config, @Nullable JComponent component, @Nullable String installedPaths) {
        block8: {
            String[] stringArray;
            if (config == null) {
                PhpCSOptionsPanel.$$$reportNull$$$0(2);
            }
            String standardsPrefix = "The installed coding standards are";
            String title = "Getting Installed Standards...";
            try {
                String[] resultChunks;
                String[] stringArray2;
                if (installedPaths == null) {
                    String[] stringArray3 = new String[1];
                    stringArray2 = stringArray3;
                    stringArray3[0] = "-i";
                } else {
                    String[] stringArray4 = new String[4];
                    stringArray4[0] = "--runtime-set";
                    stringArray4[1] = "installed_paths";
                    stringArray4[2] = installedPaths;
                    stringArray2 = stringArray4;
                    stringArray4[3] = "-i";
                }
                String[] params = stringArray2;
                ProcessOutput output = QualityToolProcessCreator.getToolOutput(project != null ? project : ProjectManager.getInstance().getDefaultProject(), config.getInterpreterId(), config.getToolPath(), config.getTimeout(), "Getting Installed Standards...", component, params);
                String messageText = output.getStdout();
                if (!messageText.contains("The installed coding standards are")) break block8;
                messageText = messageText.replace("The installed coding standards are", "");
                TreeSet<String> standards = new TreeSet<String>();
                for (String resultChunk : resultChunks = messageText.split(",?\\s+")) {
                    String standardStr = resultChunk.trim();
                    if (standardStr.isEmpty() || "and".equals(standardStr)) continue;
                    standards.add(resultChunk.trim());
                }
                stringArray = ArrayUtil.toStringArray(standards);
            }
            catch (ExecutionException e) {
                LOG.warn("Failed getting installed standards for " + config.getToolPath(), (Throwable)e);
            }
            if (stringArray == null) {
                PhpCSOptionsPanel.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            PhpCSOptionsPanel.$$$reportNull$$$0(4);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private boolean checkCustomStandardEnabled() {
        boolean enabled = "Custom".equals(this.myInspection.CODING_STANDARD);
        if (!enabled) {
            PhpUiUtil.showBalloon(PhpBundle.message("quality.tool.phpcs.custom.rules.warning", new Object[0]), MessageType.ERROR, this.myStandardCombo);
        }
        return enabled;
    }

    private void setupCustomRules() {
        try {
            PhpCSConfiguration configuration = (PhpCSConfiguration)PhpCSProjectConfiguration.getInstance(this.myProject).findSelectedConfiguration(this.myProject);
            if (configuration == null) {
                PhpUiUtil.showBalloon(PhpBundle.message("validation.value.is.not.specified.or.invalid", "Code Sniffer"), MessageType.ERROR, this.myStandardCombo);
                return;
            }
            PhpInterpreter interpreter = StringUtil.isEmpty((String)configuration.getInterpreterId()) ? null : PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreterById(configuration.getInterpreterId());
            PhpCSCustomRulesSetupDialog dialog = new PhpCSCustomRulesSetupDialog(this.myProject, interpreter, this.myOptionsPanel, this.myInspection.CUSTOM_RULESET_PATH);
            if (dialog.showAndGet()) {
                this.myInspection.CUSTOM_RULESET_PATH = dialog.getCustomRulesPath();
                this.reselectCustomStandard();
            }
        }
        catch (QualityToolValidationException e) {
            PhpUiUtil.showBalloon(e.getMessage(), MessageType.ERROR, this.myStandardCombo);
        }
    }

    private void reselectCustomStandard() {
        this.myStandardCombo.setSelectedIndex(0);
        IntStream.range(0, this.myStandardCombo.getItemCount()).filter(i -> this.myStandardCombo.getItemAt(i).equals("Custom")).findFirst().ifPresent(this.myStandardCombo::setSelectedIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSOptionsPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledStandards";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledStandards";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        PhpTextFieldWithSdkBasedBrowse phpTextFieldWithSdkBasedBrowse;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Coding standard:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JButton jButton = this.mySetupCustomStandardButton;
        jButton.setText("...");
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, new Dimension(24, 24), new Dimension(24, 24)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myStandardCombo = jComboBox;
        ((Component)jComboBox).setEnabled(true);
        jPanel3.add(jComboBox, "Center");
        JButton jButton2 = this.myRefreshButton;
        jButton2.setText("");
        jPanel3.add((Component)jButton2, "East");
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myWarningsPanel;
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 1, 1, 4, 8, 2, 0, 3, null, null, null));
        this.myShowWarningsBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setHorizontalAlignment(2);
        jCheckBox3.setText("Show warning as:");
        jPanel4.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowSniffNamesBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show sniff name");
        jPanel4.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseInstalledPaths = jCheckBox = new JCheckBox();
        jCheckBox.setText("Installed standard paths: ");
        jPanel4.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInstalledPathsTextField = phpTextFieldWithSdkBasedBrowse = new PhpTextFieldWithSdkBasedBrowse();
        ((Component)((Object)phpTextFieldWithSdkBasedBrowse)).setEnabled(false);
        jPanel4.add((Component)((Object)phpTextFieldWithSdkBasedBrowse), new GridConstraints(3, 1, 1, 4, 0, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 8, 2, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setAlignmentY(0.5f);
        jLabel2.setText("Check files with extensions:");
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, null, null, null, 1));
        this.myPhpJBCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText(".php");
        jPanel7.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIncJBCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText(".inc");
        jPanel7.add((Component)jBCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJsJBCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText(".js");
        jPanel7.add((Component)jBCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCssJBCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText(".css");
        jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myOptionsPanel;
    }
}

