/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.presentation.DiagramState;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;

public class PhpUmlCategoryManager
extends AbstractDiagramNodeContentManager {
    private static final DiagramCategory FIELDS = new DiagramCategory("Fields", PhpIcons.FIELD);
    private static final DiagramCategory CONSTANTS = new DiagramCategory("Constants", PhpIcons.CONSTANT);
    private static final DiagramCategory CONSTRUCTORS = new DiagramCategory("Constructors", PhpIcons.CONSTRUCTOR);
    private static final DiagramCategory METHODS = new DiagramCategory("Methods", PhpIcons.METHOD);
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{FIELDS, CONSTANTS, CONSTRUCTORS, METHODS};

    public DiagramCategory[] getContentCategories() {
        return CATEGORIES;
    }

    public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
        if (FIELDS.equals((Object)category)) {
            return element instanceof Field && !((Field)element).isConstant();
        }
        if (CONSTANTS.equals((Object)category)) {
            return element instanceof Field && ((Field)element).isConstant();
        }
        if (CONSTRUCTORS.equals((Object)category)) {
            return element instanceof Method && PhpUmlCategoryManager.isConstructor((Method)element);
        }
        if (METHODS.equals((Object)category)) {
            return element instanceof Method && !PhpUmlCategoryManager.isConstructor((Method)element);
        }
        return false;
    }

    private static boolean isConstructor(Method method) {
        return "__construct".equalsIgnoreCase(method.getName());
    }
}

