/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.pathmapper;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemotePathMapper
extends PhpPathMapper {
    public static final List<PathMappingSettings.PathMapping> LOCAL_MAPPINGS = Collections.singletonList(new PathMappingSettings.PathMapping("/", "/"));
    final List<? extends PathMappingSettings.PathMapping> myMappings;

    public PhpRemotePathMapper(@NotNull List<? extends PathMappingSettings.PathMapping> mappings) {
        if (mappings == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(0);
        }
        this.myMappings = mappings;
    }

    public PhpRemotePathMapper(@NotNull PhpServer phpServer) {
        if (phpServer == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(1);
        }
        this(phpServer.isUsePathMappings() ? phpServer.getMappings() : LOCAL_MAPPINGS);
    }

    public PhpRemotePathMapper() {
        this(LOCAL_MAPPINGS);
    }

    @Override
    @Nullable
    public String getRemoteFilePath(@NotNull String localFileUrl) {
        String[] localFilePath;
        PathMappingSettings.PathMapping properMapping;
        if (localFileUrl == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(2);
        }
        if ((properMapping = this.findProperMappingForLocalPath(localFilePath = PhpRemotePathMapper.getPath(VirtualFileManager.extractPath((String)localFileUrl)))) != null) {
            return PhpRemotePathMapper.createRemoteFilePath(localFilePath, properMapping);
        }
        return null;
    }

    @Override
    @Nullable
    public String getLocalPath(@NotNull String remoteFileUrlOrPath) {
        String[] remoteFilePath;
        PathMappingSettings.PathMapping properMapping;
        if (remoteFileUrlOrPath == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(3);
        }
        if ((properMapping = this.findProperMappingForRemotePath(remoteFilePath = PhpRemotePathMapper.getPath(VirtualFileManager.extractPath((String)remoteFileUrlOrPath)))) != null) {
            return PhpRemotePathMapper.createLocalFilePath(remoteFilePath, properMapping);
        }
        return null;
    }

    @Override
    public VirtualFile getLocalFile(@NotNull String remoteFileUrlOrPath) {
        String[] remoteFilePath;
        PathMappingSettings.PathMapping properMapping;
        if (remoteFileUrlOrPath == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(4);
        }
        if ((properMapping = this.findProperMappingForRemotePath(remoteFilePath = PhpRemotePathMapper.getPath(VirtualFileManager.extractPath((String)remoteFileUrlOrPath)))) != null) {
            ArrayList<PathMappingSettings.PathMapping> properMappings = new ArrayList<PathMappingSettings.PathMapping>();
            for (PathMappingSettings.PathMapping pathMapping : this.myMappings) {
                if (!properMapping.getRemoteRoot().equals(pathMapping.getRemoteRoot())) continue;
                properMappings.add(pathMapping);
            }
            for (PathMappingSettings.PathMapping pathMapping : properMappings) {
                String localFilePath = PhpRemotePathMapper.createLocalFilePath(remoteFilePath, pathMapping);
                VirtualFile localFile = LocalFileSystem.getInstance().findFileByPath(localFilePath);
                if (localFile == null) {
                    localFile = PharFileSystem.getInstance().findFileByPath(localFilePath);
                }
                if (localFile == null) continue;
                return localFile;
            }
        }
        return null;
    }

    @NotNull
    private static String createRemoteFilePath(@NotNull String[] localFilePath, @NotNull PathMappingSettings.PathMapping properMapping) {
        if (localFilePath == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(5);
        }
        if (properMapping == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(6);
        }
        String[] prefix = PhpStringUtil.subtractFromBegin(localFilePath, PhpRemotePathMapper.getPath(properMapping.getLocalRoot()), false);
        String[] remotePath = ArrayUtil.mergeArrays((String[])PhpRemotePathMapper.getPath(properMapping.getRemoteRoot()), (String[])prefix);
        String string = PhpRemotePathMapper.createFilePath(remotePath);
        if (string == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String createLocalFilePath(@NotNull String[] remoteFilePath, @NotNull PathMappingSettings.PathMapping properMapping) {
        if (remoteFilePath == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(8);
        }
        if (properMapping == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(9);
        }
        String[] prefix = PhpStringUtil.subtractFromBegin(remoteFilePath, PhpRemotePathMapper.getPath(properMapping.getRemoteRoot()), false);
        String[] localPath = ArrayUtil.mergeArrays((String[])PhpRemotePathMapper.getPath(properMapping.getLocalRoot()), (String[])prefix);
        String string = PhpRemotePathMapper.createFilePath(localPath);
        if (string == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private PathMappingSettings.PathMapping findProperMappingForRemotePath(@NotNull String[] remoteFilePath) {
        if (remoteFilePath == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(11);
        }
        PathMappingSettings.PathMapping properMapping = null;
        for (PathMappingSettings.PathMapping pathMapping : this.myMappings) {
            String[] remotePath = PhpRemotePathMapper.getPath(pathMapping.getRemoteRoot());
            if (!PhpStringUtil.isPrefix(remoteFilePath, remotePath, false) || properMapping != null && PhpRemotePathMapper.getPath(properMapping.getRemoteRoot()).length >= remotePath.length) continue;
            properMapping = pathMapping;
        }
        return properMapping;
    }

    @Nullable
    private PathMappingSettings.PathMapping findProperMappingForLocalPath(@NotNull String[] localFilePath) {
        if (localFilePath == null) {
            PhpRemotePathMapper.$$$reportNull$$$0(12);
        }
        PathMappingSettings.PathMapping properMapping = null;
        for (PathMappingSettings.PathMapping pathMapping : this.myMappings) {
            String[] localPath = PhpRemotePathMapper.getPath(pathMapping.getLocalRoot());
            if (!PhpStringUtil.isPrefix(localFilePath, localPath, false) || properMapping != null && PhpRemotePathMapper.getPath(properMapping.getLocalRoot()).length >= localPath.length) continue;
            properMapping = pathMapping;
        }
        return properMapping;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpServer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFileUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileUrlOrPath";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFilePath";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properMapping";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/util/pathmapper/PhpRemotePathMapper";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/util/pathmapper/PhpRemotePathMapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteFilePath";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLocalFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findProperMappingForRemotePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findProperMappingForLocalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

