/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.apacheConfig.lexer.ApacheConfigTokenTypes;
import com.intellij.lang.apacheConfig.parser.ApacheConfigElementTypes;
import com.intellij.lang.apacheConfig.psi.ACArgument;
import com.intellij.lang.apacheConfig.psi.ACDirectiveBase;
import com.intellij.lang.apacheConfig.psi.ACElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ACSection
extends ACDirectiveBase {
    public ACSection(@NotNull ASTNode node) {
        if (node == null) {
            ACSection.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public TextRange getTextRange() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getTextRange() : this.getNode().getTextRange();
    }

    public int getTextOffset() {
        ASTNode nameNode = this.getNameNode();
        return nameNode != null ? nameNode.getTextRange().getStartOffset() : this.getNode().getTextRange().getStartOffset();
    }

    @Override
    protected ASTNode getNameNode() {
        ASTNode name;
        ASTNode header = this.getNode().findChildByType((IElementType)ApacheConfigElementTypes.SECTION_HEADER);
        if (header != null && (name = header.findChildByType(ApacheConfigTokenTypes.IDENTIFIER)) != null) {
            return name;
        }
        return null;
    }

    @Override
    public List<ACArgument> getArguments() {
        for (PsiElement e : this.getChildren()) {
            if (e.getNode().getElementType() != ApacheConfigElementTypes.SECTION_HEADER) continue;
            if (e instanceof ACElement) {
                return ((ACElement)e).getArguments();
            }
            return null;
        }
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "ACSection(" + this.getName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/apacheConfig/psi/ACSection", "<init>"));
    }
}

