/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.clt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DrushUtils {
    private static final Logger LOG = Logger.getInstance(DrushUtils.class);

    private DrushUtils() {
    }

    static List<FrameworkCommand> getFrameworkCommands(String drushPath, @NotNull ProgressIndicator pi) throws ExecutionException, FrameworkDescriptionProvider.FrameworkParseException {
        List<FrameworkCommand> commands;
        if (pi == null) {
            DrushUtils.$$$reportNull$$$0(0);
        }
        FrameworkDescription drushFramework = DrushUtils.getDrushFrameworkDescription(drushPath);
        ScriptRunnerUtil.ScriptOutput commandsOutput = DrushUtils.getCommandsDescription(drushPath);
        FrameworkUtils.checkProgress((ProgressIndicator)pi);
        String descriptiveOutput = commandsOutput.getDescriptiveOutput();
        try {
            commands = DrushUtils.parseCommandsJson(descriptiveOutput, drushFramework);
        }
        catch (JsonSyntaxException e) {
            LOG.warn(descriptiveOutput, (Throwable)e);
            throw new FrameworkDescriptionProvider.FrameworkParseException(DrushUtils.getDescriptionCommand(drushPath), descriptiveOutput, DrupalBundle.message("drush.failed.to.parse.output", new Object[0]));
        }
        if (commands.isEmpty()) {
            throw new FrameworkDescriptionProvider.FrameworkParseException(DrushUtils.getDescriptionCommand(drushPath), descriptiveOutput, DrupalBundle.message("drush.no.commands.found", new Object[0]));
        }
        return commands;
    }

    static List<FrameworkCommand> parseCommandsJson(String json, @NotNull FrameworkDescription framework) {
        JsonParser parser;
        JsonElement element;
        if (framework == null) {
            DrushUtils.$$$reportNull$$$0(1);
        }
        if (!((element = (parser = new JsonParser()).parse(json)) instanceof JsonObject)) {
            throw new JsonSyntaxException("Parsed element is not an object.");
        }
        JsonObject object = (JsonObject)element;
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        for (Map.Entry entry : object.entrySet()) {
            if (!(entry.getValue() instanceof JsonObject)) {
                LOG.warn("Description is not an object:\n" + ((JsonElement)entry.getValue()).toString());
                continue;
            }
            JsonObject sourceObject = (JsonObject)entry.getValue();
            JsonElement commandsObject = sourceObject.get("commands");
            String source = (String)entry.getKey();
            if (!(commandsObject instanceof JsonObject)) {
                throw new JsonSyntaxException("Commands element is not an object for" + source);
            }
            for (Map.Entry commandEntry : ((JsonObject)commandsObject).entrySet()) {
                if (!(commandEntry.getValue() instanceof JsonObject)) {
                    throw new JsonSyntaxException("Command element is not an object for" + source + "/" + (String)commandEntry.getKey());
                }
                result.addAll(DrushUtils.parseCommandDescription((String)commandEntry.getKey(), (JsonObject)commandEntry.getValue(), framework, source));
            }
        }
        return result;
    }

    @NotNull
    private static Collection<? extends FrameworkCommand> parseCommandDescription(String commandName, JsonObject commandJson, FrameworkDescription framework, String source) {
        JsonElement argumentsElement = commandJson.get("arguments");
        List<DrushParameter> drushParameters = DrushUtils.parseParameters(argumentsElement, commandName, commandJson, source);
        JsonElement aliasesElement = commandJson.get("aliases");
        List<String> aliases = DrushUtils.parseCommandAliases(aliasesElement, source, commandName);
        String description = "";
        JsonElement descriptionElement = commandJson.get("description");
        if (descriptionElement.isJsonPrimitive()) {
            description = descriptionElement.getAsString();
        }
        StringBuilder helpBuilder = new StringBuilder();
        helpBuilder.append("<html>");
        if (!description.isEmpty()) {
            helpBuilder.append(description).append("<br/>");
        }
        if (!drushParameters.isEmpty()) {
            helpBuilder.append("<table>\n<tr><td><strong>Arguments:</strong></td>");
            for (DrushParameter drushParameter : drushParameters) {
                helpBuilder.append("<tr>");
                helpBuilder.append("<td valign=\"baseline\">").append(drushParameter.getName()).append("</td></td>").append(drushParameter.getHelp()).append("</td>");
                helpBuilder.append("</tr>");
            }
            helpBuilder.append("</table><br/>\n");
        } else {
            helpBuilder.append("<br/>No arguments<br/>\n");
        }
        List<Pair<String, String>> options = DrushUtils.parseOptions(commandJson.get("options"), commandName, source);
        if (options.isEmpty()) {
            helpBuilder.append("<br/>No options<br/>\n");
        } else {
            helpBuilder.append("<table>\n<tr><td><strong>Options:</strong></td>");
            for (Pair<String, String> pair : options) {
                helpBuilder.append("<tr>");
                helpBuilder.append("<td valign=\"baseline\">").append((String)pair.getFirst()).append("</td></td>").append((String)pair.getSecond()).append("</td>");
                helpBuilder.append("</tr>");
            }
            helpBuilder.append("</table><br/>\n");
        }
        List<Pair<String, String>> list = DrushUtils.parseExamples(commandJson.get("examples"), commandName, source);
        if (!list.isEmpty()) {
            helpBuilder.append("<table>\n<tr><td><strong>Examples:</strong></td>");
            for (Pair<String, String> pair : list) {
                helpBuilder.append("<tr>");
                helpBuilder.append("<td valign=\"baseline\">").append((String)pair.getFirst()).append("</td></td>").append((String)pair.getSecond()).append("</td>");
                helpBuilder.append("</tr>");
            }
            helpBuilder.append("</table><br/>\n");
        }
        helpBuilder.append("</html>");
        String string = helpBuilder.toString();
        ArrayList<DrushParameter> arrayList = new ArrayList<DrushParameter>(drushParameters);
        if (aliases.isEmpty()) {
            List<FrameworkCommand> list2 = Collections.singletonList(new FrameworkCommand(commandName, arrayList, false, string, Collections.emptyList(), framework));
            if (list2 == null) {
                DrushUtils.$$$reportNull$$$0(2);
            }
            return list2;
        }
        ArrayList<FrameworkCommand> result = new ArrayList<FrameworkCommand>();
        result.add(new FrameworkCommand(commandName, arrayList, false, string, Collections.emptyList(), framework));
        for (String alias : aliases) {
            result.add(new FrameworkCommand(alias, arrayList, false, string, Collections.emptyList(), framework));
        }
        ArrayList<FrameworkCommand> arrayList2 = result;
        if (arrayList2 == null) {
            DrushUtils.$$$reportNull$$$0(3);
        }
        return arrayList2;
    }

    private static List<Pair<String, String>> parseExamples(JsonElement examplesElement, String commandName, String source) {
        if (examplesElement == null) {
            return Collections.emptyList();
        }
        if (examplesElement instanceof JsonArray) {
            ArrayList<Pair<String, String>> examples = new ArrayList<Pair<String, String>>();
            for (JsonElement entry : examplesElement.getAsJsonArray()) {
                if (entry.isJsonPrimitive()) {
                    examples.add((Pair<String, String>)Pair.create((Object)"", (Object)entry.getAsString()));
                    continue;
                }
                throw new JsonSyntaxException("Unexpected examples description element at " + entry + '/' + source + '/' + commandName + ":\n" + examplesElement.toString());
            }
            return examples;
        }
        if (examplesElement instanceof JsonObject) {
            JsonObject examplesObject = (JsonObject)examplesElement;
            ArrayList<Pair<String, String>> examples = new ArrayList<Pair<String, String>>();
            for (Map.Entry entry : examplesObject.entrySet()) {
                String exampleName = (String)entry.getKey();
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    examples.add((Pair<String, String>)Pair.create((Object)exampleName, (Object)((JsonElement)entry.getValue()).getAsString()));
                    continue;
                }
                throw new JsonSyntaxException("Unexpected examples description element at " + exampleName + '/' + source + '/' + commandName + ":\n" + examplesElement.toString());
            }
            return examples;
        }
        throw new JsonSyntaxException("Unexpected examples element at " + source + '/' + commandName + ":\n" + examplesElement.toString());
    }

    private static List<Pair<String, String>> parseOptions(JsonElement optionsElement, String commandName, String source) {
        if (optionsElement == null) {
            return Collections.emptyList();
        }
        if (optionsElement instanceof JsonArray && optionsElement.getAsJsonArray().size() == 0) {
            return Collections.emptyList();
        }
        if (optionsElement instanceof JsonObject) {
            JsonObject optionsObject = (JsonObject)optionsElement;
            ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
            for (Map.Entry entry : optionsObject.entrySet()) {
                String optionName = (String)entry.getKey();
                JsonElement optionDescription = (JsonElement)entry.getValue();
                if (optionDescription.isJsonPrimitive()) {
                    options.add((Pair<String, String>)Pair.create((Object)optionName, (Object)optionDescription.getAsString()));
                    continue;
                }
                if (optionDescription.isJsonObject()) {
                    JsonElement descriptionElement = optionDescription.getAsJsonObject().get("description");
                    if (descriptionElement != null && descriptionElement.isJsonPrimitive()) {
                        options.add((Pair<String, String>)Pair.create((Object)optionName, (Object)descriptionElement.getAsString()));
                        continue;
                    }
                    if (descriptionElement == null) continue;
                    throw new JsonSyntaxException("Unexpected options/description element at " + optionName + '/' + source + '/' + commandName + ":\n" + optionDescription.toString());
                }
                if (optionDescription.isJsonNull()) {
                    options.add((Pair<String, String>)Pair.create((Object)optionName, (Object)""));
                    continue;
                }
                throw new JsonSyntaxException("Unexpected options description element at " + optionName + '/' + source + '/' + commandName + ":\n" + optionDescription.toString());
            }
            return options;
        }
        throw new JsonSyntaxException("Unexpected options element at " + source + '/' + commandName + ":\n" + optionsElement.toString());
    }

    private static List<String> parseCommandAliases(JsonElement aliasesElement, String source, String commandName) {
        if (aliasesElement == null) {
            return Collections.emptyList();
        }
        if (aliasesElement instanceof JsonArray) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (JsonElement aliasElement : (JsonArray)aliasesElement) {
                if (aliasElement.isJsonPrimitive()) {
                    aliases.add(aliasElement.getAsString());
                    continue;
                }
                throw new JsonSyntaxException("Unexpected aliases element at " + source + '/' + commandName + ":\n" + aliasElement.toString());
            }
            return aliases;
        }
        throw new JsonSyntaxException("Unexpected aliases element at " + source + '/' + commandName + ":\n" + aliasesElement.toString());
    }

    private static List<DrushParameter> parseParameters(JsonElement argumentsElement, String commandName, JsonObject commandJson, String source) {
        ArrayList<DrushParameter> parameters = new ArrayList<DrushParameter>();
        if (argumentsElement instanceof JsonObject) {
            int requiredNumber;
            JsonElement requiredArgumentsElement = commandJson.get("required-arguments");
            Set argumentsEntrySet = ((JsonObject)argumentsElement).entrySet();
            if (requiredArgumentsElement == null) {
                requiredNumber = argumentsEntrySet.size();
            } else if (requiredArgumentsElement.isJsonPrimitive() && requiredArgumentsElement.getAsJsonPrimitive().isNumber()) {
                requiredNumber = requiredArgumentsElement.getAsNumber().intValue();
            } else if (requiredArgumentsElement.isJsonPrimitive() && requiredArgumentsElement.getAsJsonPrimitive().isBoolean()) {
                requiredNumber = requiredArgumentsElement.getAsBoolean() ? argumentsEntrySet.size() : 0;
            } else {
                throw new JsonSyntaxException("Unexpected required-arguments at " + source + "/" + commandName + ":\n" + argumentsElement.toString());
            }
            int parameterNumber = 0;
            for (Map.Entry argumentEntry : argumentsEntrySet) {
                JsonElement description;
                String parameterName = ((String)argumentEntry.getKey()).replaceAll(" ", "_");
                JsonElement value = (JsonElement)argumentEntry.getValue();
                JsonPrimitive descriptionPrimitive = null;
                if (value.isJsonPrimitive()) {
                    descriptionPrimitive = value.getAsJsonPrimitive();
                } else if (value.isJsonObject() && (description = value.getAsJsonObject().get("description")) != null && description.isJsonPrimitive()) {
                    descriptionPrimitive = description.getAsJsonPrimitive();
                }
                if (descriptionPrimitive == null) {
                    throw new JsonSyntaxException("Unexpected parameter description at " + source + "/" + commandName + "/" + parameterName + ":\n" + argumentEntry.toString());
                }
                String parameterDescription = descriptionPrimitive.getAsString();
                parameters.add(new DrushParameter(parameterName, parameterNumber < requiredNumber ? null : "null", parameterDescription));
                ++parameterNumber;
            }
        } else if (argumentsElement != null && !(argumentsElement instanceof JsonArray)) {
            throw new JsonSyntaxException("Unexpected arguments at " + source + "/" + commandName + ":\n" + argumentsElement.toString());
        }
        return parameters;
    }

    private static ScriptRunnerUtil.ScriptOutput getCommandsDescription(String drushPath) throws ExecutionException {
        return FrameworkUtils.executeCommandWithFullOutput((String[])DrushUtils.getDescriptionCommand(drushPath), null, (boolean)true, (boolean)false);
    }

    @NonNls
    private static String[] getDescriptionCommand(String drushPath) {
        return new String[]{drushPath, "help", "--format=json"};
    }

    @NonNls
    static FrameworkDescription getDrushFrameworkDescription(String drushPath) {
        if (drushPath.contains(" ")) {
            drushPath = "\"" + drushPath + "\"";
        }
        return new FrameworkDescription("Drush_" + FrameworkUtils.getCurrentFormattedDate(), drushPath, "drush", "", true, "ws.drush", null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/drupal/clt/DrushUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/drupal/clt/DrushUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCommandDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkCommands";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseCommandsJson";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DrushParameter
    extends FrameworkCommand.Parameter {
        private final String myHelp;

        private DrushParameter(@NotNull String name, @NonNls @Nullable String defaultValue, @Nullable String help) {
            if (name == null) {
                DrushParameter.$$$reportNull$$$0(0);
            }
            super(name, defaultValue);
            this.myHelp = help;
        }

        private String getHelp() {
            return this.myHelp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/drupal/clt/DrushUtils$DrushParameter", "<init>"));
        }
    }
}

