/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.instrumentation.JSR45Util;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

class SourceFilesCollector
extends ClassVisitor {
    private final List<String> sources = new ArrayList<String>(1);
    private final String className;

    SourceFilesCollector(int api, ClassVisitor cv, String className) {
        super(api, cv);
        this.className = className;
    }

    List<String> getSources() {
        return this.sources;
    }

    @Override
    public void visitSource(String source, String debug) {
        if (debug != null) {
            List<String> sourceFiles = JSR45Util.parseSourcePaths(debug);
            for (String sourceFile : sourceFiles) {
                if (this.sources.contains(sourceFile)) continue;
                this.sources.add(sourceFile);
            }
        } else {
            String sourceFile = JSR45Util.getClassPackageName(this.className).replace(".", "/") + source;
            if (!this.sources.contains(sourceFile)) {
                this.sources.add(sourceFile);
            }
        }
        super.visitSource(source, debug);
    }
}

