/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;

public class GherkinBlock
implements ASTBlock {
    private final ASTNode myNode;
    private final Indent myIndent;
    private final TextRange myTextRange;
    private final boolean myLeaf;
    private List<Block> myChildren = null;
    private static final TokenSet BLOCKS_TO_INDENT = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.FEATURE_HEADER, GherkinElementTypes.SCENARIO, GherkinElementTypes.SCENARIO_OUTLINE, GherkinElementTypes.STEP, GherkinElementTypes.TABLE, GherkinElementTypes.EXAMPLES_BLOCK});
    private static final TokenSet BLOCKS_TO_INDENT_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.GHERKIN_FILE, GherkinElementTypes.FEATURE, GherkinElementTypes.SCENARIO, GherkinElementTypes.SCENARIO_OUTLINE});
    private static final TokenSet READ_ONLY_BLOCKS = TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.PYSTRING, GherkinTokenTypes.COMMENT});

    public GherkinBlock(ASTNode node) {
        this(node, Indent.getAbsoluteNoneIndent());
    }

    public GherkinBlock(ASTNode node, Indent indent) {
        this(node, indent, node.getTextRange());
    }

    public GherkinBlock(ASTNode node, Indent indent, TextRange textRange) {
        this(node, indent, textRange, false);
    }

    public GherkinBlock(ASTNode node, Indent indent, TextRange textRange, boolean leaf) {
        this.myNode = node;
        this.myIndent = indent;
        this.myTextRange = textRange;
        this.myLeaf = leaf;
    }

    public ASTNode getNode() {
        return this.myNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            GherkinBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myLeaf) {
            List<Block> list = Collections.emptyList();
            if (list == null) {
                GherkinBlock.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (this.myChildren == null) {
            this.myChildren = this.buildChildren();
        }
        List<Block> list = this.myChildren;
        if (list == null) {
            GherkinBlock.$$$reportNull$$$0(2);
        }
        return list;
    }

    private List<Block> buildChildren() {
        ASTNode[] children = this.myNode.getChildren(null);
        if (children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Block> result = new ArrayList<Block>();
        for (ASTNode child : children) {
            ASTNode commentIndentElement;
            Indent indent;
            if (child.getElementType() == TokenType.WHITE_SPACE) continue;
            Indent indent2 = indent = BLOCKS_TO_INDENT.contains(child.getElementType()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            if (child.getElementType() == GherkinElementTypes.TABLE_CELL && child.getChildren(null).length == 0) continue;
            if (child.getElementType() == GherkinTokenTypes.COMMENT && (commentIndentElement = child.getTreePrev()) != null && (commentIndentElement.getText().contains("\n") || commentIndentElement.getTreePrev() == null)) {
                String whiteSpaceText = commentIndentElement.getText();
                int lineBreakIndex = whiteSpaceText.lastIndexOf("\n");
                indent = Indent.getSpaceIndent((int)(whiteSpaceText.length() - lineBreakIndex - 1));
            }
            result.add((Block)new GherkinBlock(child, indent));
        }
        return result;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    public Alignment getAlignment() {
        return null;
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        ASTNode tableNode;
        if (child2 == null) {
            GherkinBlock.$$$reportNull$$$0(3);
        }
        if (child1 == null) {
            return null;
        }
        ASTBlock block1 = (ASTBlock)child1;
        ASTBlock block2 = (ASTBlock)child2;
        IElementType elementType1 = block1.getNode().getElementType();
        IElementType elementType2 = block2.getNode().getElementType();
        if (READ_ONLY_BLOCKS.contains(elementType2)) {
            return Spacing.getReadOnlySpacing();
        }
        if (GherkinElementTypes.SCENARIOS.contains(elementType2) && elementType1 != GherkinTokenTypes.COMMENT) {
            return Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)true, (int)2);
        }
        if (elementType1 == GherkinTokenTypes.PIPE && elementType2 == GherkinElementTypes.TABLE_CELL) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if ((elementType1 == GherkinElementTypes.TABLE_CELL || elementType1 == GherkinTokenTypes.PIPE) && elementType2 == GherkinTokenTypes.PIPE && (tableNode = TreeUtil.findParent((ASTNode)block1.getNode(), (IElementType)GherkinElementTypes.TABLE)) != null) {
            int columnIndex = GherkinBlock.getTableCellColumnIndex(block1.getNode());
            int maxWidth = ((GherkinTable)tableNode.getPsi()).getColumnWidth(columnIndex);
            int spacingWidth = maxWidth - block1.getNode().getText().trim().length() + 1;
            if (elementType1 == GherkinTokenTypes.PIPE) {
                spacingWidth += 2;
            }
            return Spacing.createSpacing((int)spacingWidth, (int)spacingWidth, (int)0, (boolean)false, (int)0);
        }
        return null;
    }

    private static int getTableCellColumnIndex(ASTNode node) {
        int pipeCount = 0;
        while (node != null) {
            if (node.getElementType() == GherkinTokenTypes.PIPE) {
                ++pipeCount;
            }
            node = node.getTreePrev();
        }
        return pipeCount - 1;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent childIndent = BLOCKS_TO_INDENT_CHILDREN.contains(this.getNode().getElementType()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
        ChildAttributes childAttributes = new ChildAttributes(childIndent, null);
        if (childAttributes == null) {
            GherkinBlock.$$$reportNull$$$0(4);
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        if (GherkinElementTypes.SCENARIOS.contains(this.getNode().getElementType())) {
            return true;
        }
        if (this.getNode().getElementType() == GherkinElementTypes.FEATURE) {
            return this.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{GherkinElementTypes.FEATURE_HEADER, GherkinElementTypes.SCENARIO, GherkinElementTypes.SCENARIO_OUTLINE})).length == 0;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.myLeaf || this.getSubBlocks().size() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/psi/formatter/GherkinBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/formatter/GherkinBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

