/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileIndexingHandler
extends FrameworkIndexingHandler {
    private static final Key<Boolean> IS_TEST_FILE = Key.create((String)(JSFile.class.getSimpleName() + " isTestFile"));
    private static final FileAttribute IS_TEST_FILE_ATTRIBUTE = new FileAttribute("javascript.file.is.test", 1, true);

    public void processFile(@NotNull JSFile psiFile, @NotNull JSFileCachedData data) {
        VirtualFile file;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(0);
        }
        if (data == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(1);
        }
        if ((file = JsTestFileIndexingHandler.getLocalFileToProcess(psiFile)) != null) {
            JSTestFileType testFileType = JsTestFileIndexingHandler.getTestFileType(psiFile);
            JsTestFileIndexingHandler.setIsTestFile(file, testFileType != null);
            data.setTestFileType(testFileType);
        }
    }

    @Nullable
    private static VirtualFile getLocalFileToProcess(@NotNull JSFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(2);
        }
        if ((file = psiFile.getViewProvider().getVirtualFile()) instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)0x100000L)) {
            return null;
        }
        if (JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) {
            return null;
        }
        if (TypeScriptUtil.isDefinitionFile((VirtualFile)file)) {
            return null;
        }
        return file;
    }

    @Nullable
    private static JSTestFileType getTestFileType(@NotNull JSFile psiFile) {
        JasmineFileStructure jasmine;
        if (psiFile == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(3);
        }
        if (!(jasmine = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile)).isEmpty()) {
            return JSTestFileType.JASMINE;
        }
        QUnitFileStructure qunit = (QUnitFileStructure)QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!qunit.isEmpty()) {
            return JSTestFileType.QUNIT;
        }
        MochaTddFileStructure tdd = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!tdd.isEmpty()) {
            return JSTestFileType.TDD;
        }
        return null;
    }

    private static void setIsTestFile(@NotNull VirtualFile file, @Nullable Boolean isTestFile) {
        Boolean prevValue;
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(4);
        }
        if (!Objects.equals(prevValue = (Boolean)file.getUserData(IS_TEST_FILE), isTestFile)) {
            file.putUserData(IS_TEST_FILE, (Object)isTestFile);
            JsTestFileIndexingHandler.writeIsTestFileAttribute(file, isTestFile);
        }
    }

    public static boolean isTestFile(@NotNull VirtualFile file, @NotNull Project project) {
        JSFileCachedData data;
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(5);
        }
        if (project == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(6);
        }
        if (file.isDirectory() || !file.isValid()) {
            return false;
        }
        Boolean isTestFileCached = (Boolean)file.getUserData(IS_TEST_FILE);
        if (isTestFileCached != null) {
            return isTestFileCached;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            if (project == null) {
                JsTestFileIndexingHandler.$$$reportNull$$$0(14);
            }
            if (file == null) {
                JsTestFileIndexingHandler.$$$reportNull$$$0(15);
            }
            return PsiManager.getInstance((Project)project).findFile(file);
        });
        if (!(psiFile instanceof JSFile)) {
            return false;
        }
        Boolean isTestFileFromAttr = JsTestFileIndexingHandler.readIsTestFileAttribute(file);
        if (isTestFileFromAttr != null) {
            file.putUserData(IS_TEST_FILE, (Object)isTestFileFromAttr);
            return isTestFileFromAttr;
        }
        if (psiFile instanceof JSFileBaseImpl && (data = ((JSFileBaseImpl)psiFile).tryGetCachedData()) != null) {
            boolean isTestFile = data.getTestFileType() != null;
            JsTestFileIndexingHandler.setIsTestFile(file, isTestFile);
            return isTestFile;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Boolean readIsTestFileAttribute(@NotNull VirtualFile file) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(7);
        }
        try (DataInputStream inputStream = IS_TEST_FILE_ATTRIBUTE.readAttribute(file);){
            if (inputStream == null) return null;
            Boolean bl = inputStream.readBoolean();
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void writeIsTestFileAttribute(@NotNull VirtualFile file, @Nullable Boolean isTestFile) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(8);
        }
        try (DataOutputStream outputStream = IS_TEST_FILE_ATTRIBUTE.writeAttribute(file);){
            if (isTestFile != null) {
                outputStream.writeBoolean(isTestFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void processFile(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(9);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(10);
        }
        if (JsTestFileIndexingHandler.getLocalFileToProcess(file) == null) {
            return;
        }
        for (AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure> builder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            JsTestFileIndexingHandler.putTestFileStructure(file, indexBuilder, builder);
        }
    }

    public static Collection<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> getFileStructureBuilders() {
        return ContainerUtil.list((Object[])new AbstractTestFileStructureBuilder[]{JasmineFileStructureBuilder.getInstance(), QUnitFileStructureBuilder.getInstance(), MochaTddFileStructureBuilder.getInstance()});
    }

    public int getVersion() {
        return 11;
    }

    private static <T extends AbstractTestFileStructure> void putTestFileStructure(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder, @NotNull AbstractTestFileStructureBuilder<T> builder) {
        if (file == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(11);
        }
        if (indexBuilder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            JsTestFileIndexingHandler.$$$reportNull$$$0(13);
        }
        T testStructure = builder.buildTestFileStructure(file);
        indexBuilder.putAdditionalData(builder.KEY, testStructure);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexBuilder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testFramework/JsTestFileIndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalFileToProcess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setIsTestFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readIsTestFileAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "writeIsTestFileAttribute";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "putTestFileStructure";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isTestFile$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

