/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static Icon myIcon = null;
    private static Icon myDisabledIcon = null;
    private static Icon myWin10ComboDropTriangleIcon = null;
    private boolean mySmallVariant = true;
    private String myPopupTitle;

    public static Icon getArrowIcon(boolean enabled) {
        if (UIUtil.isUnderWin10LookAndFeel()) {
            if (myWin10ComboDropTriangleIcon == null) {
                myWin10ComboDropTriangleIcon = IconLoader.findLafIcon((String)"win10/comboDropTriangle", ComboBoxAction.class, (boolean)true);
            }
            return myWin10ComboDropTriangleIcon;
        }
        if (myIcon != AllIcons.General.ArrowDown) {
            myIcon = AllIcons.General.ArrowDown;
            myDisabledIcon = IconLoader.getDisabledIcon((Icon)myIcon);
        }
        return enabled ? myIcon : myDisabledIcon;
    }

    protected ComboBoxAction() {
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ComboBoxAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (!(frame instanceof IdeFrame)) {
            return;
        }
        ListPopup popup = this.createActionPopup(e.getDataContext(), ((IdeFrame)((Object)frame)).getComponent(), null);
        popup.showCenteredInCurrentWindow(project);
    }

    @NotNull
    private ListPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component, @Nullable Runnable disposeCallback) {
        if (context == null) {
            ComboBoxAction.$$$reportNull$$$0(1);
        }
        if (component == null) {
            ComboBoxAction.$$$reportNull$$$0(2);
        }
        DefaultActionGroup group = this.createPopupActionGroup(component, context);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)group, context, false, this.shouldShowDisabledActions(), false, disposeCallback, this.getMaxRows(), this.getPreselectCondition());
        popup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        ListPopup listPopup = popup;
        if (listPopup == null) {
            ComboBoxAction.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    @Override
    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        if (presentation == null) {
            ComboBoxAction.$$$reportNull$$$0(4);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        ComboBoxButton button = this.createComboBoxButton(presentation);
        panel.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insets((int)0, (int)3), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            ComboBoxAction.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    protected ComboBoxButton createComboBoxButton(Presentation presentation) {
        return new ComboBoxButton(presentation);
    }

    public boolean isSmallVariant() {
        return this.mySmallVariant;
    }

    public void setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
    }

    public void setPopupTitle(String popupTitle) {
        this.myPopupTitle = popupTitle;
    }

    protected boolean shouldShowDisabledActions() {
        return false;
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ComboBoxAction.$$$reportNull$$$0(6);
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(button);
        if (defaultActionGroup == null) {
            ComboBoxAction.$$$reportNull$$$0(7);
        }
        return defaultActionGroup;
    }

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ComboBoxButton
    extends JButton
    implements UserActivityProviderComponent {
        private final Presentation myPresentation;
        private boolean myForcePressed = false;
        private PropertyChangeListener myButtonSynchronizer;

        public ComboBoxButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setModel(new MyButtonModel());
            this.getModel().setEnabled(this.myPresentation.isEnabled());
            this.setVisible(presentation.isVisible());
            this.setHorizontalAlignment(2);
            this.setFocusable(ScreenReader.isActive());
            this.putClientProperty("styleCombo", ComboBoxAction.this);
            this.setMargin((Insets)JBUI.insets((int)0, (int)5, (int)0, (int)2));
            if (ComboBoxAction.this.isSmallVariant()) {
                this.setFont((Font)JBUI.Fonts.toolbarSmallComboBoxFont());
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        ComboBoxButton.this.doClick();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(MouseEventAdapter.convert((MouseEvent)e, (Component)e.getComponent(), (int)503, (long)e.getWhen(), (int)(e.getModifiers() | e.getModifiersEx()), (int)e.getX(), (int)e.getY()));
                }
            });
        }

        @Override
        protected void fireActionPerformed(ActionEvent event) {
            if (!this.myForcePressed) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.showPopup());
            }
        }

        @NotNull
        private Runnable setForcePressed() {
            this.myForcePressed = true;
            this.repaint();
            Runnable runnable = () -> {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myForcePressed = false;
                    this.repaint();
                }, ModalityState.any());
                this.repaint();
                this.fireStateChanged();
            };
            if (runnable == null) {
                ComboBoxButton.$$$reportNull$$$0(0);
            }
            return runnable;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myForcePressed || Registry.is((String)"ide.helptooltip.enabled") ? null : super.getToolTipText();
        }

        public void showPopup() {
            JBPopup popup = this.createPopup(this.setForcePressed());
            if (Registry.is((String)"ide.helptooltip.enabled")) {
                HelpTooltip.setMasterPopup(this, popup);
            }
            popup.showUnderneathOf(this);
        }

        protected JBPopup createPopup(Runnable onDispose) {
            return ComboBoxAction.this.createActionPopup(this.getDataContext(), this, onDispose);
        }

        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext(this);
        }

        @Override
        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = KeymapUtil.createTooltipText(description, ComboBoxAction.this);
            if (Registry.is((String)"ide.helptooltip.enabled") && StringUtil.isNotEmpty((String)tooltip)) {
                HelpTooltip.dispose(this);
                new HelpTooltip().setDescription(tooltip).setLocation(HelpTooltip.Alignment.BOTTOM).installOn(this);
            } else {
                this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
            }
        }

        @Override
        public boolean isOpaque() {
            return !ComboBoxAction.this.isSmallVariant();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension prefSize = super.getPreferredSize();
            int width = prefSize.width + (this.myPresentation != null && this.isArrowVisible(this.myPresentation) ? ComboBoxAction.getArrowIcon(this.isEnabled()).getIconWidth() : 0) + (StringUtil.isNotEmpty((String)this.getText()) ? this.getIconTextGap() : 0) + (UIUtil.isUnderWin10LookAndFeel() ? JBUI.scale((int)6) : 0);
            Dimension size = new Dimension(width, ComboBoxAction.this.isSmallVariant() ? JBUI.scale((int)24) : Math.max(JBUI.scale((int)24), prefSize.height));
            JBInsets.addTo((Dimension)size, (Insets)this.getMargin());
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
        }

        @Override
        public Font getFont() {
            return ComboBoxAction.this.isSmallVariant() ? UIUtil.getToolbarFont() : UIUtil.getLabelFont();
        }

        @Override
        protected Graphics getComponentGraphics(Graphics graphics) {
            return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isArrowVisible(this.myPresentation)) {
                return;
            }
            Icon icon = ComboBoxAction.getArrowIcon(this.isEnabled());
            int x = this.getWidth() - icon.getIconWidth() - this.getInsets().right - this.getMargin().right - (UIUtil.isUnderWin10LookAndFeel() ? JBUI.scale((int)3) : 0);
            icon.paintIcon(null, g, x, (this.getHeight() - icon.getIconHeight()) / 2);
        }

        protected boolean isArrowVisible(@NotNull Presentation presentation) {
            if (presentation == null) {
                ComboBoxButton.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin((Insets)JBUI.insets((int)0, (int)5, (int)0, (int)2));
            this.updateButtonSize();
        }

        protected void updateButtonSize() {
            this.invalidate();
            this.repaint();
            this.setSize(this.getPreferredSize());
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setForcePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isArrowVisible";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    ComboBoxButton.this.setText((String)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    ComboBoxButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    ComboBoxButton.this.setIcon((Icon)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    ComboBoxButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return ComboBoxButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return ComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

