/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

class MultiLoaderWrapper
extends ClassLoader {
    private final ClassLoader[] myDelegates;

    MultiLoaderWrapper(ClassLoader parentCl, ClassLoader[] delegates) {
        super(parentCl);
        this.myDelegates = delegates;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader delegate : this.myDelegates) {
            try {
                return Class.forName(name, false, delegate);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }
}

