/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.PersistentOrderRootType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OrderRootType {
    private final String myName;
    private static boolean ourExtensionsLoaded = false;
    public static final ExtensionPointName<OrderRootType> EP_NAME = ExtensionPointName.create((String)"com.intellij.orderRootType");
    protected static PersistentOrderRootType[] ourPersistentOrderRootTypes = new PersistentOrderRootType[0];
    public static final OrderRootType CLASSES = new PersistentOrderRootType("CLASSES", "classPath", null, "classPathEntry");
    public static final OrderRootType SOURCES = new PersistentOrderRootType("SOURCES", "sourcePath", null, "sourcePathEntry");
    public static final OrderRootType DOCUMENTATION = new DocumentationRootType();

    protected OrderRootType(String name) {
        this.myName = name;
    }

    public String name() {
        return this.myName;
    }

    public boolean skipWriteIfEmpty() {
        return false;
    }

    public static synchronized OrderRootType[] getAllTypes() {
        return OrderRootType.getAllPersistentTypes();
    }

    public static PersistentOrderRootType[] getAllPersistentTypes() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            EP_NAME.getExtensionList();
        }
        return ourPersistentOrderRootTypes;
    }

    public static List<PersistentOrderRootType> getSortedRootTypes() {
        ArrayList<PersistentOrderRootType> allTypes = new ArrayList<PersistentOrderRootType>();
        Collections.addAll(allTypes, OrderRootType.getAllPersistentTypes());
        Collections.sort(allTypes, (o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        return allTypes;
    }

    @NotNull
    protected static <T> T getOrderRootType(@NotNull Class<? extends T> orderRootTypeClass) {
        if (orderRootTypeClass == null) {
            OrderRootType.$$$reportNull$$$0(0);
        }
        List rootTypes = EP_NAME.getExtensionList();
        for (OrderRootType rootType : rootTypes) {
            OrderRootType t;
            if (!orderRootTypeClass.isInstance(rootType)) continue;
            OrderRootType orderRootType = t = rootType;
            if (orderRootType == null) {
                OrderRootType.$$$reportNull$$$0(1);
            }
            return (T)orderRootType;
        }
        assert (false) : "Root type " + orderRootTypeClass + " not found. All roots: " + rootTypes;
        if (null == null) {
            OrderRootType.$$$reportNull$$$0(2);
        }
        return null;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "Root " + this.name();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootTypeClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/OrderRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/OrderRootType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrderRootType";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DocumentationRootType
    extends OrderRootType {
        public DocumentationRootType() {
            super("DOCUMENTATION");
        }

        @Override
        public boolean skipWriteIfEmpty() {
            return true;
        }
    }
}

