/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromiseKt$sam$java_util_function_Function$0;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.InternalPromiseUtil;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0012\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u001f\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u000e\u0010&\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000#H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000#H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000!2\u000e\u0010)\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000!H\u0016J\u000e\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020,J\u0010\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020$H\u0016J\u0017\u0010-\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010/J,\u00100\u001a\b\u0012\u0004\u0012\u0002H10!\"\u0004\b\u0001\u001012\u0016\u00102\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H103H\u0016J0\u00104\u001a\b\u0012\u0004\u0012\u0002H10!\"\u0004\b\u0001\u001012\u001a\u00105\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H10!03H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/CancellablePromise;", "Lorg/jetbrains/concurrency/InternalPromiseUtil$CompletablePromise;", "()V", "w", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)V", "f", "blockingGet", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(ILjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "cancel", "", "", "mayInterruptIfRunning", "get", "()Ljava/lang/Object;", "", "unit", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getState", "Lorg/jetbrains/concurrency/Promise$State;", "isCancelled", "isDone", "nullizeCancelled", "value", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onError", "Lorg/jetbrains/concurrency/Promise;", "rejected", "Ljava/util/function/Consumer;", "", "onProcessed", "processed", "onSuccess", "handler", "child", "setError", "error", "", "setResult", "t", "(Ljava/lang/Object;)V", "then", "SUB_RESULT", "done", "Lcom/intellij/util/Function;", "thenAsync", "doneF", "intellij.platform.projectModel"})
public class AsyncPromise<T>
implements CancellablePromise<T>,
InternalPromiseUtil.CompletablePromise<T> {
    private final CompletableFuture<T> f;

    @Override
    public boolean isDone() {
        return this.f.isDone();
    }

    @Override
    @Nullable
    public T get() {
        return this.nullizeCancelled((Function0)new Function0<T>(this){
            final /* synthetic */ AsyncPromise this$0;

            public final T invoke() {
                return AsyncPromise.access$getF$p(this.this$0).get();
            }
            {
                this.this$0 = asyncPromise;
                super(0);
            }
        });
    }

    @Override
    @Nullable
    public T get(long timeout, @Nullable TimeUnit unit) {
        return this.nullizeCancelled((Function0)new Function0<T>(this, timeout, unit){
            final /* synthetic */ AsyncPromise this$0;
            final /* synthetic */ long $timeout;
            final /* synthetic */ TimeUnit $unit;

            public final T invoke() {
                return AsyncPromise.access$getF$p(this.this$0).get(this.$timeout, this.$unit);
            }
            {
                this.this$0 = asyncPromise;
                this.$timeout = l;
                this.$unit = timeUnit;
                super(0);
            }
        });
    }

    private final T nullizeCancelled(Function0<? extends T> value) {
        Object object;
        if (this.isCancelled()) {
            return null;
        }
        try {
            object = value.invoke();
        }
        catch (CancellationException e) {
            object = null;
        }
        return (T)object;
    }

    @Override
    public boolean isCancelled() {
        return this.f.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return !this.isCancelled() && this.f.cancel(mayInterruptIfRunning);
    }

    @Override
    public void cancel() {
        this.cancel(true);
    }

    @Override
    @NotNull
    public Promise.State getState() {
        return !this.f.isDone() ? Promise.State.PENDING : (this.f.isCompletedExceptionally() ? Promise.State.REJECTED : Promise.State.SUCCEEDED);
    }

    @Override
    @NotNull
    public Promise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        CompletionStage whenComplete2;
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        CompletionStage completionStage = whenComplete2 = this.f.whenComplete(new BiConsumer<T, Throwable>(handler){
            final /* synthetic */ Consumer $handler;

            public final void accept(T value, Throwable exception) {
                block3: {
                    if (exception == null && !InternalPromiseUtil.isHandlerObsolete(this.$handler)) {
                        try {
                            this.$handler.accept(value);
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) break block3;
                            Logger logger = Logger.getInstance(AsyncPromise.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
                            logger.error(e);
                        }
                    }
                }
            }
            {
                this.$handler = consumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"whenComplete");
        return new AsyncPromise<T>(completionStage);
    }

    @Override
    @NotNull
    public Promise<T> onError(@NotNull Consumer<Throwable> rejected2) {
        CompletionStage whenComplete2;
        Intrinsics.checkParameterIsNotNull(rejected2, (String)"rejected");
        CompletionStage completionStage = whenComplete2 = this.f.whenComplete(new BiConsumer<T, Throwable>(rejected2){
            final /* synthetic */ Consumer $rejected;

            public final void accept(T $noName_0, Throwable exception) {
                if (exception != null) {
                    Throwable toReport;
                    Throwable throwable;
                    if (exception instanceof CompletionException && exception.getCause() != null) {
                        throwable = exception.getCause();
                        if (throwable == null) {
                            Intrinsics.throwNpe();
                        }
                    } else {
                        throwable = toReport = exception;
                    }
                    if (!InternalPromiseUtil.isHandlerObsolete(this.$rejected)) {
                        this.$rejected.accept(toReport);
                    }
                }
            }
            {
                this.$rejected = consumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"whenComplete");
        return new AsyncPromise<T>(completionStage);
    }

    @Override
    @NotNull
    public Promise<T> onProcessed(@NotNull Consumer<? super T> processed2) {
        CompletionStage whenComplete2;
        Intrinsics.checkParameterIsNotNull(processed2, (String)"processed");
        CompletionStage completionStage = whenComplete2 = this.f.whenComplete(new BiConsumer<T, Throwable>(processed2){
            final /* synthetic */ Consumer $processed;

            public final void accept(T value, Throwable $noName_1) {
                if (!InternalPromiseUtil.isHandlerObsolete(this.$processed)) {
                    this.$processed.accept(value);
                }
            }
            {
                this.$processed = consumer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"whenComplete");
        return new AsyncPromise<T>(completionStage);
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            return this.get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            ExceptionUtil.rethrowUnchecked((Throwable)e.getCause());
            throw (Throwable)e;
        }
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        CompletionStage thenApply2;
        Intrinsics.checkParameterIsNotNull(done2, (String)"done");
        CompletionStage completionStage = thenApply2 = this.f.thenApply(new java.util.function.Function<T, U>(done2){
            final /* synthetic */ Function $done;

            public final SUB_RESULT apply(T t) {
                return (SUB_RESULT)this.$done.fun(t);
            }
            {
                this.$done = function;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"thenApply");
        return new AsyncPromise<T>(completionStage);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> doneF) {
        CompletionStage thenCompose;
        Function1 convert2;
        Intrinsics.checkParameterIsNotNull(doneF, (String)"doneF");
        Function1 function1 = convert2 = (Function1)new Function1<T, CompletableFuture<SUB_RESULT>>(doneF){
            final /* synthetic */ Function $doneF;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final CompletableFuture<SUB_RESULT> invoke(T it) {
                void var3_3;
                Promise promise = (Promise)this.$doneF.fun(it);
                CompletableFuture<T> future = new CompletableFuture<T>();
                promise.onSuccess((Consumer)new Consumer<SUB_RESULT>(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(SUB_RESULT value) {
                        this.$future.complete(value);
                    }
                    {
                        this.$future = completableFuture;
                    }
                }).onError(new Consumer<Throwable>(future){
                    final /* synthetic */ CompletableFuture $future;

                    public final void accept(Throwable error) {
                        this.$future.completeExceptionally(error);
                    }
                    {
                        this.$future = completableFuture;
                    }
                });
                return var3_3;
            }
            {
                this.$doneF = function;
                super(1);
            }
        };
        CompletionStage completionStage = thenCompose = this.f.thenCompose((java.util.function.Function)new AsyncPromiseKt$sam$java_util_function_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"thenCompose");
        return new AsyncPromise<T>(completionStage);
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        if (!(child instanceof AsyncPromise)) {
            return this;
        }
        Promise<T> promise = this.onSuccess(new Consumer<T>(child){
            final /* synthetic */ Promise $child;

            public final void accept(T value) {
                ((AsyncPromise)this.$child).setResult(value);
            }
            {
                this.$child = promise;
            }
        }).onError(new Consumer<Throwable>(child){
            final /* synthetic */ Promise $child;

            public final void accept(Throwable error) {
                AsyncPromise asyncPromise = (AsyncPromise)this.$child;
                Throwable throwable = error;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"error");
                asyncPromise.setError(throwable);
            }
            {
                this.$child = promise;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(promise, (String)"onSuccess { value -> chi\u2026> child.setError(error) }");
        return promise;
    }

    @Override
    public void setResult(@Nullable T t) {
        this.f.complete(t);
    }

    @Override
    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return this.f.completeExceptionally(error);
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        return this.setError(Promises.createError$default(error, false, 2, null));
    }

    public AsyncPromise() {
        this.f = new CompletableFuture();
    }

    private AsyncPromise(CompletableFuture<T> w) {
        this.f = w;
    }

    @NotNull
    public static final /* synthetic */ CompletableFuture access$getF$p(AsyncPromise $this) {
        return $this.f;
    }
}

