/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.intellij.plugins.xpathView.HistoryElement;
import org.intellij.plugins.xpathView.ui.MultilineEditor;
import org.jetbrains.annotations.Nullable;

class HistoryModel
extends AbstractListModel
implements ComboBoxModel,
MultilineEditor.EditorModel {
    private final HistoryElement[] history;
    private final Document myDocument;
    private final int length;
    private HistoryElement selectedItem;

    HistoryModel(HistoryElement[] history, Document document) {
        this.history = history;
        this.myDocument = document;
        if (history.length > 0) {
            this.setSelectedItem(history[history.length - 1]);
        }
        this.length = history.length;
    }

    public HistoryElement getElementAt(int i) {
        return this.history[this.length - 1 - i];
    }

    @Override
    public int getSize() {
        return this.length;
    }

    @Override
    @Nullable
    public HistoryElement getSelectedItem() {
        if (this.selectedItem != null) {
            if (Comparing.equal((CharSequence)this.selectedItem.expression, (CharSequence)this.myDocument.getCharsSequence())) {
                return this.selectedItem;
            }
            return this.selectedItem.changeExpression(this.myDocument.getText().trim());
        }
        assert (this.length == 0);
        return this.selectedItem;
    }

    @Override
    public void setSelectedIndex(int index) {
        this.setSelectedItem(this.getElementAt(index));
    }

    @Override
    public int getSelectedIndex() {
        int i = this.indexOf(this.selectedItem);
        return this.history.length - 1 - i;
    }

    private int indexOf(HistoryElement selectedItem) {
        return Arrays.asList(this.history).indexOf(selectedItem);
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object instanceof String) {
            for (HistoryElement element : this.history) {
                if (!object.equals(element.expression)) continue;
                object = element;
                break;
            }
        }
        if (object instanceof String) {
            object = this.selectedItem.changeExpression((String)object);
        }
        if (this.selectedItem != null && this.selectedItem != object || this.selectedItem == null && object != null) {
            this.selectedItem = (HistoryElement)object;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public String getItemString(int i) {
        return i > this.history.length ? this.getElementAt((int)i).expression : this.selectedItem.expression;
    }
}

