/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.PhpLanguage;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeInjectInjectionInfo
extends BladeInjectionInfo {
    private static final String MY_MIDDLE_PART = " = app('";
    private static final Key<CachedValue<InjectionDescription>> INJECTION_DESCRIPTION = Key.create((String)"BLADE_INJECT_INJECTION_DESCRIPTION");
    public static final int BLADE_PREFIX_LENGTH = "(".length();

    public BladeInjectInjectionInfo() {
        super("<?php $", "'); ?>", BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
    }

    @Override
    public int getBladePrefixLength() {
        return BLADE_PREFIX_LENGTH;
    }

    @Override
    public int getBladeSuffixLength() {
        return ")".length();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return "(\"" + this.getPhpPrefix() + "\", \"" + MY_MIDDLE_PART + "\", \"" + this.getPhpSuffix() + "\")";
    }

    @Override
    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladePsiLanguageInjectionHost host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        return BladeInjectInjectionInfo.doConvertInjectedRangeToInnerVisible(BladeInjectInjectionInfo.getInjectionDescription(host), this.getPhpPrefix(), MY_MIDDLE_PART, this.getPhpSuffix(), injected, length, showEmptyBorderIntersections);
    }

    @Nullable
    static TextRange doConvertInjectedRangeToInnerVisible(@NotNull InjectionDescription description, @NotNull String phpPrefix, @NotNull String middlePart, @NotNull String phpSuffix, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        TextRange intersection;
        if (description == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpPrefix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(1);
        }
        if (middlePart == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(2);
        }
        if (phpSuffix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(3);
        }
        if (injected.getEndOffset() < phpPrefix.length() || injected.getStartOffset() > length - phpSuffix.length()) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != phpPrefix.length() && injected.getStartOffset() != length - phpSuffix.length())) {
            return null;
        }
        int injectedOffset = phpPrefix.length();
        for (TextRange range : description.getFirstPartRanges()) {
            intersection = BladeInjectInjectionInfo.findIntersection(injected, showEmptyBorderIntersections, injectedOffset, range);
            if (intersection != null) {
                return intersection;
            }
            injectedOffset += range.getLength();
        }
        if (injected.getEndOffset() < (injectedOffset += middlePart.length())) {
            return null;
        }
        if (!showEmptyBorderIntersections && injected.getEndOffset() == injectedOffset) {
            return null;
        }
        for (TextRange range : description.getSecondPartRanges()) {
            intersection = BladeInjectInjectionInfo.findIntersection(injected, showEmptyBorderIntersections, injectedOffset, range);
            if (intersection != null) {
                return intersection;
            }
            injectedOffset += range.getLength();
        }
        return null;
    }

    @Nullable
    private static TextRange findIntersection(TextRange injected, boolean showEmptyBorderIntersections, int injectedOffset, TextRange range) {
        if (showEmptyBorderIntersections && injectedOffset + range.getLength() == injected.getStartOffset()) {
            return new TextRange(range.getEndOffset(), range.getEndOffset());
        }
        if (injectedOffset + range.getLength() > injected.getStartOffset()) {
            return new TextRange(range.getStartOffset() + injected.getStartOffset() - injectedOffset, Math.min(range.getEndOffset(), range.getStartOffset() + injected.getEndOffset() - injectedOffset));
        }
        return null;
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars, @NotNull BladePsiLanguageInjectionHost host) {
        if (rangeInsideHost == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(4);
        }
        if (outChars == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(5);
        }
        if (host == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(6);
        }
        return BladeInjectInjectionInfo.doDecode(BladeInjectInjectionInfo.getInjectionDescription(host), this.getBladePrefixLength(), rangeInsideHost, outChars, host);
    }

    static boolean doDecode(@NotNull InjectionDescription injectionDescription, int bladePrefixLength, @NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars, @NotNull BladePsiLanguageInjectionHost host) {
        if (injectionDescription == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(7);
        }
        if (rangeInsideHost == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(9);
        }
        if (host == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(10);
        }
        if (rangeInsideHost.getStartOffset() < bladePrefixLength) {
            return false;
        }
        TextRange intersection = injectionDescription.intersect(rangeInsideHost);
        if (intersection != null) {
            outChars.append(intersection.subSequence((CharSequence)host.getText()));
        }
        return rangeInsideHost.equals((Object)intersection);
    }

    @Override
    public void handleContentChange(@NotNull LeafElement content, @NotNull TextRange changeRange, String newContent) {
        if (content == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(11);
        }
        if (changeRange == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(12);
        }
        super.handleContentChange(content, changeRange, newContent);
    }

    @Override
    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child) {
        InjectionDescription description = BladeInjectInjectionInfo.getInjectionDescription(host);
        BladeInjectInjectionInfo.doRegister(description, this.getPhpPrefix(), MY_MIDDLE_PART, this.getPhpSuffix(), registrar, host);
    }

    static void doRegister(@NotNull InjectionDescription description, @NotNull String phpPrefix, @NotNull String middlePart, @NotNull String phpSuffix, MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host) {
        TextRange range;
        int i;
        if (description == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(13);
        }
        if (phpPrefix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(14);
        }
        if (middlePart == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(15);
        }
        if (phpSuffix == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(16);
        }
        List<TextRange> firstPartRanges = description.getFirstPartRanges();
        List<TextRange> secondPartRanges = description.getSecondPartRanges();
        if (firstPartRanges.isEmpty() && secondPartRanges.isEmpty()) {
            return;
        }
        registrar.startInjecting((Language)PhpLanguage.INSTANCE);
        if (!firstPartRanges.isEmpty()) {
            for (i = 0; i < firstPartRanges.size(); ++i) {
                range = firstPartRanges.get(i);
                String suffix = null;
                if (i == firstPartRanges.size() - 1) {
                    suffix = middlePart;
                    if (secondPartRanges.isEmpty()) {
                        suffix = suffix + phpSuffix;
                    }
                }
                registrar.addPlace(i == 0 ? phpPrefix : null, suffix, (PsiLanguageInjectionHost)host, range);
            }
        }
        if (!secondPartRanges.isEmpty()) {
            for (i = 0; i < secondPartRanges.size(); ++i) {
                range = secondPartRanges.get(i);
                registrar.addPlace(i == 0 && firstPartRanges.isEmpty() ? phpPrefix + MY_MIDDLE_PART : null, i == secondPartRanges.size() - 1 ? phpSuffix : null, (PsiLanguageInjectionHost)host, range);
            }
        }
        registrar.doneInjecting();
    }

    @NotNull
    private static InjectionDescription getInjectionDescription(@NotNull BladePsiLanguageInjectionHost host) {
        if (host == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(17);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)host.getProject());
        InjectionDescription injectionDescription = (InjectionDescription)cachedValuesManager.getCachedValue((UserDataHolder)host, INJECTION_DESCRIPTION, () -> {
            if (host == null) {
                BladeInjectInjectionInfo.$$$reportNull$$$0(21);
            }
            return CachedValueProvider.Result.create((Object)BladeInjectInjectionInfo.createInjectionDescription(host), (Object[])new Object[]{host});
        }, false);
        if (injectionDescription == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(18);
        }
        return injectionDescription;
    }

    private static InjectionDescription createInjectionDescription(@NotNull BladePsiLanguageInjectionHost host) {
        if (host == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(19);
        }
        return BladeInjectInjectionInfo.createFromText(host.getText());
    }

    public static InjectionDescription createFromText(@NotNull String text) {
        if (text == null) {
            BladeInjectInjectionInfo.$$$reportNull$$$0(20);
        }
        return new MyInjectionDescription(text);
    }

    private static boolean shouldIgnore(char c) {
        return c == '(' || c == ')' || c == '\'' || c == '\"';
    }

    @Override
    @NonNls
    public String toString() {
        return "BIInfo{prefix='" + this.getPhpPrefix() + '\'' + ", middlePart='" + MY_MIDDLE_PART + "', suffix='" + this.getPhpSuffix() + "\\}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPrefix";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "middlePart";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpSuffix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 6: 
            case 10: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionDescription";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRange";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectInjectionInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectInjectionInfo";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doConvertInjectedRangeToInnerVisible";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doDecode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRegister";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionDescription";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInjectionDescription";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFromText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInjectionDescription$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyInjectionDescription
    implements InjectionDescription {
        @NotNull
        private final SmartList<TextRange> firstPartRanges = new SmartList();
        @NotNull
        private final SmartList<TextRange> secondPartRanges = new SmartList();

        private MyInjectionDescription(String text) {
            int firstComma = text.indexOf(44);
            int secondComma = firstComma == -1 ? -1 : text.indexOf(44, firstComma + 1);
            MyInjectionDescription.createRanges(this.firstPartRanges, text, 0, firstComma == -1 ? text.length() : firstComma);
            if (firstComma != -1) {
                MyInjectionDescription.createRanges(this.secondPartRanges, text, firstComma + 1, secondComma == -1 ? text.length() : secondComma);
            }
        }

        @Override
        @NotNull
        public List<TextRange> getFirstPartRanges() {
            SmartList<TextRange> smartList = this.firstPartRanges;
            if (smartList == null) {
                MyInjectionDescription.$$$reportNull$$$0(0);
            }
            return smartList;
        }

        @Override
        @NotNull
        public List<TextRange> getSecondPartRanges() {
            SmartList<TextRange> smartList = this.secondPartRanges;
            if (smartList == null) {
                MyInjectionDescription.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private static void createRanges(SmartList<TextRange> ranges, String text, int startOffset, int endOffset) {
            int index;
            int currentRangeIndex = -1;
            for (index = startOffset; index < endOffset; ++index) {
                char c = text.charAt(index);
                if (BladeInjectInjectionInfo.shouldIgnore(c)) {
                    MyInjectionDescription.tryCloseRange(ranges, currentRangeIndex, index);
                    currentRangeIndex = -1;
                    continue;
                }
                if (currentRangeIndex != -1) continue;
                currentRangeIndex = index;
            }
            MyInjectionDescription.tryCloseRange(ranges, currentRangeIndex, index);
        }

        private static void tryCloseRange(SmartList<TextRange> result, int currentRangeIndex, int index) {
            if (currentRangeIndex == -1) {
                return;
            }
            result.add((Object)new TextRange(currentRangeIndex, index));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/blade/injection/BladeInjectInjectionInfo$MyInjectionDescription";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirstPartRanges";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecondPartRanges";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface InjectionDescription {
        @NotNull
        public List<TextRange> getFirstPartRanges();

        @NotNull
        public List<TextRange> getSecondPartRanges();

        @Nullable
        default public TextRange intersect(TextRange rangeToIntersect) {
            TextRange range = this.getIntersectingRange(rangeToIntersect);
            return range == null ? null : range.intersection(rangeToIntersect);
        }

        @Nullable
        default public TextRange getIntersectingRange(TextRange rangeToIntersect) {
            for (TextRange range : this.getFirstPartRanges()) {
                if (!rangeToIntersect.intersects(range)) continue;
                return range;
            }
            for (TextRange range : this.getSecondPartRanges()) {
                if (!rangeToIntersect.intersects(range)) continue;
                return range;
            }
            return null;
        }
    }
}

