/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.ConfigurableFactory;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModelListener;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.group.CodeStyleGroupProvider;
import com.intellij.application.options.codeStyle.group.CodeStyleGroupProviderFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesConfigurable
extends SearchableConfigurable.Parent.Abstract
implements OptionsContainingConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel {
    private CodeStyleSchemesPanel myRootSchemesPanel;
    @NotNull
    private final CodeStyleSchemesModel myModel;
    private List<Configurable> myPanels;
    private boolean myResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertCompleted = false;
    private final Project myProject;

    public CodeStyleSchemesConfigurable(Project project) {
        this.myProject = project;
        this.myModel = new CodeStyleSchemesModel(project);
    }

    public JComponent createComponent() {
        this.initSchemesPanel(this.myModel);
        return this.myPanels == null || this.myPanels.isEmpty() ? null : this.myPanels.get(0).createComponent();
    }

    private void initSchemesPanel(final @NotNull CodeStyleSchemesModel model) {
        if (model == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(0);
        }
        this.myRootSchemesPanel = new CodeStyleSchemesPanel(model, 0);
        model.addListener(new CodeStyleSchemesModelListener(){

            @Override
            public void currentSchemeChanged(Object source) {
                if (source != CodeStyleSchemesConfigurable.this.myRootSchemesPanel) {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                }
            }

            @Override
            public void schemeListChanged() {
                CodeStyleSchemesConfigurable.this.myRootSchemesPanel.resetSchemesCombo();
            }

            @Override
            public void schemeChanged(CodeStyleScheme scheme2) {
                if (scheme2 == model.getSelectedScheme()) {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                }
            }
        });
    }

    public boolean hasOwnContent() {
        return true;
    }

    public void disposeUIResources() {
        if (this.myPanels != null) {
            try {
                super.disposeUIResources();
                for (Configurable panel2 : this.myPanels) {
                    panel2.disposeUIResources();
                }
            }
            finally {
                this.myPanels = null;
                this.myRootSchemesPanel = null;
                this.myResetCompleted = false;
                this.myRevertCompleted = false;
                this.myInitResetInvoked = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myResetCompleted) return;
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revert();
        }
    }

    private void resetImpl() {
        this.myModel.reset();
        if (this.myPanels != null) {
            for (Configurable panel2 : this.myPanels) {
                if (panel2 instanceof CodeStyleConfigurableWrapper) {
                    ((CodeStyleConfigurableWrapper)panel2).resetPanel();
                    continue;
                }
                panel2.reset();
            }
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myResetCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myResetCompleted = true;
            }
        }
    }

    public void revert() {
        if (this.myModel.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertCompleted = false;
        }
        if (!this.myRevertCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertCompleted = true;
            }
        }
    }

    private boolean isSomeSchemeModified() {
        if (this.myPanels != null) {
            for (Configurable panel2 : this.myPanels) {
                if (!(panel2 instanceof CodeStyleConfigurableWrapper) || !((CodeStyleConfigurableWrapper)panel2).isPanelModified()) continue;
                return true;
            }
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myModel.apply();
        for (Configurable panel2 : this.myPanels) {
            if (panel2 instanceof CodeStyleConfigurableWrapper) {
                ((CodeStyleConfigurableWrapper)panel2).applyPanel();
                continue;
            }
            panel2.apply();
        }
        CodeStyleSettingsManager.getInstance((Project)this.myProject).fireCodeStyleSettingsChanged(null);
    }

    protected Configurable[] buildConfigurables() {
        CodeStyleGroupProviderFactory groupProviderFactory = new CodeStyleGroupProviderFactory(this.getModel(), this);
        this.myPanels = new ArrayList<Configurable>();
        HashSet addedGroupProviders = ContainerUtil.newHashSet();
        ArrayList providers = ContainerUtil.newArrayList();
        providers.addAll(CodeStyleSettingsProvider.EXTENSION_POINT_NAME.getExtensionList());
        providers.addAll(LanguageCodeStyleSettingsProvider.getSettingsPagesProviders());
        providers.sort((p1, p2) -> {
            String name2;
            if (!p1.getPriority().equals((Object)p2.getPriority())) {
                return p1.getPriority().compareTo((Enum)p2.getPriority());
            }
            String name1 = p1.getConfigurableDisplayName();
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = p2.getConfigurableDisplayName()) == null) {
                name2 = "";
            }
            return name1.compareToIgnoreCase(name2);
        });
        for (CodeStyleSettingsProvider provider : providers) {
            if (provider.getGroup() != null) {
                CodeStyleGroupProvider groupProvider = groupProviderFactory.getGroupProvider(provider.getGroup());
                if (!addedGroupProviders.contains((Object)groupProvider)) {
                    this.myPanels.add(groupProvider.createConfigurable());
                    addedGroupProviders.add(groupProvider);
                }
                groupProvider.addChildProvider(provider);
                continue;
            }
            if (!provider.hasSettingsPage()) continue;
            CodeStyleConfigurableWrapper e = ConfigurableFactory.Companion.getInstance().createCodeStyleConfigurable(provider, this.getModel(), this);
            this.myPanels.add((Configurable)e);
        }
        int size = this.myPanels.size();
        Configurable[] result2 = new Configurable[size > 0 ? size - 1 : 0];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = this.myPanels.get(i + 1);
        }
        return result2;
    }

    void resetCompleted() {
        this.myRevertCompleted = false;
    }

    @NotNull
    CodeStyleSchemesModel getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(1);
        }
        return codeStyleSchemesModel;
    }

    public String getDisplayName() {
        return "Code Style";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle";
    }

    public boolean isModified() {
        if (this.myModel.containsModifiedCodeStyleSettings()) {
            return true;
        }
        for (Configurable panel2 : this.myPanels) {
            if (!panel2.isModified()) continue;
            return true;
        }
        boolean schemeListModified = this.myModel.isSchemeListModified();
        if (schemeListModified) {
            this.myRevertCompleted = false;
        }
        return schemeListModified;
    }

    @NotNull
    public String getId() {
        if ("preferences.sourceCode" == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(2);
        }
        return "preferences.sourceCode";
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> result2 = new HashSet<String>();
        for (Configurable panel2 : this.myPanels) {
            if (!(panel2 instanceof CodeStyleConfigurableWrapper)) continue;
            result2.addAll(((CodeStyleConfigurableWrapper)panel2).processListOptions());
        }
        return result2;
    }

    public boolean isProjectLevel() {
        return this.myModel.isUsePerProjectSettings();
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(@NotNull String name) {
        if (name == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(3);
        }
        return CodeStyleSchemesConfigurable.findSubConfigurable((SearchableConfigurable.Parent)this, name);
    }

    private static SearchableConfigurable findSubConfigurable(SearchableConfigurable.Parent topConfigurable, @NotNull String name) {
        if (name == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(4);
        }
        for (Configurable configurable : topConfigurable.getConfigurables()) {
            SearchableConfigurable child2;
            if (!(configurable instanceof SearchableConfigurable)) continue;
            if (name.equals(configurable.getDisplayName())) {
                return (SearchableConfigurable)configurable;
            }
            if (!(configurable instanceof SearchableConfigurable.Parent) || (child2 = CodeStyleSchemesConfigurable.findSubConfigurable((SearchableConfigurable.Parent)configurable, name)) == null) continue;
            return child2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleSchemesConfigurable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleSchemesConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSchemesPanel";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSubConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

